/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstVarDeclaration;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IParameterStringEnum;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class ODCM
extends AuditRule {
    private static final int SUN_MODE = 0;
    private static final int LPPMF_MODE = 1;
    private static int mode;
    private static final int PUBLIC = 0;
    private static final int PROTECTED = 1;
    private static final int PACKAGE = 2;
    private static final int PRIVATE = 3;

    public ODCM() {
        super(4);
    }

    public void checkType(final AstType type) {
        IAuditMessage m = null;
        AstDeclaration decl = this.findOutOfOrderDeclaration(type);
        if (decl != null) {
            if (mode == 0) {
                m = this.message((AstObject)decl, "AuditODCM.1", new Object[]{decl});
            } else if (mode == 1) {
                m = this.message((AstObject)decl, "AuditODCM.2", new Object[]{decl});
            }
            if (m != null) {
                m.addAutoFix((AutoFix)new ASTAutoFix("AuditODCM.Autofix"){

                    public boolean fix() {
                        boolean swapped;
                        AstDeclaration[] members = type.getMembers();
                        do {
                            swapped = false;
                            int i = 1;
                            while (i < members.length) {
                                if (ODCM.this.swapIsNeeded(members[i - 1], members[i])) {
                                    members[i - 1].swapWith(members[i]);
                                    AstDeclaration tmp = members[i - 1];
                                    members[i - 1] = members[i];
                                    members[i] = tmp;
                                    swapped = true;
                                }
                                ++i;
                            }
                        } while (swapped);
                        return true;
                    }
                });
            }
        }
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        IParameterStringEnum param = (IParameterStringEnum)this.getAnalyzer().getParameterRegistry().getParameter("Declaration order", 4);
        if (param != null) {
            mode = param.getOrdinalValue();
        }
    }

    private static int LPPMFDeclarationOrder(AstDeclaration a, AstDeclaration b) {
        if (!(ODCM.getAccessCode(b) != 0 && ODCM.getAccessCode(b) != 2 || ODCM.getAccessCode(a) != 3 && ODCM.getAccessCode(a) != 1)) {
            return 1;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int sunCodeConventionDeclarationOrder(AstDeclaration a, AstDeclaration b) {
        if (a instanceof AstVarDeclaration) {
            if (!(b instanceof AstVarDeclaration)) {
                return -1;
            }
            if (a.isStatic()) {
                if (b.isStatic()) return ODCM.getAccessCode((AstDeclaration)((AstVarDeclaration)a)) - ODCM.getAccessCode((AstDeclaration)((AstVarDeclaration)b));
                return -1;
            }
            if (!b.isStatic()) return ODCM.getAccessCode((AstDeclaration)((AstVarDeclaration)a)) - ODCM.getAccessCode((AstDeclaration)((AstVarDeclaration)b));
            return 1;
        }
        if (b instanceof AstVarDeclaration) {
            return 1;
        }
        if (a instanceof AstMethod) {
            if (!(b instanceof AstMethod)) return 1;
            AstMethod am = (AstMethod)a;
            AstMethod bm = (AstMethod)b;
            if (am.isConstructor()) {
                if (bm.isConstructor()) return 0;
                return -1;
            }
            if (!bm.isConstructor()) return 0;
            return 1;
        }
        if (!(b instanceof AstMethod)) return 0;
        return -1;
    }

    private AstDeclaration findOutOfOrderDeclaration(AstType type) {
        AstDeclaration[] members = type.getMembers();
        int i = 1;
        while (i < members.length) {
            if (this.swapIsNeeded(members[i - 1], members[i])) {
                return members[i];
            }
            ++i;
        }
        return null;
    }

    private boolean swapIsNeeded(AstDeclaration a, AstDeclaration b) {
        return mode == 0 && ODCM.sunCodeConventionDeclarationOrder(a, b) > 0 || mode == 1 && ODCM.LPPMFDeclarationOrder(a, b) > 0;
    }

    private static int getAccessCode(AstDeclaration decl) {
        if (decl.isPublic()) {
            return 0;
        }
        if (decl.isProtected()) {
            return 1;
        }
        if (decl.isPrivate()) {
            return 3;
        }
        return 2;
    }
}

