/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IParameterRegistry;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class NOM
extends AuditRule {
    static final int DEFAULT_MIN_LENGTH = 4;
    static final int DEFAULT_MAX_DIFFERENCES = 1;
    int minNameLength;
    int maxDifferences;

    public NOM() {
        super(4);
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        IParameterRegistry registry = analyzer.getParameterRegistry();
        this.minNameLength = (int)registry.getIntegerValue("min_name_length", 4L);
        this.maxDifferences = (int)registry.getIntegerValue("max_differences", 1L);
    }

    private boolean isSimilarName(String a, String b) {
        int an = a.length();
        int bn = b.length();
        if (an < this.minNameLength || an + 1 < bn || bn + 1 < an) {
            return false;
        }
        int i = 0;
        int j = 0;
        int nDiffs = 0;
        while (i < an && j < bn) {
            if (a.charAt(i) == b.charAt(j)) {
                ++i;
                ++j;
                continue;
            }
            if (i + 1 < an && a.charAt(i + 1) == b.charAt(j)) {
                i += 2;
                ++j;
            } else if (j + 1 < bn && a.charAt(i) == b.charAt(j + 1)) {
                j += 2;
                ++i;
            } else if (i + 1 < an && j + 1 < bn && a.charAt(i + 1) == b.charAt(j) && a.charAt(i) == b.charAt(j + 1)) {
                i += 2;
                j += 2;
            } else {
                ++i;
                ++j;
            }
            if (++nDiffs <= this.maxDifferences) continue;
            return false;
        }
        return (nDiffs += an - i + (bn - j)) <= this.maxDifferences;
    }

    public void checkMethod(AstMethod dm) {
        AstType superClass;
        AstType cls = dm.getDeclaringType();
        if (!dm.isStatic() && cls.getSuperClass() != null && (superClass = cls.getSuperClass()).findMethod(dm.getElementName(), dm.getSignature(), true) == null) {
            AstMethod[] inheritedMethods = superClass.getAllMethods();
            int j = 0;
            while (j < inheritedMethods.length) {
                AstMethod bm = inheritedMethods[j];
                if (bm.getSignature().equals(dm.getSignature()) && !bm.isStatic() && !bm.isPrivate() && cls.findMethod(bm.getElementName(), bm.getSignature(), false) == null && this.isSimilarName(bm.getElementName(), dm.getElementName())) {
                    this.message((AstObject)dm, "AuditNOM.1", new Object[]{dm, bm});
                    break;
                }
                ++j;
            }
        }
    }
}

