/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstDoubleLiteral;
import com.togethersoft.sca.ast.AstFloatLiteral;
import com.togethersoft.sca.ast.AstIntLiteral;
import com.togethersoft.sca.ast.AstLiteral;
import com.togethersoft.sca.ast.AstLongLiteral;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class NLC
extends AuditRule {
    public NLC() {
        super(2);
    }

    public void checkLiteral(AstLiteral s) {
        if (s.getParent().getObjectKind() != 9 && s.getParent().getObjectKind() != 44 && this.isSuspicious(s)) {
            this.message((AstObject)s);
        }
    }

    private boolean isSuspicious(AstLiteral s) {
        switch (s.getLiteralKind()) {
            case 0: {
                AstIntLiteral l = (AstIntLiteral)s;
                return l.getValue() != 0 && l.getValue() != 1 && l.getValue() != -1;
            }
            case 1: {
                AstLongLiteral l = (AstLongLiteral)s;
                return l.getValue() != 0L && l.getValue() != 1L && l.getValue() != -1L;
            }
            case 2: {
                AstFloatLiteral l = (AstFloatLiteral)s;
                return (double)l.getValue() != 0.0 && (double)l.getValue() != 1.0 && (double)l.getValue() != -1.0;
            }
            case 3: {
                AstDoubleLiteral l = (AstDoubleLiteral)s;
                return l.getValue() != 0.0 && l.getValue() != 1.0 && l.getValue() != -1.0;
            }
        }
        return false;
    }
}

