/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class NEC
extends AuditRule {
    private AstType exceptionType;

    public NEC() {
        super(4);
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        this.exceptionType = this.getProject().getModel().findType("java/lang/Exception");
    }

    public void checkType(AstType type) {
        boolean derivedFromException = type.isDerivedFrom(this.exceptionType);
        boolean endsWithException = type.getElementName().endsWith("Exception");
        if (derivedFromException) {
            if (!endsWithException) {
                IAuditMessage m = this.message((AstObject)type, "AuditNEC.1", new Object[]{type});
            }
        } else if (endsWithException) {
            IAuditMessage iAuditMessage = this.message((AstObject)type, "AuditNEC.2", new Object[]{type});
        }
    }
}

