/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class NC
extends AuditRule {
    public NC() {
        super(4);
    }

    public void checkMethod(AstMethod decl) {
        char first = decl.getElementName().charAt(0);
        if (Character.isUpperCase(first)) {
            this.message((AstObject)decl, "AuditNC.1", null);
        }
    }

    public void checkField(AstField decl) {
        String name = decl.getElementName();
        if (decl.isStatic() && decl.isFinal()) {
            if (!name.toUpperCase().equals(name)) {
                this.message((AstObject)decl, "AuditNC.2", null);
            }
        } else {
            this.checkVariable((AstVariable)decl);
        }
    }

    public void checkVariable(AstVariable decl) {
        char first = decl.getElementName().charAt(0);
        if (Character.isUpperCase(first)) {
            this.message((AstObject)decl, "AuditNC.3", null);
        } else if (first == '_' || first == '$') {
            this.message((AstObject)decl, "AuditNC.4", new Object[]{"" + first});
        }
    }

    public void checkType(AstType decl) {
        char first;
        if ((decl.isClass() || decl.isInterface()) && Character.isLowerCase(first = decl.getElementName().charAt(0))) {
            this.message((AstObject)decl, "AuditNC.5", null);
        }
    }
}

