/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.plugin.audit.AuditRule;
import java.util.HashSet;
import java.util.Iterator;

public class MVDSN
extends AuditRule {
    HashSet methodNames = new HashSet();

    public MVDSN() {
        super(5);
    }

    public void checkType(AstType decl) {
        if (decl.getParent() instanceof AstPackage || decl.getParent() instanceof AstCompilationUnit) {
            this.methodNames.clear();
            AstMethod[] methods = decl.getMethods();
            int i = 0;
            while (i < methods.length) {
                if (!methods[i].isAbstract()) {
                    this.methodNames.add(methods[i]);
                }
                ++i;
            }
        }
    }

    public void checkCompoundStatement(AstCompoundStatement stmt) {
        AstVariable[] vars = stmt.getLocalVariables();
        int i = 0;
        while (i < vars.length) {
            Iterator methods = this.methodNames.iterator();
            while (methods.hasNext()) {
                AstMethod method = (AstMethod)methods.next();
                if (!method.getElementName().equals(vars[i].getElementName())) continue;
                IAuditMessage msg = this.message((AstObject)vars[i]);
                this.message(msg, (AstObject)method);
            }
            ++i;
        }
    }
}

