/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstMethodCallExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.plugin.audit.Audit;
import com.togethersoft.sca.internal.plugin.audit.impl.PushDownRule;

public class MUOS
extends PushDownRule {
    public MUOS() {
        super(4);
    }

    public void checkMethod(AstMethod method) {
        switch (Audit.getScope()) {
            case 0: {
                return;
            }
            case 1: {
                if (method.isPublic() || method.isProtected()) {
                    return;
                }
            }
            case 2: {
                if (!method.isPrivate()) break;
                return;
            }
        }
        if (Audit.isSpecial(method) || method.getOverridden().length > 0 || method.overriddenBy().length > 0) {
            return;
        }
        if (method.getDeclaringType().getSubtypes().length > 0) {
            AstType server = this.areInSameClass(method.getReferences());
            AstType type = method.getDeclaringType();
            if (server != null && server != type && server.isDerivedFrom(type)) {
                this.message((AstObject)method, "AuditMUOS.1", new Object[]{method, server});
            }
        }
    }

    protected AstType getServerType(AstReference ref) {
        if (ref == null) {
            return null;
        }
        if (ref.getObjectKind() == 38) {
            AstMethodCallExpression call = (AstMethodCallExpression)ref;
            if (call.getMethodExpression() instanceof AstReference) {
                return this.getServerRef((AstReference)call.getMethodExpression());
            }
            return null;
        }
        return null;
    }
}

