/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstForStatement;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class MSOL
extends AuditRule {
    private AstStatement prevStmt;

    public MSOL() {
        super(5);
    }

    public void checkCompilationUnit(AstCompilationUnit file) {
        this.prevStmt = null;
    }

    public void checkStatement(final AstStatement stmt) {
        IAuditMessage m;
        if (this.check(stmt) && this.prevStmt.getPosition().getEndLine() == stmt.getPosition().getStartLine() && (m = this.message((AstObject)stmt)) != null) {
            final AstStatement prev = this.prevStmt;
            m.addAutoFix((AutoFix)new ASTAutoFix("AuditMSOL.Autofix"){

                public boolean fix() {
                    stmt.setPosition(prev.getPosition());
                    return true;
                }
            });
            ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
            fix.setTabSize(this.getProject().getTabSize());
            fix.insertLine(stmt.getPosition(), "");
            fix.indent(prev.getPosition().getStartColumn());
        }
        if (stmt.getObjectKind() != 21) {
            this.prevStmt = stmt;
        }
    }

    private boolean check(AstStatement stmt) {
        if (this.prevStmt == null) {
            return false;
        }
        if (stmt.getObjectKind() == 21) {
            return false;
        }
        if (stmt.getParent().getObjectKind() == 17) {
            return stmt == ((AstForStatement)stmt.getParent()).getBody();
        }
        return true;
    }
}

