/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstAssignmentExpression;
import com.togethersoft.sca.ast.AstBinaryExpression;
import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.plugin.audit.AuditRule;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class MSC
extends AuditRule {
    private int maxConcat;
    LinkedList scopeList = new LinkedList();

    public MSC() {
        super(3);
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        this.maxConcat = (int)analyzer.getParameterRegistry().getIntegerValue("Max concatenations", 3L);
    }

    public void checkExpression(AstExpression expr) {
        AstDeclaration decl;
        if (this.scopeList.isEmpty()) {
            return;
        }
        AstReference ref = MSC.isConcatString(expr);
        if (ref != null && (decl = ref.getReferencedElement()) != null) {
            HashMap violators = (HashMap)this.scopeList.getLast();
            LinkedList<AstReference> entry = (LinkedList<AstReference>)violators.get(decl);
            if (entry != null) {
                entry.add(ref);
            } else {
                entry = new LinkedList<AstReference>();
                entry.add(ref);
                violators.put(decl, entry);
            }
        }
    }

    public static AstReference isConcatString(AstExpression expr) {
        AstAssignmentExpression asgn;
        if (!expr.getType().getTypeName().equals("java/lang/String")) {
            return null;
        }
        if (expr.getObjectKind() == 32 && (asgn = (AstAssignmentExpression)expr).getLeftOperand() instanceof AstReference) {
            AstReference ref = (AstReference)asgn.getLeftOperand();
            if (asgn.getExpressionKind() == 1) {
                return ref;
            }
            AstReference op = MSC.getLeftmostOperand(asgn.getRightOperand());
            if (op != null && op.getReferencedElement() != null && op.getReferencedElement() == ref.getReferencedElement()) {
                return ref;
            }
        }
        return null;
    }

    private static AstReference getLeftmostOperand(AstExpression expr) {
        AstBinaryExpression binop;
        if (expr instanceof AstBinaryExpression && (binop = (AstBinaryExpression)expr).getExpressionKind() == 4) {
            if (binop.getLeftOperand() instanceof AstReference) {
                return (AstReference)binop.getLeftOperand();
            }
            return MSC.getLeftmostOperand(binop.getLeftOperand());
        }
        return null;
    }

    public void checkCompoundStatement(AstCompoundStatement stmt) {
        this.scopeList.add(new HashMap());
    }

    public void leaveCompoundStatement(AstCompoundStatement stmt) {
        HashMap violators = (HashMap)this.scopeList.removeLast();
        Iterator iterator = violators.values().iterator();
        while (iterator.hasNext()) {
            LinkedList entry = (LinkedList)iterator.next();
            if (entry.size() <= this.maxConcat) continue;
            this.message((AstObject)entry.getFirst());
        }
    }
}

