/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstMember;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.dataflow.IMethod;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.internal.plugin.audit.Audit;
import com.togethersoft.sca.internal.plugin.audit.impl.Util;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class MNU
extends AuditRule {
    public MNU() {
        super(8);
    }

    public void checkMethod(IMethod method, final AstMethod ast) {
        if (!Audit.hasFullInfo((AstMember)ast)) {
            return;
        }
        if (Util.isReadWriteMethod(ast) || Audit.isSpecial(ast)) {
            return;
        }
        if (!method.isReachable()) {
            IAuditMessage m = this.message((AstObject)ast, "AuditMNU.1", new Object[]{ast});
        } else if (!ast.isPrivate()) {
            AstMethod[] hierarchy = Audit.getMethodHierarchy(ast);
            int i = 0;
            while (i < hierarchy.length) {
                if (hierarchy[i].getReferences().length > 0) {
                    return;
                }
                ++i;
            }
            IAuditMessage m = this.message((AstObject)ast, "AuditMNU.1", new Object[]{ast});
            if (m != null) {
                m.addAutoFix((AutoFix)new ASTAutoFix("AuditMNU.Autofix"){

                    public boolean fix() {
                        ast.remove();
                        return true;
                    }
                });
                ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
                fix.setTabSize(this.getProject().getTabSize());
                fix.removeBlock(ast.getPosition());
            }
        }
    }
}

