/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.SwitchTuple;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class MMCSS
extends AuditRule {
    public MMCSS() {
        super(8);
    }

    public void checkTuple(ITuple tuple, IVal[] operands, IValueDomain[] values, IValueDomain result) {
        if (tuple.getCode() == 42 && !((SwitchTuple)tuple).hasDefault() && values[0] instanceof IIntegralDomain) {
            IIntegralDomain selector = (IIntegralDomain)values[0];
            long min = selector.getLowValue();
            long max = selector.getHighValue();
            long labelMin = Long.MAX_VALUE;
            long labelMax = Long.MIN_VALUE;
            int i = 1;
            while (i < values.length) {
                if (values[i] instanceof IIntegralDomain) {
                    long value = ((IIntegralDomain)values[i]).getLowValue();
                    if (value < labelMin) {
                        labelMin = value;
                    } else if (value > labelMax) {
                        labelMax = value;
                    }
                }
                ++i;
            }
            if (min < labelMin || max > labelMax) {
                this.message(tuple.getAstObject(), new Object[]{selector, new Long(labelMin), new Long(labelMax)});
            }
        }
    }
}

