/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstBinaryExpression;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstObjectFactory;
import com.togethersoft.sca.core.Factory;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.internal.plugin.audit.impl.Util;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class MLOWP
extends AuditRule {
    public MLOWP() {
        super(2);
    }

    public void checkBinaryExpression(final AstBinaryExpression expr) {
        if (Util.isLogicalOp((AstExpression)expr)) {
            IAuditMessage m;
            int cop2;
            final int cop = expr.getExpressionKind();
            final int cop1 = Util.isLogicalOp(expr.getLeftOperand()) ? ((AstBinaryExpression)expr.getLeftOperand()).getExpressionKind() : cop;
            int n = cop2 = Util.isLogicalOp(expr.getRightOperand()) ? ((AstBinaryExpression)expr.getRightOperand()).getExpressionKind() : cop;
            if ((cop1 != cop || cop2 != cop) && (m = this.message((AstObject)expr)) != null) {
                m.addAutoFix((AutoFix)new ASTAutoFix("AuditMLOWP.Autofix"){

                    public boolean fix() {
                        AstObjectFactory factory = Factory.getObjectFactory();
                        if (cop1 != cop) {
                            expr.getLeftOperand().replaceWith((AstObject)factory.createAstParenthesizedExpression(expr.getLeftOperand()), (AstObject)expr);
                        }
                        if (cop2 != cop) {
                            expr.getRightOperand().replaceWith((AstObject)factory.createAstParenthesizedExpression(expr.getRightOperand()), (AstObject)expr);
                        }
                        return true;
                    }
                });
                ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
                fix.setTabSize(this.getProject().getTabSize());
                if (cop1 != cop) {
                    fix.insert(expr.getLeftOperand().getPosition(), "(");
                    fix.insertAfter(expr.getLeftOperand().getPosition(), ")");
                }
                if (cop2 != cop) {
                    fix.insert(expr.getRightOperand().getPosition(), "(");
                    fix.insertAfter(expr.getRightOperand().getPosition(), ")");
                }
            }
        }
    }
}

