/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class MDL
extends AuditRule {
    public MDL() {
        super(8);
    }

    public void checkTuple(ITuple tuple, IVal[] operands, IValueDomain[] values, IValueDomain result) {
        if (tuple.getCode() != 28) {
            return;
        }
        if (result instanceof IIntegralDomain && result.getValueType() < values[0].getValueType()) {
            IIntegralDomain dst = (IIntegralDomain)result;
            if (!(dst.getZeroBitMask() != -1L || values[0] instanceof IIntegralDomain && ((IIntegralDomain)values[0]).getZeroBitMask() == -1L)) {
                return;
            }
            if (values[0] instanceof IIntegralDomain) {
                int sh2;
                int sh1;
                IIntegralDomain src = (IIntegralDomain)values[0];
                if (dst.getOnesBitMask() != src.getOnesBitMask() || src.getHighValue() < dst.getLowValue() || src.getLowValue() > dst.getHighValue()) {
                    return;
                }
                if (src.getLowValue() >= dst.minTypeValue() && src.getHighValue() <= dst.maxTypeValue()) {
                    return;
                }
                long mask = src.getZeroBitMask() ^ 0xFFFFFFFFFFFFFFFFL;
                if (dst.getValueType() == 1 && mask == 65535L) {
                    return;
                }
                if (mask != -1L && mask << (sh1 = 64 - src.bitSize()) >>> sh1 != mask << (sh2 = 64 - dst.bitSize()) >>> sh2) {
                    this.message(tuple.getAstObject(), new Object[]{new Long(mask)});
                }
            }
        }
    }
}

