/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMember;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstModifier;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.dataflow.IField;
import com.togethersoft.sca.dataflow.IMethod;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.internal.plugin.audit.Audit;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class MCP
extends AuditRule {
    IAuditMessage m = null;

    public MCP() {
        super(8);
    }

    public void checkField(IField fld, AstField field) {
        if (!this.checkMember((AstMember)field)) {
            return;
        }
        if (this.isEligible((AstMember)field)) {
            this.m = this.message((AstObject)field, "AuditMCP.2", new Object[]{field});
        }
        this.autoFix((AstMember)field);
    }

    public void checkMethod(IMethod mth, AstMethod method) {
        if (!this.checkMember((AstMember)method) || !mth.isReachable() || Audit.isSpecial(method) || method.getOverridden().length > 0 || method.overriddenBy().length > 0) {
            return;
        }
        if (this.isEligible((AstMember)method)) {
            this.m = this.message((AstObject)method, "AuditMCP.1", new Object[]{method});
        }
        this.autoFix((AstMember)method);
    }

    public boolean checkMember(AstMember member) {
        switch (Audit.getScope()) {
            case 0: {
                return false;
            }
            case 1: {
                if (member.isPublic() || member.isProtected()) {
                    return false;
                }
            }
            case 2: {
                if (!member.isPrivate()) break;
                return false;
            }
        }
        return true;
    }

    private void autoFix(final AstMember member) {
        if (this.m != null) {
            this.m.addAutoFix((AutoFix)new ASTAutoFix("AuditMCP.Autofix"){

                public boolean fix() {
                    member.setDeclaredModifiers(member.getDeclaredModifiers() & 0xFFFFFFFA | 2);
                    return true;
                }
            });
            ESAutoFix fix = new ESAutoFix(this.m, AuditRule.getAutoFixName(this.m));
            AstModifier[] modifiers = member.getModifiersList();
            fix.insert(member.getPosition(), "private ");
            fix.setTabSize(this.getProject().getTabSize());
            int i = 0;
            while (i < modifiers.length) {
                if ((modifiers[i].getModifier() & 5) != 0) {
                    fix.removeWithSpace(modifiers[i].getPosition());
                }
                ++i;
            }
        }
    }

    private boolean isEligible(AstMember member) {
        AstType serverType = member.getDeclaringType();
        AstReference[] refs = member.getReferences();
        if (refs.length == 0) {
            return false;
        }
        int i = 0;
        while (i < refs.length) {
            if (refs[i].getDeclaringType() != serverType) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

