/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.plugin.audit.AuditRule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class MC
extends AuditRule {
    private Hashtable classTable = new Hashtable();

    public MC() {
        super(4);
    }

    public void checkModel(AstModel model) {
        AstPackage[] packages = model.getPackages();
        int i = 0;
        while (i < packages.length) {
            this.processPackage(packages[i]);
            ++i;
        }
    }

    private void processPackage(AstPackage pkg) {
        this.sort(this.classTable);
        AstCompilationUnit[] units = pkg.getCompilationUnits();
        int i = 0;
        while (i < units.length) {
            AstType[] types = units[i].getTypes();
            int k = 0;
            while (k < types.length) {
                if (this.isMisplaced(types[k])) {
                    NumPair pair = (NumPair)this.classTable.get(types[k]);
                    Iterator it = pair.packageSet.iterator();
                    ArrayList<AstPackage> packages = new ArrayList<AstPackage>();
                    while (it.hasNext()) {
                        AstPackage thatPackage = (AstPackage)it.next();
                        if (thatPackage.getCompilationUnits().length <= 0 || this.maybeMisplaced(false, types[k], thatPackage)) continue;
                        packages.add(thatPackage);
                    }
                    if (packages.size() > 0) {
                        String[] packagesNames = new String[packages.size()];
                        int j = 0;
                        while (j < packagesNames.length) {
                            AstPackage thatPackage = (AstPackage)packages.get(j);
                            packagesNames[j] = thatPackage.getQualifiedName();
                            ++j;
                        }
                        IAuditMessage message = this.message((AstObject)types[k], new Object[]{types[k], packagesNames});
                        if (message != null) {
                            int j2 = 0;
                            while (j2 < packagesNames.length) {
                                AstPackage thatPackage = (AstPackage)packages.get(j2);
                                this.message(message, (AstObject)thatPackage, "AuditMC.1", new Object[]{types[k], thatPackage});
                                ++j2;
                            }
                        }
                    }
                }
                ++k;
            }
            ++i;
        }
        AstPackage[] subPkgs = pkg.getSubpackages();
        int i2 = 0;
        while (i2 < subPkgs.length) {
            this.processPackage(subPkgs[i2]);
            ++i2;
        }
    }

    public void checkType(AstType type) {
        AstPackage thisPackage = type.getPackage();
        this.maybeMisplaced(true, type, thisPackage);
    }

    private boolean isMisplaced(AstType type) {
        NumPair pair = (NumPair)this.classTable.get(type);
        double percent = (double)pair.key / (double)this.classTable.size();
        return percent < 0.25 && pair.maybeMissplaced;
    }

    private boolean maybeMisplaced(boolean toTable, AstType type, AstPackage thisPackage) {
        boolean rule;
        int mNOED = 0;
        HashSet<AstPackage> packageSet = new HashSet<AstPackage>();
        packageSet.add(type.getPackage());
        AstType[] classes = type.getImportCouplings();
        int k = 0;
        while (k < classes.length) {
            AstPackage thatPackage = classes[k].getPackage();
            if (toTable) {
                packageSet.add(thatPackage);
            }
            if (thatPackage != thisPackage) {
                ++mNOED;
            }
            ++k;
        }
        int length = classes.length;
        double mCL = length != 0 ? (double)((classes.length - mNOED) / classes.length) : 0.0;
        int mDD = packageSet.size() - 1;
        NumPair pair = null;
        boolean bl = rule = mCL < 0.33 && mNOED >= 6 && mDD <= 3;
        if (toTable) {
            pair = new NumPair(this.classTable.size(), mNOED, rule, packageSet);
            this.classTable.put(type, pair);
            return false;
        }
        return rule;
    }

    private void sort(Hashtable table) {
        NumPair[] pairs = table.values().toArray(new NumPair[0]);
        int i = 0;
        while (i < pairs.length) {
            int k = i;
            int j = i + 1;
            while (j < pairs.length) {
                if (pairs[k].mNOED < pairs[j].mNOED) {
                    k = j;
                }
                ++j;
            }
            if (k != i) {
                NumPair pair = pairs[k];
                pairs[k] = pairs[i];
                pairs[i] = pair;
            }
            pairs[i].key = i;
            ++i;
        }
    }

    public String getExplainMessage(AstObject ast, String messageId, Object[] values) {
        if (!"AuditMC.1".equals(messageId)) {
            return super.getExplainMessage(ast, messageId, values);
        }
        return null;
    }

    private class NumPair {
        public int key;
        public int mNOED;
        public boolean maybeMissplaced;
        public HashSet packageSet;

        NumPair(int key, int mNOED, boolean maybeMissplaced, HashSet packageSet) {
            this.key = key;
            this.mNOED = mNOED;
            this.maybeMissplaced = maybeMissplaced;
            this.packageSet = packageSet;
        }
    }
}

