/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstExpressionStatement;
import com.togethersoft.sca.ast.AstFieldReference;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstMethodCallExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReturnStatement;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.plugin.audit.AuditRule;
import java.util.HashMap;

public class LMC
extends AuditRule {
    private HashMap map = new HashMap();

    public LMC() {
        super(4);
    }

    private MethodDesc getMethod(AstMethod method) {
        MethodDesc desc = (MethodDesc)this.map.get(method);
        if (desc == null) {
            desc = new MethodDesc();
            this.map.put(method, desc);
        }
        return desc;
    }

    public void checkMethod(AstMethod method) {
        MethodDesc desc = this.getMethod(method);
        if (desc.getLMC() < 0) {
            desc.setLMC(0);
            AstMethod delegate = this.getDelegateMethod(method);
            if (delegate != null) {
                this.checkMethod(delegate);
                MethodDesc delegateDesc = this.getMethod(delegate);
                desc.setLMC(delegateDesc.getLMC() + 1);
            }
            if (desc.getLMC() > 2) {
                this.message((AstObject)method);
            }
        }
    }

    private AstMethod getDelegateMethod(AstMethod method) {
        AstMethodCallExpression call;
        AstCompoundStatement body = method.getBody();
        if (body == null) {
            return null;
        }
        AstStatement[] stmts = body.getStatements();
        if (stmts.length != 1) {
            return null;
        }
        AstExpression expr = null;
        if (stmts[0].getObjectKind() == 23) {
            expr = ((AstExpressionStatement)stmts[0]).getExpression();
        } else if (stmts[0].getObjectKind() == 14) {
            expr = ((AstReturnStatement)stmts[0]).getReturnExpression();
        }
        if (expr == null) {
            return null;
        }
        if (expr.getObjectKind() == 38 && this.isChainCall(call = (AstMethodCallExpression)expr)) {
            return (AstMethod)call.getReferencedElement();
        }
        return null;
    }

    private boolean isChainCall(AstMethodCallExpression call) {
        AstExpression name = call.getMethodExpression();
        do {
            if (name.getObjectKind() == 40) {
                return true;
            }
            if (name.getObjectKind() != 36) {
                return false;
            }
            name = ((AstFieldReference)name).getBaseExpression();
        } while (name != null);
        return false;
    }

    private class MethodDesc {
        private int lmc = -1;

        private MethodDesc() {
        }

        public int getLMC() {
            return this.lmc;
        }

        public void setLMC(int lmc) {
            this.lmc = lmc;
        }
    }
}

