/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.dataflow.IMethod;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class IR
extends AuditRule {
    private boolean global = true;

    public IR() {
        super(8);
    }

    public void checkMethod(IMethod method, AstMethod ast) {
        ITuple[] recCalls;
        if (this.global) {
            this.globalRecursion();
            this.global = false;
        }
        if ((recCalls = method.getRecursiveCalls()) != null) {
            IAuditMessage msg = this.message(method.getAstObject(), "AuditIR.1", null);
            int i = 0;
            while (i < recCalls.length) {
                this.message(msg, recCalls[i].getAstObject(), "AuditIR.2", new Object[]{new Integer(i)});
                ++i;
            }
        }
    }

    private void globalRecursion() {
        Method[][] loops = this.getDataFlowAnalyzer().getProject().getRecursiveLoops();
        if (loops != null) {
            int i = 0;
            while (i < loops.length) {
                IAuditMessage msg = this.message(loops[i][0].getAstObject(), "AuditIR.3", null);
                int j = 0;
                while (j < loops[i].length) {
                    this.message(msg, loops[i][j].getAstObject(), "%qm", new Object[]{loops[i][j].getAstObject()});
                    ++j;
                }
                ++i;
            }
        }
    }
}

