/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstImport;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IParameterInteger;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.plugin.audit.AuditRule;
import java.util.HashSet;
import java.util.Iterator;

public class ILC
extends AuditRule {
    private long maxQualifiedImports;
    private AstPackage javaLangPackage;

    public ILC() {
        super(4);
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        IParameterInteger param = (IParameterInteger)this.getAnalyzer().getParameterRegistry().getParameter("Max number of qualified imports", 0);
        if (param != null) {
            this.maxQualifiedImports = param.getValue();
        }
        this.javaLangPackage = this.getProject().getModel().findPackage("java/lang");
    }

    public void checkCompilationUnit(AstCompilationUnit decl) {
        AstPackage thisPackage = decl.getPackage();
        AstImport[] imports = decl.getImports();
        this.checkISFP(thisPackage, imports);
        this.checkDID(imports);
        this.checkIINU(decl);
        if (this.maxQualifiedImports > 0L) {
            this.checkRDI(decl, imports);
        }
        this.checkEIJLC(imports);
    }

    private void uselessImport(String text, final AstImport imp) {
        IAuditMessage m = this.message((AstObject)imp, text, null);
        if (m != null) {
            m.addAutoFix((AutoFix)new ASTAutoFix("AuditILC.Autofix"){

                public boolean fix() {
                    imp.remove();
                    return true;
                }
            });
            ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
            fix.setTabSize(this.getProject().getTabSize());
            fix.removeBlock(imp.getPosition());
        }
    }

    private void checkISFP(AstPackage thisPackage, AstImport[] imports) {
        int i = 0;
        while (i < imports.length) {
            AstImport imp = imports[i];
            if (imp.getReferencedElement() instanceof AstPackage) {
                if (imp.getReferencedElement() == thisPackage) {
                    this.uselessImport("AuditILC.1", imp);
                }
            } else if (imp.getReferencedElement() instanceof AstType && imp.getReferencedElement().getPackage() == thisPackage) {
                this.uselessImport("AuditILC.2", imp);
            }
            ++i;
        }
    }

    private void checkDID(AstImport[] imports) {
        int i = 0;
        while (i < imports.length - 1) {
            int j = i + 1;
            while (j < imports.length) {
                AstDeclaration d1 = imports[i].getReferencedElement();
                AstDeclaration d2 = imports[j].getReferencedElement();
                if (d1 != null && d2 != null) {
                    if (d1 == d2) {
                        this.uselessImport("AuditILC.3", imports[j]);
                    } else {
                        if (d1.getObjectKind() == 8 && d1.getPackage() == d2) {
                            this.uselessImport("AuditILC.3", imports[j]);
                        }
                        if (d2.getObjectKind() == 8 && d2.getPackage() == d1) {
                            this.uselessImport("AuditILC.3", imports[j]);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void checkIINU(AstCompilationUnit decl) {
        HashSet<AstType> set = new HashSet<AstType>();
        AstType[] types = decl.getTypes();
        int i = 0;
        while (i < types.length) {
            AstType[] importTypes = types[i].getImportCouplings();
            int j = 0;
            while (j < importTypes.length) {
                set.add(importTypes[j]);
                ++j;
            }
            ++i;
        }
        AstImport[] imports = decl.getImports();
        int i2 = 0;
        while (i2 < imports.length) {
            AstDeclaration element = imports[i2].getReferencedElement();
            if (element instanceof AstType && !set.contains(element)) {
                this.uselessImport("AuditILC.4", imports[i2]);
            }
            ++i2;
        }
    }

    private void checkRDI(AstCompilationUnit decl, AstImport[] imports) {
        HashSet<AstType> set = new HashSet<AstType>();
        AstType[] types = decl.getTypes();
        int i = 0;
        while (i < types.length) {
            AstType[] importTypes = types[i].getImportCouplings();
            int j = 0;
            while (j < importTypes.length) {
                set.add(importTypes[j]);
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < imports.length) {
            int numTypes = 0;
            if (imports[i2].getReferencedElement() instanceof AstPackage) {
                AstPackage importedPackage = (AstPackage)imports[i2].getReferencedElement();
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    AstType t = (AstType)it.next();
                    if (t.getPackage() != importedPackage) continue;
                    ++numTypes;
                }
            }
            if (numTypes > 0 && (long)numTypes <= this.maxQualifiedImports) {
                this.message((AstObject)imports[i2], "AuditILC.5", null);
            }
            ++i2;
        }
    }

    private void checkEIJLC(AstImport[] imports) {
        int i = 0;
        while (i < imports.length) {
            AstImport imp = imports[i];
            if (imp.getReferencedElement() instanceof AstPackage) {
                if (imp.getReferencedElement() == this.javaLangPackage) {
                    this.uselessImport("AuditILC.6", imp);
                }
            } else if (imp.getReferencedElement() instanceof AstType && imp.getReferencedElement().getPackage() == this.javaLangPackage) {
                this.uselessImport("AuditILC.7", imp);
            }
            ++i;
        }
    }
}

