/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstObjectCreationExpression;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class ICSBF
extends AuditRule {
    public ICSBF() {
        super(2);
    }

    public void checkObjectCreationExpression(AstObjectCreationExpression expr) {
        IAuditMessage m;
        final AstType type = expr.getObjectType();
        if (type != null && type.isSource() && !type.isFinal() && (m = this.message((AstObject)type)) != null) {
            m.addAutoFix((AutoFix)new ASTAutoFix("AuditICSBF.Autofix"){

                public boolean fix() {
                    type.setDeclaredModifiers(type.getDeclaredModifiers() | 0x10);
                    return true;
                }
            });
            ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
            fix.setTabSize(this.getProject().getTabSize());
            fix.insert(type.getPosition(), "final ");
        }
    }
}

