/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMember;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstVarDeclaration;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.internal.plugin.audit.Audit;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class FNU
extends AuditRule {
    public FNU() {
        super(4);
    }

    public void checkField(final AstField field) {
        IAuditMessage m;
        if (!Audit.hasFullInfo((AstMember)field)) {
            return;
        }
        if (field.getReferences().length == 0 && !field.getElementName().equals("serialVersionUID") && !field.getElementName().equals("serialPersistentFields") && (m = this.message((AstObject)field, "AuditFNU.1", new Object[]{field})) != null) {
            AstVarDeclaration decl = (AstVarDeclaration)field.getParent();
            m.addAutoFix((AutoFix)new ASTAutoFix("AuditFNU.Autofix"){

                public boolean fix() {
                    AstVarDeclaration decl = (AstVarDeclaration)field.getParent();
                    if (decl.getFields().length == 1) {
                        decl.remove();
                    } else {
                        field.remove();
                    }
                    return true;
                }
            });
            if (decl.getFields().length == 1) {
                ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
                fix.setTabSize(this.getProject().getTabSize());
                fix.removeBlock(decl.getPosition());
            }
        }
    }
}

