/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstBinaryExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.plugin.audit.impl.Util;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class EVC
extends AuditRule {
    public EVC() {
        super(10);
    }

    public void checkTuple(ITuple tuple, IVal[] operands, IValueDomain[] values, IValueDomain result) {
        if (result != null && !Util.isZero(result) && result.isConstant() && !Util.isConstant(operands)) {
            switch (tuple.getCode()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 13: 
                case 14: 
                case 50: {
                    this.message(tuple.getAstObject());
                    break;
                }
            }
        }
    }

    public void checkBinaryExpression(AstBinaryExpression expr) {
        if (expr.getExpressionKind() == 9) {
            AstType right = expr.getRightOperand().getType().getBaseType();
            AstType left = expr.getLeftOperand().getType().getBaseType();
            if (left != null && right != null && left.isDerivedFrom(right)) {
                this.message((AstObject)expr);
            }
        }
    }
}

