/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.dataflow.IMethod;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.internal.plugin.audit.impl.Util;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class ENT
extends AuditRule {
    private static final AstTypeReference[] NO_EXCEPTIONS = new AstTypeReference[0];
    private AstType runtimeException;

    public ENT() {
        super(8);
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        this.runtimeException = this.getProject().getModel().findType("java/lang/RuntimeException");
    }

    public void checkMethod(IMethod method, AstMethod ast) {
        if (this.isMethodOverridable(ast)) {
            return;
        }
        if (method.callsUnknown() || ast.isAbstract() || Util.isReadWriteMethod(ast)) {
            return;
        }
        AstTypeReference[] declared = ast.getExceptionTypes();
        AstMethod[] overriderAsts = ast.overriddenBy();
        IMethod[] overriders = new IMethod[overriderAsts.length];
        int i = 0;
        while (i < overriders.length) {
            overriders[i] = this.getDataFlowAnalyzer().getFor(overriderAsts[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < declared.length) {
            block7: {
                if (!(declared[i2].getKind() == 0 || this.runtimeException != null && declared[i2].isDerivedFrom((AstTypeReference)this.runtimeException) || this.isThrown(declared[i2], method))) {
                    int j = 0;
                    while (j < overriders.length) {
                        if (overriders[j] == null || !this.isThrown(declared[i2], overriders[j])) {
                            ++j;
                            continue;
                        }
                        break block7;
                    }
                    this.message((AstObject)ast, "AuditENT.1", new Object[]{declared[i2].getTypeName()});
                }
            }
            ++i2;
        }
    }

    private boolean isThrown(AstTypeReference declared, IMethod method) {
        AstTypeReference[] thrown = method.getExceptions();
        if (thrown == null) {
            thrown = NO_EXCEPTIONS;
        }
        int i = 0;
        while (i < thrown.length) {
            if (thrown[i].isDerivedFrom(declared)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

