/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstDoStatement;
import com.togethersoft.sca.ast.AstForStatement;
import com.togethersoft.sca.ast.AstIfStatement;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstObjectFactory;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstWhileStatement;
import com.togethersoft.sca.core.Factory;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class EBWB
extends AuditRule {
    public EBWB() {
        super(1);
    }

    public void checkIfStatement(AstIfStatement stmt) {
        this.checkBody(stmt.getThenStatement());
        AstStatement elseStmt = stmt.getElseStatement();
        if (elseStmt != null && elseStmt.getObjectKind() != 16) {
            this.checkBody(elseStmt);
        }
    }

    public void checkForStatement(AstForStatement stmt) {
        this.checkBody(stmt.getBody());
    }

    public void checkWhileStatement(AstWhileStatement stmt) {
        this.checkBody(stmt.getBody());
    }

    public void checkDoStatement(AstDoStatement stmt) {
        this.checkBody(stmt.getBody());
    }

    private void checkBody(final AstStatement stmt) {
        IAuditMessage m;
        if (stmt.getObjectKind() != 21 && stmt.getObjectKind() != 22 && (m = this.message((AstObject)stmt)) != null) {
            m.addAutoFix((AutoFix)new ASTAutoFix("AuditEBWB.Autofix"){

                public boolean fix() {
                    AstObjectFactory factory = Factory.getObjectFactory();
                    AstStatement parent = (AstStatement)stmt.getParent();
                    AstStatement[] stmts = new AstStatement[]{stmt};
                    stmt.replaceWith((AstObject)factory.createAstCompoundStatement(stmts, parent), (AstObject)parent);
                    return true;
                }
            });
            ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
            fix.setTabSize(this.getProject().getTabSize());
            fix.insert(stmt.getPosition(), "{");
            fix.insertAfter(stmt.getPosition(), "}");
        }
    }
}

