/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IParameterBoolean;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.plugin.audit.AuditRule;
import java.util.ArrayList;

public class DAFC
extends AuditRule {
    private static final int FIND_ABSTRACT = 0;
    private static final int FIND_FINAL = 1;
    static boolean checkAbstract;
    static boolean checkFinal;

    public DAFC() {
        super(4);
    }

    public void checkType(AstType type) {
        if (type.isAbstract() && checkAbstract) {
            IAuditMessage message;
            AstMethod[] abstractMethods = this.checkMethods(type, 0);
            if (abstractMethods.length == 0) {
                message = this.message((AstObject)type, "AuditDAFC.1", new Object[]{type});
            } else if (abstractMethods.length == type.getMethods().length) {
                message = this.message((AstObject)type, "AuditDAFC.5", new Object[]{type});
            }
            AstDeclaration[] constructors = this.checkMembers((AstDeclaration[])type.getConstructors(), false);
            this.generateMessages(type, constructors, "AuditDAFC.2", "AuditDAFC.2.1");
        }
        if (type.isFinal() && checkFinal) {
            AstDeclaration[] members = this.checkMembers(type.getMembers(), true);
            this.generateMessages(type, members, "AuditDAFC.3", "AuditDAFC.3.1");
            AstMethod[] finalMethods = this.checkMethods(type, 1);
            this.generateMessages(type, (AstDeclaration[])finalMethods, "AuditDAFC.4", "AuditDAFC.4.1");
        }
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        IParameterBoolean param = (IParameterBoolean)this.getAnalyzer().getParameterRegistry().getParameter("Check abstract classes", 1);
        if (param != null) {
            checkAbstract = param.getValue();
        }
        if ((param = (IParameterBoolean)this.getAnalyzer().getParameterRegistry().getParameter("Check final classes", 1)) != null) {
            checkFinal = param.getValue();
        }
    }

    private AstMethod[] checkMethods(AstType type, int flag) {
        ArrayList<AstMethod> methodsList = new ArrayList<AstMethod>();
        AstMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (flag == 0 && methods[i].isAbstract()) {
                methodsList.add(methods[i]);
            } else if (flag == 1 && methods[i].isFinal()) {
                methodsList.add(methods[i]);
            }
            ++i;
        }
        return methodsList.toArray(new AstMethod[methodsList.size()]);
    }

    private AstDeclaration[] checkMembers(AstDeclaration[] members, boolean countProtected) {
        ArrayList<AstDeclaration> membersList = new ArrayList<AstDeclaration>();
        int i = 0;
        while (i < members.length) {
            if (countProtected ^ !members[i].isProtected()) {
                membersList.add(members[i]);
            }
            ++i;
        }
        return membersList.toArray(new AstDeclaration[membersList.size()]);
    }

    private void generateMessages(AstType type, AstDeclaration[] decls, String msg, String subMsg) {
        if (decls.length > 0) {
            IAuditMessage message = this.message((AstObject)type, msg, new Object[]{type});
            int i = 0;
            while (i < decls.length) {
                this.message(message, (AstObject)decls[i], subMsg, new Object[]{decls[i]});
                ++i;
            }
        }
    }
}

