/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.internal.plugin.audit.impl.Util;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class CVSBF
extends AuditRule {
    public CVSBF() {
        super(4);
    }

    public void checkVariable(final AstVariable decl) {
        IAuditMessage m;
        if (CVSBF.shouldBeConstant(decl) && (m = this.message((AstObject)decl, "AuditCVSBF.1", new Object[]{decl})) != null) {
            m.addAutoFix((AutoFix)new ASTAutoFix("AuditCVSBF.Autofix"){

                public boolean fix() {
                    decl.setDeclaredModifiers(decl.getDeclaredModifiers() | 0x10);
                    return true;
                }
            });
            ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
            fix.setTabSize(this.getProject().getTabSize());
            fix.insert(decl.getParent().getPosition(), "final ");
        }
    }

    static boolean shouldBeConstant(AstVariable decl) {
        if (decl.getInitializer() == null) {
            return false;
        }
        if (decl.getInitializer().getObjectKind() != 37) {
            return false;
        }
        if (!Util.isPrimitive(decl.getType())) {
            return false;
        }
        if (decl.isFinal()) {
            return false;
        }
        AstReference[] refs = decl.getReferences();
        int i = 0;
        while (i < refs.length) {
            if (Util.isChanging((AstObject)refs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

