/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstSwitchStatement;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class CU
extends AuditRule {
    public CU() {
        super(8);
    }

    public void checkTuple(ITuple tuple, IVal[] operands, IValueDomain[] values, IValueDomain result) {
        if (tuple.getCode() == 42 && values[0] instanceof IIntegralDomain) {
            IIntegralDomain selector = (IIntegralDomain)values[0];
            long min = selector.getLowValue();
            long max = selector.getHighValue();
            long mask1 = selector.getZeroBitMask() ^ 0xFFFFFFFFFFFFFFFFL;
            int i = 1;
            while (i < values.length) {
                if (values[i] instanceof IIntegralDomain) {
                    IIntegralDomain branch = (IIntegralDomain)values[i];
                    long value = branch.getLowValue();
                    long mask2 = branch.getZeroBitMask() ^ 0xFFFFFFFFFFFFFFFFL;
                    if (mask1 != 0L && mask2 != 0L && (mask1 & mask2) == 0L || value < min || value > max) {
                        Object[] objectArray;
                        AstSwitchStatement stmt = (AstSwitchStatement)tuple.getAstObject();
                        if (value < min || value > max) {
                            Object[] objectArray2 = new Object[2];
                            objectArray2[0] = branch;
                            objectArray = objectArray2;
                            objectArray2[1] = selector;
                        } else {
                            Object[] objectArray3 = new Object[2];
                            objectArray3[0] = new Long(mask2);
                            objectArray = objectArray3;
                            objectArray3[1] = new Long(mask1);
                        }
                        Object[] evalues = objectArray;
                        this.message((AstObject)stmt.getCaseLabel(i - 1), evalues);
                    }
                }
                ++i;
            }
        }
    }

    public String getExplainMessage(AstObject ast, String messageId, Object[] values) {
        if (values[0] instanceof IIntegralDomain) {
            return super.getExplainMessage("com.togethersoft.sca.internal.plugin.audit.impl.CU_1", ast, messageId, values);
        }
        return super.getExplainMessage("com.togethersoft.sca.internal.plugin.audit.impl.CU_2", ast, messageId, values);
    }
}

