/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstAssignmentExpression;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstFieldReference;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstParenthesizedExpression;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.ast.AstReturnStatement;
import com.togethersoft.sca.ast.AstSimpleReference;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstUnaryExpression;
import com.togethersoft.sca.internal.plugin.audit.impl.Util;
import com.togethersoft.sca.plugin.audit.AuditRule;
import java.util.HashSet;
import java.util.LinkedList;

public class CQS
extends AuditRule {
    private AstType type;
    private LinkedList returnedFields = new LinkedList();
    private LinkedList modifiedFields = new LinkedList();

    public CQS() {
        super(7);
    }

    public void checkMethod(AstMethod method) {
        this.type = method.getDeclaringType();
        this.returnedFields.addLast(new HashSet());
        this.modifiedFields.addLast(new HashSet());
    }

    public void leaveMethod(AstMethod method) {
        this.returnedFields.removeLast();
        this.modifiedFields.removeLast();
    }

    public void checkFieldReference(AstFieldReference expr) {
        AstField field = this.addField(this.modifiedFields, (AstReference)expr, true);
        if (this.contains(this.returnedFields, field)) {
            this.message((AstObject)expr);
        }
    }

    public void checkSimpleReference(AstSimpleReference expr) {
        AstField field = this.addField(this.modifiedFields, (AstReference)expr, true);
        if (this.contains(this.returnedFields, field)) {
            this.message((AstObject)expr);
        }
    }

    public void checkReturnStatement(AstReturnStatement stmt) {
        this.processReturnExpression(stmt.getReturnExpression());
    }

    private AstField addField(LinkedList stack, AstReference ast, boolean checkModification) {
        if (stack.isEmpty()) {
            return null;
        }
        HashSet set = (HashSet)stack.getLast();
        AstDeclaration decl = ast.getReferencedElement();
        if (decl instanceof AstField && decl.getParent() == this.type && (!checkModification || Util.isChanging((AstObject)ast)) && !set.contains(decl)) {
            set.add(decl);
            return (AstField)decl;
        }
        return null;
    }

    private void processReturnExpression(AstExpression expr) {
        if (expr == null) {
            return;
        }
        switch (expr.getObjectKind()) {
            case 43: {
                this.processReturnExpression(((AstUnaryExpression)expr).getOperand());
                break;
            }
            case 46: {
                this.processReturnExpression(((AstParenthesizedExpression)expr).getExpression());
                break;
            }
            case 36: 
            case 40: {
                AstField field = this.addField(this.returnedFields, (AstReference)expr, false);
                if (!this.contains(this.modifiedFields, field)) break;
                this.message((AstObject)expr);
                break;
            }
            case 32: {
                this.processReturnExpression(((AstAssignmentExpression)expr).getLeftOperand());
            }
        }
    }

    private boolean contains(LinkedList list, Object element) {
        if (element != null) {
            return ((HashSet)list.getLast()).contains(element);
        }
        return false;
    }
}

