/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstCharLiteral;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstIntLiteral;
import com.togethersoft.sca.ast.AstLongLiteral;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.plugin.audit.AuditRule;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class CEV
extends AuditRule {
    public CEV() {
        super(4);
    }

    public void checkType(AstType type) {
        LinkedList constants = this.getConstants(type);
        while (constants.size() > 0) {
            ArrayList<AstField> array = null;
            Iterator i = constants.iterator();
            Constant first = (Constant)i.next();
            while (i.hasNext()) {
                Constant c = (Constant)i.next();
                if (!c.equals(first)) continue;
                if (array == null) {
                    array = new ArrayList<AstField>();
                    array.add(first.decl);
                }
                array.add(c.decl);
                i.remove();
            }
            constants.removeFirst();
            if (array == null) continue;
            IAuditMessage msg = this.message((AstObject)first.decl, "AuditCEV.1", null);
            Iterator iter = ((AbstractList)array).iterator();
            while (iter.hasNext()) {
                AstField field = (AstField)iter.next();
                this.message(msg, (AstObject)field, "%qf", new Object[]{field});
            }
        }
    }

    private LinkedList getConstants(AstType type) {
        LinkedList<Constant> list = new LinkedList<Constant>();
        AstField[] fields = type.getFields();
        int i = 0;
        while (i < fields.length) {
            AstField field = fields[i];
            if (field.isStatic() && field.isFinal()) {
                AstExpression init = field.getInitializer();
                if (init instanceof AstIntLiteral) {
                    list.add(new Constant(0, ((AstIntLiteral)init).getValue(), field));
                } else if (init instanceof AstLongLiteral) {
                    list.add(new Constant(0, ((AstLongLiteral)init).getValue(), field));
                } else if (init instanceof AstCharLiteral) {
                    list.add(new Constant(1, ((AstCharLiteral)init).getValue(), field));
                }
            }
            ++i;
        }
        return list;
    }

    private class Constant {
        int type;
        long value;
        AstField decl;

        Constant(int type, long value, AstField decl) {
            this.type = type;
            this.value = value;
            this.decl = decl;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Constant) {
                Constant c = (Constant)obj;
                return this.type == c.type && this.value == c.value;
            }
            return false;
        }
    }
}

