/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstAssignmentExpression;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstUnaryExpression;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IParameterBoolean;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class CA
extends AuditRule {
    private boolean strict;

    public CA() {
        super(2);
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        IParameterBoolean param = (IParameterBoolean)this.getAnalyzer().getParameterRegistry().getParameter("Strict", 1);
        if (param != null) {
            this.strict = param.getValue();
        }
    }

    public void checkAssignmentExpression(AstAssignmentExpression expr) {
        AstObject parent = expr.getParent();
        while (parent instanceof AstExpression) {
            if (parent.getObjectKind() == 32) {
                return;
            }
            parent = parent.getParent();
        }
        if (!this.workExpression(expr.getLeftOperand()) || !this.workExpression(expr.getRightOperand())) {
            this.message((AstObject)expr);
        }
    }

    private boolean workExpression(AstExpression expr) {
        if (expr == null) {
            return true;
        }
        switch (expr.getObjectKind()) {
            case 30: 
            case 31: 
            case 38: 
            case 39: {
                return true;
            }
            case 32: {
                if (!this.strict && this.isSimpleAssignment((AstObject)expr) && this.isSimpleAssignment(expr.getParent())) break;
                return false;
            }
            case 43: {
                int cop = ((AstUnaryExpression)expr).getExpressionKind();
                if (cop != 5 && cop != 4 && cop != 7 && cop != 6) break;
                return false;
            }
        }
        AstExpression[] operands = expr.getOperands();
        int i = 0;
        while (i < operands.length) {
            if (!this.workExpression(operands[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isSimpleAssignment(AstObject ast) {
        return ast.getObjectKind() == 32 && ((AstAssignmentExpression)ast).getExpressionKind() == 0;
    }
}

