/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstComment;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstJavadocTag;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IParameter;
import com.togethersoft.sca.core.IParameterList;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.plugin.audit.AuditRule;
import java.util.HashSet;

public class BTJC
extends AuditRule {
    private HashSet validTags;

    public BTJC() {
        super(4);
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        this.validTags = new HashSet();
        IParameterList list = (IParameterList)analyzer.getParameterRegistry().getParameter("tag-list", 5);
        if (list != null) {
            IParameter[] params = list.getParameterList();
            int i = 0;
            while (i < params.length) {
                if (params[i].getId().startsWith("@")) {
                    this.validTags.add(params[i].getId());
                }
                ++i;
            }
        }
    }

    public void checkDeclaration(AstDeclaration decl) {
        AstComment[] comments = decl.getComments();
        int i = 0;
        while (i < comments.length) {
            if (comments[i].isJavadoc()) {
                this.checkComment(comments[i]);
            }
            ++i;
        }
    }

    private void checkComment(AstComment comment) {
        AstJavadocTag[] tags = comment.getJavadocTags();
        int i = 0;
        while (i < tags.length) {
            if (!this.validTags.contains(tags[i].getTag())) {
                this.message((AstObject)tags[i], "AuditBTJC.1", new Object[]{tags[i].getTag()});
            }
            ++i;
        }
    }
}

