/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.ast.visitor.AstExpressionVisitor;
import com.togethersoft.sca.ast.visitor.AstExpressionVisitorAdapter;
import com.togethersoft.sca.dataflow.flowgraph.IJavaLoop;
import com.togethersoft.sca.internal.plugin.audit.impl.MSC;
import com.togethersoft.sca.plugin.audit.AuditRule;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class ASWL
extends AuditRule {
    public ASWL() {
        super(8);
    }

    public void checkLoop(IJavaLoop loop) {
        VisitorLoop visitorLoop = new VisitorLoop();
        loop.stmt().visitExpressions((AstExpressionVisitor)visitorLoop);
        if (visitorLoop.getViolationList() != null) {
            Iterator iter = ((AbstractList)visitorLoop.getViolationList()).iterator();
            while (iter.hasNext()) {
                this.message((AstObject)((AstReference)iter.next()));
            }
        }
    }

    private class VisitorLoop
    extends AstExpressionVisitorAdapter {
        private ArrayList violations;

        private VisitorLoop() {
        }

        ArrayList getViolationList() {
            return this.violations;
        }

        public void visitExpression(AstExpression expr) {
            AstReference ex = MSC.isConcatString(expr);
            if (ex != null) {
                this.addViolation(ex);
            }
        }

        private void addViolation(AstReference expr) {
            if (this.violations == null) {
                this.violations = new ArrayList();
            }
            this.violations.add(expr);
        }
    }
}

