/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstFieldReference;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstObjectFactory;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.ast.AstSimpleReference;
import com.togethersoft.sca.ast.AstSuperExpression;
import com.togethersoft.sca.ast.AstThisExpression;
import com.togethersoft.sca.core.Factory;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class ASMDCN
extends AuditRule {
    public ASMDCN() {
        super(2);
    }

    public void checkFieldReference(AstFieldReference expr) {
        IAuditMessage m;
        final AstExpression base = expr.getBaseExpression();
        final AstDeclaration decl = expr.getReferencedElement();
        if (this.checkAccess(decl, base) && (m = this.message((AstObject)expr, "AuditASMDCN.1", new Object[]{decl})) != null) {
            m.addAutoFix((AutoFix)new ASTAutoFix("AuditASMDCN.Autofix"){

                public boolean fix() {
                    String className = decl.getDeclaringType().getElementName();
                    AstObjectFactory factory = Factory.getObjectFactory();
                    AstSimpleReference ref = factory.createAstSimpleReference(className);
                    base.replaceWith((AstObject)ref);
                    base.remove();
                    return true;
                }
            });
            ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
            fix.setTabSize(this.getProject().getTabSize());
            fix.remove(base.getPosition());
            fix.insert(decl.getDeclaringType().getElementName());
        }
    }

    private boolean checkAccess(AstDeclaration decl, AstExpression base) {
        if (!base.isDeleted() && decl != null && decl.isStatic() && base instanceof AstReference) {
            if (base instanceof AstThisExpression || base instanceof AstSuperExpression) {
                return false;
            }
            AstDeclaration baseDecl = ((AstReference)base).getReferencedElement();
            if (baseDecl != null && baseDecl.getObjectKind() == 8) {
                return decl.getDeclaringType() != baseDecl;
            }
        }
        return false;
    }
}

