/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.impl;

import com.togethersoft.sca.ast.AstAssignmentExpression;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstSimpleReference;
import com.togethersoft.sca.ast.AstUnaryExpression;
import com.togethersoft.sca.plugin.audit.AuditRule;

public class AFP
extends AuditRule {
    public AFP() {
        super(2);
    }

    public void checkUnaryExpression(AstUnaryExpression expr) {
        switch (expr.getExpressionKind()) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.checkOperand(expr.getOperand());
            }
        }
    }

    public void checkAssignmentExpression(AstAssignmentExpression expr) {
        this.checkOperand(expr.getLeftOperand());
    }

    private void checkOperand(AstExpression op) {
        AstDeclaration decl;
        if (op.getObjectKind() == 40 && (decl = ((AstSimpleReference)op).getReferencedElement()) != null && decl.getParent() != null && decl.getParent().getObjectKind() == 6) {
            this.message((AstObject)op, "AuditAFP.1", new Object[]{decl});
        }
    }
}

