/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.dc;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstIfStatement;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.internal.plugin.audit.Audit;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.internal.plugin.audit.dc.AstMatcher;
import com.togethersoft.sca.internal.plugin.audit.dc.AstTree;
import com.togethersoft.sca.internal.plugin.audit.dc.MatcherRule;
import java.util.LinkedList;

public class DCCB
extends MatcherRule {
    public DCCB() {
        super(1);
    }

    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        this.matcher = new AstMatcher(0, 0, this.getDataFlowAnalyzer());
    }

    public void checkIfStatement(AstIfStatement stmt) {
        AstStatement s1 = stmt.getThenStatement();
        AstStatement s2 = stmt.getElseStatement();
        if (s2 == null) {
            return;
        }
        if (s1.getObjectKind() != 21 || s2.getObjectKind() != 21) {
            return;
        }
        AstMatcher.LinkInfo links = this.matcher.factorBlock((AstCompoundStatement)s1, (AstCompoundStatement)s2);
        if (links.s1.length > 0) {
            LinkedList<AstStatement[]> fragments = new LinkedList<AstStatement[]>();
            fragments.add(links.s1);
            fragments.add(links.s2);
            int depth = 0;
            int weight = 0;
            int i = 0;
            while (i < links.s1.length) {
                AstTree info = this.matcher.processTree((AstObject)links.s1[i], false);
                if (info.depth > depth) {
                    depth = info.depth;
                }
                weight += info.weight;
                ++i;
            }
            if (depth >= this.minDepth || weight >= this.minWeight) {
                Audit.message(this, depth, weight, fragments);
            }
        }
    }
}

