/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.dc;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.internal.plugin.audit.Audit;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.internal.plugin.audit.dc.AstCongruentClass;
import com.togethersoft.sca.internal.plugin.audit.dc.AstMatcher;
import com.togethersoft.sca.internal.plugin.audit.dc.AstTree;
import com.togethersoft.sca.internal.plugin.audit.dc.MatcherRule;
import java.util.Iterator;
import java.util.LinkedList;

public class DC
extends MatcherRule {
    public void setParameters(IAnalyzerDescriptor analyzer, String severity, ReportManager logger) {
        super.setParameters(analyzer, severity, logger);
        this.matcher = new AstMatcher(this.minDepth, this.minWeight / 2, this.getDataFlowAnalyzer());
    }

    public DC() {
        super(4);
    }

    public void leavePackage(AstPackage pkg) {
        this.processASTClasses();
        this.matcher.clear();
    }

    public void checkMethod(AstMethod method) {
        AstCompoundStatement body = method.getBody();
        if (body != null) {
            this.matcher.processTree((AstObject)body, true);
        }
    }

    private void processASTClasses() {
        Iterator iter = this.matcher.iterator();
        while (iter.hasNext()) {
            this.processASTClass((AstCongruentClass)iter.next());
        }
    }

    private void processASTClass(AstCongruentClass cclass) {
        if (cclass == null) {
            return;
        }
        if (cclass.size() > 1) {
            AstTree rep = null;
            LinkedList<AstStatement[]> fragments = new LinkedList<AstStatement[]>();
            Iterator i = cclass.iterator();
            while (i.hasNext()) {
                AstTree st = (AstTree)i.next();
                if (st.parent != null) {
                    this.processASTClass(st.parent.cclass);
                    if (st.parent.cclass == null) {
                        st.cclass = null;
                        i.remove();
                        continue;
                    }
                }
                if (rep == null) {
                    rep = st;
                    i.remove();
                    fragments.add(new AstStatement[]{st.tree});
                    continue;
                }
                if (!this.matcher.equals((AstObject)rep.tree, (AstObject)st.tree)) continue;
                rep.cclass = null;
                st.cclass = null;
                i.remove();
                fragments.add(new AstStatement[]{st.tree});
            }
            if (fragments.size() > 1) {
                int depth = cclass.depth();
                int weight = cclass.weight();
                if (fragments.size() == 2) {
                    AstStatement t1 = ((AstStatement[])fragments.get(0))[0];
                    AstStatement t2 = ((AstStatement[])fragments.get(1))[0];
                    AstMatcher.LinkInfo links = this.matcher.factor(t1, t2);
                    if (links.s1.length > 1) {
                        fragments.clear();
                        fragments.add(links.s1);
                        fragments.add(links.s2);
                        int j = 0;
                        while (j < links.s1.length) {
                            AstStatement stmt = links.s1[j];
                            if (stmt != t1) {
                                AstTree info = this.matcher.processTree((AstObject)stmt, false);
                                if (info.depth > depth) {
                                    depth = info.depth;
                                }
                                weight += info.weight;
                            }
                            ++j;
                        }
                    }
                }
                if (depth >= this.minDepth || weight >= this.minWeight) {
                    Audit.message(this, depth, weight, fragments);
                }
            }
        }
        cclass.reset();
    }
}

