/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.dc;

import com.togethersoft.sca.ast.AstArrayCreationExpression;
import com.togethersoft.sca.ast.AstArrayReference;
import com.togethersoft.sca.ast.AstAssignmentExpression;
import com.togethersoft.sca.ast.AstBinaryExpression;
import com.togethersoft.sca.ast.AstBooleanLiteral;
import com.togethersoft.sca.ast.AstCharLiteral;
import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstDeclarationStatement;
import com.togethersoft.sca.ast.AstDoubleLiteral;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstFloatLiteral;
import com.togethersoft.sca.ast.AstIntLiteral;
import com.togethersoft.sca.ast.AstLiteral;
import com.togethersoft.sca.ast.AstLongLiteral;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.ast.AstSourcePosition;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstStringLiteral;
import com.togethersoft.sca.ast.AstTypeExpression;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstUnaryExpression;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.internal.dataflow.DataFlowAnalyzer;
import com.togethersoft.sca.internal.plugin.audit.dc.ASTDAG;
import com.togethersoft.sca.internal.plugin.audit.dc.ASTDAGNode;
import com.togethersoft.sca.internal.plugin.audit.dc.AstCongruentClass;
import com.togethersoft.sca.internal.plugin.audit.dc.AstTree;
import com.togethersoft.sca.internal.plugin.audit.dc.AstTreeBlock;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AstMatcher {
    static final int IDENTICAL = 0;
    static final int STRICT = 1;
    static final int FUZZY = 2;
    private static final int MAP_SIZE = 8191;
    private LinkedList[] map = new LinkedList[8191];
    private HashMap vars1 = new HashMap();
    private HashMap vars2 = new HashMap();
    private HashMap compounds = new HashMap();
    private int minDepth;
    private int minWeight;
    private DataFlowAnalyzer analyzer;
    private int[][] pairs;
    private ASTDAG dag1;
    private ASTDAG dag2;

    public AstMatcher(int minDepth, int minWeight, DataFlowAnalyzer analyzer) {
        int i = 0;
        while (i < this.map.length) {
            this.map[i] = new LinkedList();
            ++i;
        }
        this.minDepth = minDepth;
        this.minWeight = minWeight;
        this.analyzer = analyzer;
    }

    public void clear() {
        int i = 0;
        while (i < this.map.length) {
            this.map[i].clear();
            ++i;
        }
        this.compounds.clear();
    }

    public AstTree processTree(AstObject tree, boolean fillTable) {
        return this.processTree(null, null, tree, fillTable, true, false);
    }

    private AstTree processTree(AstTree parent, ASTDAGNode context, AstObject t, boolean fillTable, boolean read, boolean write) {
        AstTree tree;
        if (t instanceof AstStatement) {
            if (t.getObjectKind() == 21) {
                tree = new AstTreeBlock(this, parent, (AstStatement)t);
                this.compounds.put(t, tree);
            } else {
                tree = new AstTree(this, parent, (AstStatement)t);
            }
        } else {
            tree = parent;
        }
        if (context != null) {
            context.collectInfo(t, read, write, this.analyzer);
        }
        long hash = t.getObjectKind();
        if (t instanceof AstExpression) {
            AstExpression e = (AstExpression)t;
            if (e.isConstant()) {
                tree.hash = e.getType().getKind();
                return tree;
            }
            hash += (long)e.getType().getKind();
        }
        switch (t.getObjectKind()) {
            case 31: {
                AstArrayReference arr = (AstArrayReference)t;
                hash = this.measureTree(tree, hash, this.processTree(tree, context, (AstObject)arr.getBase(), fillTable, true, write));
                hash = this.measureTree(tree, hash, this.processTree(tree, context, (AstObject)arr.getIndex(), fillTable, true, false));
                break;
            }
            case 32: {
                AstAssignmentExpression asg = (AstAssignmentExpression)t;
                boolean mod = asg.getExpressionKind() != 0;
                hash = this.measureTree(tree, hash, this.processTree(tree, context, (AstObject)asg.getLeftOperand(), fillTable, mod, true));
                hash = this.measureTree(tree, hash, this.processTree(tree, context, (AstObject)asg.getRightOperand(), fillTable, true, false));
                break;
            }
            case 43: {
                AstUnaryExpression unExpr = (AstUnaryExpression)t;
                int cop = unExpr.getExpressionKind();
                boolean mod = cop == 4 || cop == 5 || cop == 6 || cop == 7;
                hash = this.measureTree(tree, hash, this.processTree(tree, context, (AstObject)unExpr.getOperand(), fillTable, true, mod));
                break;
            }
            case 21: {
                ArrayList groups = new ArrayList();
                ArrayList<ASTDAGNode> contexts = new ArrayList<ASTDAGNode>();
                AstObject[] children = t.getChildren();
                int i = 0;
                while (i < children.length) {
                    ASTDAGNode ctx = new ASTDAGNode();
                    AstTree child = this.processTree(tree, ctx, children[i], fillTable, true, false);
                    if (context != null) {
                        context.union(ctx);
                    }
                    hash = this.measureTree(tree, hash, child);
                    int index = -1;
                    int j = groups.size() - 1;
                    while (j >= 0) {
                        if (!((ASTDAGNode)contexts.get(j)).isParallel(ctx)) break;
                        index = j--;
                    }
                    if (index >= 0) {
                        ((ArrayList)groups.get(index)).add(child);
                        ((ASTDAGNode)contexts.get(index)).union(ctx);
                    } else {
                        ArrayList<AstTree> list = new ArrayList<AstTree>();
                        list.add(child);
                        groups.add(list);
                        contexts.add(ctx);
                    }
                    ++i;
                }
                AstTree[][] stmts = new AstTree[groups.size()][];
                int i2 = 0;
                while (i2 < groups.size()) {
                    ArrayList entry = (ArrayList)groups.get(i2);
                    stmts[i2] = entry.toArray(new AstTree[entry.size()]);
                    ++i2;
                }
                ((AstTreeBlock)tree).stmts = stmts;
                break;
            }
            default: {
                AstObject[] children = t.getChildren();
                int i = 0;
                while (i < children.length) {
                    hash = this.measureTree(tree, hash, this.processTree(tree, context, children[i], fillTable, true, false));
                    ++i;
                }
                break block0;
            }
        }
        tree.hash = hash;
        if (t instanceof AstStatement) {
            if (parent != null) {
                parent.weight += tree.weight;
            }
            if (fillTable && (tree.depth >= this.minDepth || tree.weight >= this.minWeight)) {
                this.putTree(tree);
            }
        }
        return tree;
    }

    private long measureTree(AstTree tree, long hash, AstTree info) {
        if (info != tree && info.depth >= tree.depth) {
            tree.depth = info.depth + 1;
        }
        return hash + (info.hash << 5);
    }

    private void putTree(AstTree t) {
        AstCongruentClass cls;
        int idx = (int)((t.hash & Long.MAX_VALUE) % 8191L);
        LinkedList list = this.map[idx];
        Iterator i = list.iterator();
        while (i.hasNext()) {
            cls = (AstCongruentClass)i.next();
            if (!cls.match(t)) continue;
            cls.add(t);
            return;
        }
        cls = new AstCongruentClass(t);
        list.add(cls);
        t.cclass = cls;
    }

    boolean matchTree(AstObject t1, AstObject t2, int mode) {
        if (mode != 0 && t1 instanceof AstExpression && t2 instanceof AstExpression) {
            AstExpression e1 = (AstExpression)t1;
            AstExpression e2 = (AstExpression)t2;
            if (e1.isConstant() && e2.isConstant() && e1.getType() == e2.getType()) {
                return true;
            }
        }
        if (t1.getObjectKind() != t2.getObjectKind()) {
            return false;
        }
        block0 : switch (t1.getObjectKind()) {
            case 21: {
                AstTree tree1 = (AstTree)this.compounds.get(t1);
                AstTree tree2 = (AstTree)this.compounds.get(t2);
                if (tree1 == null || tree2 == null) {
                    return false;
                }
                return tree1.match(tree2);
            }
            case 37: {
                if (((AstLiteral)t1).getLiteralKind() != ((AstLiteral)t2).getLiteralKind()) {
                    return false;
                }
                if (mode != 0) break;
                switch (((AstLiteral)t1).getLiteralKind()) {
                    case 0: {
                        AstIntLiteral il1 = (AstIntLiteral)t1;
                        AstIntLiteral il2 = (AstIntLiteral)t2;
                        if (il1.getValue() == il2.getValue() && il1.negationRequired() == il2.negationRequired()) break block0;
                        return false;
                    }
                    case 1: {
                        AstLongLiteral ll1 = (AstLongLiteral)t1;
                        AstLongLiteral ll2 = (AstLongLiteral)t2;
                        if (ll1.getValue() == ll2.getValue() && ll1.negationRequired() == ll2.negationRequired()) break block0;
                        return false;
                    }
                    case 2: {
                        if (((AstFloatLiteral)t1).getValue() == ((AstFloatLiteral)t2).getValue()) break;
                        return false;
                    }
                    case 3: {
                        if (((AstDoubleLiteral)t1).getValue() == ((AstDoubleLiteral)t2).getValue()) break;
                        return false;
                    }
                    case 4: {
                        if (((AstBooleanLiteral)t1).getValue() == ((AstBooleanLiteral)t2).getValue()) break;
                        return false;
                    }
                    case 5: {
                        if (((AstCharLiteral)t1).getValue() == ((AstCharLiteral)t2).getValue()) break;
                        return false;
                    }
                    case 6: {
                        AstStringLiteral sl1 = (AstStringLiteral)t1;
                        AstStringLiteral sl2 = (AstStringLiteral)t2;
                        if (sl1.equals(sl2)) break;
                        return false;
                    }
                }
                break;
            }
            case 24: {
                AstDeclaration d1 = ((AstDeclarationStatement)t1).getDeclarations();
                AstDeclaration d2 = ((AstDeclarationStatement)t2).getDeclarations();
                if (((AstDeclaration)d1).length != ((AstDeclaration)d2).length) {
                    return false;
                }
                int i = 0;
                while (i < ((AstDeclaration)d1).length) {
                    if (d1[i].getObjectKind() != d2[i].getObjectKind()) {
                        return false;
                    }
                    if (d1[i].getObjectKind() == 9) {
                        AstTypeReference type1 = ((AstVariable)d1[i]).getType();
                        AstTypeReference type2 = ((AstVariable)d2[i]).getType();
                        if (type1 == null || type2 == null || type1 != type2) {
                            return false;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 30: {
                AstTypeReference type1 = ((AstArrayCreationExpression)t1).getType();
                AstTypeReference type2 = ((AstArrayCreationExpression)t2).getType();
                if (type1 != null && type2 != null && type1 == type2) break;
                return false;
            }
            case 33: {
                int cop1 = ((AstBinaryExpression)t1).getExpressionKind();
                int cop2 = ((AstBinaryExpression)t2).getExpressionKind();
                if (cop1 == cop2) break;
                return false;
            }
            case 32: {
                int cop1 = ((AstAssignmentExpression)t1).getExpressionKind();
                int cop2 = ((AstAssignmentExpression)t2).getExpressionKind();
                if (cop1 == cop2) break;
                return false;
            }
            case 43: {
                int cop1 = ((AstUnaryExpression)t1).getExpressionKind();
                int cop2 = ((AstUnaryExpression)t2).getExpressionKind();
                if (cop1 == cop2) break;
                return false;
            }
            case 45: {
                return ((AstTypeExpression)t1).getType() == ((AstTypeExpression)t2).getType();
            }
            case 3: 
            case 29: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                AstDeclaration d1 = ((AstReference)t1).getReferencedElement();
                AstDeclaration d2 = ((AstReference)t2).getReferencedElement();
                if (d1 == null || d2 == null || d1.getObjectKind() != d2.getObjectKind()) {
                    return false;
                }
                switch (d1.getObjectKind()) {
                    case 6: 
                    case 7: 
                    case 8: {
                        if (d1 == d2) break block0;
                        return false;
                    }
                    case 9: {
                        AstTypeReference type1 = ((AstVariable)d1).getType();
                        AstTypeReference type2 = ((AstVariable)d2).getType();
                        if (type1 != null && type2 != null && type1 == type2) break block0;
                        return false;
                    }
                }
                System.err.println("@@@ unexpected reference from " + t1);
            }
        }
        AstObject[] s1 = t1.getChildren();
        AstObject[] s2 = t2.getChildren();
        if (s1.length != s2.length) {
            return false;
        }
        int i = 0;
        while (i < s1.length) {
            if (!this.matchTree(s1[i], s2[i], mode)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(AstObject t1, AstObject t2) {
        this.vars1.clear();
        this.vars2.clear();
        return this.equals(t1, t2, 2);
    }

    public Iterator iterator() {
        return new MapIterator();
    }

    private boolean equals(AstObject t1, AstObject t2, int mode) {
        if (t1.getObjectKind() != t2.getObjectKind()) {
            return true;
        }
        switch (t1.getObjectKind()) {
            case 9: {
                if (this.compareVars((AstDeclaration)((AstVariable)t1), (AstDeclaration)((AstVariable)t2), mode)) break;
                return false;
            }
            case 36: 
            case 40: {
                if (this.compareVars(((AstReference)t1).getReferencedElement(), ((AstReference)t2).getReferencedElement(), mode)) break;
                return false;
            }
            case 21: {
                AstTreeBlock tree1 = (AstTreeBlock)this.compounds.get(t1);
                AstTreeBlock tree2 = (AstTreeBlock)this.compounds.get(t2);
                int i = 0;
                while (i < tree1.stmts.length) {
                    int j = 0;
                    while (j < tree1.stmts[i].length) {
                        if (!this.equals((AstObject)tree1.stmts[i][j].tree, (AstObject)tree2.stmts[i][j].tree, mode)) {
                            return false;
                        }
                        ++j;
                    }
                    ++i;
                }
                return true;
            }
        }
        AstObject[] s1 = t1.getChildren();
        AstObject[] s2 = t2.getChildren();
        int i = 0;
        while (i < s1.length) {
            if (!this.equals(s1[i], s2[i], mode)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean compareVars(AstDeclaration d1, AstDeclaration d2, int mode) {
        if (d1 == null || d2 == null) {
            return false;
        }
        if (d1.getObjectKind() == 9) {
            if (mode == 0) {
                return d1 == d2;
            }
            Object id1 = this.vars1.get(d1);
            Object id2 = this.vars2.get(d2);
            if (mode == 2) {
                if (id1 == null) {
                    if (id2 != null) {
                        return false;
                    }
                } else {
                    if (id2 == null) {
                        return false;
                    }
                    return id1 == id2;
                }
                Object id = new Object();
                this.vars1.put(d1, id);
                this.vars2.put(d2, id);
            } else {
                return id1 != null && id2 != null && id1 == id2;
            }
        }
        return true;
    }

    public void print(PrintStream out) {
        int maxCollChain = 0;
        int i = 0;
        while (i < this.map.length) {
            if (this.map[i].size() > maxCollChain) {
                maxCollChain = this.map[i].size();
            }
            Iterator j = this.map[i].iterator();
            while (j.hasNext()) {
                AstCongruentClass cls = (AstCongruentClass)j.next();
                if (cls.size() <= 1 || cls.depth() < this.minDepth && cls.weight() < this.minWeight) continue;
                out.print("AstClass(" + cls.depth() + "," + cls.weight() + "): ");
                cls.print(out);
                out.println();
            }
            ++i;
        }
    }

    public LinkInfo factor(AstStatement stmt1, AstStatement stmt2) {
        int i;
        LinkedList<AstStatement[]> list = new LinkedList<AstStatement[]>();
        list.add(new AstStatement[]{stmt1, stmt2});
        AstCompoundStatement block1 = this.getBlock((AstObject)stmt1);
        AstCompoundStatement block2 = this.getBlock((AstObject)stmt2);
        if (block1 == null || block2 == null) {
            return new LinkInfo(list);
        }
        AstStatement[] s1 = block1.getStatements();
        AstStatement[] s2 = block2.getStatements();
        this.pairs = new int[s1.length][s2.length];
        int n1 = this.findStmt(s1, stmt1);
        int n2 = this.findStmt(s2, stmt2);
        if (n1 == -1 || n2 == -1) {
            return new LinkInfo(list);
        }
        if (block1 != block2) {
            this.dag1 = new ASTDAG(s1, this.analyzer);
            this.dag2 = new ASTDAG(s2, this.analyzer);
        } else {
            this.dag1 = this.dag2 = new ASTDAG(s1, this.analyzer);
            i = 0;
            while (i < this.pairs.length) {
                this.pairs[i][i] = -1;
                ++i;
            }
        }
        this.markPair(n1, n2);
        i = n1 + 1;
        while (i < s1.length) {
            int j = n2 + 1;
            while (j < s2.length) {
                if (this.matchPair(i, j, false, 1)) {
                    list.add(new AstStatement[]{s1[i], s2[j]});
                    break;
                }
                ++j;
            }
            ++i;
        }
        int i2 = n1 - 1;
        while (i2 >= 0) {
            int j = n2 - 1;
            while (j >= 0) {
                if (this.matchPair(i2, j, true, 1)) {
                    list.add(new AstStatement[]{s1[i2], s2[j]});
                    break;
                }
                --j;
            }
            --i2;
        }
        int i3 = 0;
        while (i3 < s1.length) {
            int j = 0;
            while (j < s2.length) {
                if (this.dag1.getDefined(i3).length == 0 && this.dag2.getDefined(j).length == 0 && this.matchPair(i3, j, false, 1)) {
                    list.add(new AstStatement[]{s1[i3], s2[j]});
                    break;
                }
                ++j;
            }
            ++i3;
        }
        return new LinkInfo(list);
    }

    public LinkInfo factorBlock(AstCompoundStatement block1, AstCompoundStatement block2) {
        LinkedList<AstStatement[]> list = new LinkedList<AstStatement[]>();
        AstStatement[] s1 = block1.getStatements();
        AstStatement[] s2 = block2.getStatements();
        this.pairs = new int[s1.length][s2.length];
        this.dag1 = new ASTDAG(s1, this.analyzer);
        this.dag2 = new ASTDAG(s2, this.analyzer);
        int i = 0;
        while (i < s1.length) {
            int j = 0;
            while (j < s2.length) {
                if (this.matchPair(i, j, false, 0)) {
                    list.add(new AstStatement[]{s1[i], s2[j]});
                    break;
                }
                ++j;
            }
            ++i;
        }
        return new LinkInfo(list);
    }

    private void markPair(int n1, int n2) {
        int i = 0;
        while (i < this.pairs[n1].length) {
            this.pairs[n1][i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.pairs.length) {
            this.pairs[i2][n2] = -1;
            ++i2;
        }
        if (this.dag1 == this.dag2) {
            int i3 = 0;
            while (i3 < this.pairs.length) {
                this.pairs[i3][n1] = -1;
                ++i3;
            }
            int i4 = 0;
            while (i4 < this.pairs.length) {
                this.pairs[n2][i4] = -1;
                ++i4;
            }
        }
        this.pairs[n1][n2] = 1;
    }

    private boolean matchPair(int n1, int n2, boolean forw, int mode) {
        AstVariable[] v2;
        AstVariable[] v1;
        AstStatement stmt2;
        if (this.pairs[n1][n2] != 0) {
            return false;
        }
        AstStatement stmt1 = this.dag1.getStatement(n1);
        if (!this.matchTree((AstObject)stmt1, (AstObject)(stmt2 = this.dag2.getStatement(n2)), mode)) {
            this.pairs[n1][n2] = -1;
            return false;
        }
        if (!this.equals((AstObject)stmt1, (AstObject)stmt2, mode)) {
            this.pairs[n1][n2] = -1;
            return false;
        }
        if (forw) {
            v1 = this.dag1.getDefined(n1);
            v2 = this.dag2.getDefined(n2);
        } else {
            v1 = this.dag1.getUsed(n1);
            v2 = this.dag2.getUsed(n2);
        }
        int i = 0;
        while (i < v1.length) {
            int d2;
            int d1;
            if (forw) {
                d1 = this.dag1.findDefinitionNext(n1, v1[i]);
                d2 = this.dag2.findDefinitionNext(n2, v2[i]);
            } else {
                d1 = this.dag1.findDefinitionPrev(n1, v1[i]);
                d2 = this.dag2.findDefinitionPrev(n2, v2[i]);
            }
            if (d1 < 0 || d2 < 0) {
                if (d1 != d2) {
                    this.pairs[n1][n2] = -1;
                    return false;
                }
            } else if (this.pairs[d1][d2] != 1) {
                this.pairs[n1][n2] = -1;
                return false;
            }
            ++i;
        }
        this.markPair(n1, n2);
        return true;
    }

    private AstCompoundStatement getBlock(AstObject ast) {
        AstObject parent = ast.getParent();
        if (parent == null || parent.getObjectKind() != 21) {
            return null;
        }
        return (AstCompoundStatement)parent;
    }

    private int findStmt(AstStatement[] v, AstStatement s) {
        int i = 0;
        while (i < v.length) {
            if (v[i] == s) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static class LinkInfo {
        public AstStatement[] s1;
        public AstStatement[] s2;

        LinkInfo(AstStatement[] s1, AstStatement[] s2) {
            this.s1 = s1;
            this.s2 = s2;
        }

        LinkInfo(List list) {
            AstStatement[][] arr = new AstStatement[list.size()][2];
            list.toArray((T[])arr);
            Arrays.sort(arr, new Comparator(this){
                private final /* synthetic */ LinkInfo this$0;
                {
                    this.this$0 = this$0;
                }

                public int compare(Object o1, Object o2) {
                    AstSourcePosition pos1 = ((AstStatement[])o1)[0].getPosition();
                    AstSourcePosition pos2 = ((AstStatement[])o2)[0].getPosition();
                    if (pos1.getStartLine() < pos2.getStartLine()) {
                        return -1;
                    }
                    if (pos1.getStartLine() > pos2.getStartLine()) {
                        return 1;
                    }
                    if (pos1.getStartColumn() < pos2.getStartColumn()) {
                        return -1;
                    }
                    if (pos1.getStartColumn() > pos2.getStartColumn()) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.s1 = new AstStatement[arr.length];
            this.s2 = new AstStatement[arr.length];
            int i = 0;
            while (i < arr.length) {
                this.s1[i] = arr[i][0];
                this.s2[i] = arr[i][1];
                ++i;
            }
        }
    }

    private class MapIterator
    implements Iterator {
        private int index = 0;
        private Iterator iter;

        MapIterator() {
            this.iter = AstMatcher.this.map[0].iterator();
        }

        public boolean hasNext() {
            if (!this.iter.hasNext()) {
                this.findNext();
            }
            return this.iter.hasNext();
        }

        public Object next() {
            if (this.iter.hasNext()) {
                return this.iter.next();
            }
            this.findNext();
            return this.iter.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            if (this.index < 0) {
                return;
            }
            ++this.index;
            while (this.index < 8191) {
                if (AstMatcher.this.map[this.index].size() > 0) {
                    this.iter = AstMatcher.this.map[this.index].iterator();
                    return;
                }
                ++this.index;
            }
            this.index = -1;
        }
    }
}

