/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.dc;

import com.togethersoft.sca.ast.AstArrayReference;
import com.togethersoft.sca.ast.AstAssignmentExpression;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstFieldReference;
import com.togethersoft.sca.ast.AstInitializer;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.ast.AstSimpleReference;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstUnaryExpression;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.internal.dataflow.DataFlowAnalyzer;
import com.togethersoft.sca.internal.plugin.audit.dc.ASTDAG;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Iterator;

public class ASTDAGNode {
    private HashSet used = new HashSet();
    private HashSet defined = new HashSet();
    private boolean sideEffects;
    private AstStatement stmt;
    private HashSet calledTypes;

    ASTDAGNode() {
    }

    ASTDAGNode(AstStatement stmt, DataFlowAnalyzer analyzer) {
        this.stmt = stmt;
        this.processTree((AstObject)stmt, true, false, analyzer);
    }

    public AstStatement getStatement() {
        return this.stmt;
    }

    public boolean hasSideEffects() {
        return this.sideEffects;
    }

    public AstVariable[] getUsed() {
        return ((AbstractCollection)this.used).toArray(new AstVariable[this.used.size()]);
    }

    public AstVariable[] getDefined() {
        return ((AbstractCollection)this.defined).toArray(new AstVariable[this.defined.size()]);
    }

    public boolean isUsed(AstVariable var) {
        return this.used.contains(var);
    }

    public boolean isDefined(AstVariable var) {
        return this.defined.contains(var);
    }

    public boolean isParallel(ASTDAGNode node) {
        if (this.sideEffects || node.sideEffects) {
            return false;
        }
        Iterator iter = this.defined.iterator();
        while (iter.hasNext()) {
            if (!node.isUsed((AstVariable)iter.next())) continue;
            return false;
        }
        iter = this.used.iterator();
        while (iter.hasNext()) {
            if (!node.isDefined((AstVariable)iter.next())) continue;
            return false;
        }
        return true;
    }

    public void union(ASTDAGNode node) {
        this.sideEffects |= node.sideEffects;
        this.defined.addAll(node.defined);
        this.used.addAll(node.used);
    }

    public boolean mayBeDefined(AstVariable v, boolean isLocal, AstType topType, AstType varType) {
        if (this.isDefined(v)) {
            return true;
        }
        if (!isLocal && this.hasSideEffects() && this.calledTypes != null) {
            Iterator i = this.calledTypes.iterator();
            while (i.hasNext()) {
                AstType type = (AstType)i.next();
                if (topType.isDerivedFrom(type) || type.isDerivedFrom(topType)) {
                    return true;
                }
                if (varType == null || !varType.isDerivedFrom(type) && !type.isDerivedFrom(varType)) continue;
                return true;
            }
        }
        return false;
    }

    private void processTree(AstObject ast, boolean read, boolean write, DataFlowAnalyzer analyzer) {
        this.collectInfo(ast, read, write, analyzer);
        switch (ast.getObjectKind()) {
            case 31: {
                AstArrayReference arrRef = (AstArrayReference)ast;
                this.processTree((AstObject)arrRef.getBase(), true, write, analyzer);
                this.processTree((AstObject)arrRef.getIndex(), true, false, analyzer);
                return;
            }
            case 32: {
                AstAssignmentExpression astExpr = (AstAssignmentExpression)ast;
                boolean mod = astExpr.getExpressionKind() != 0;
                this.processTree((AstObject)astExpr.getLeftOperand(), mod, true, analyzer);
                this.processTree((AstObject)astExpr.getRightOperand(), true, false, analyzer);
                return;
            }
            case 43: {
                AstUnaryExpression unExpr = (AstUnaryExpression)ast;
                int cop = unExpr.getExpressionKind();
                boolean mod = cop == 4 || cop == 5 || cop == 6 || cop == 7;
                this.processTree((AstObject)unExpr.getOperand(), true, mod, analyzer);
                return;
            }
        }
        AstObject[] s = ast.getChildren();
        int i = 0;
        while (i < s.length) {
            this.processTree(s[i], true, false, analyzer);
            ++i;
        }
    }

    void collectInfo(AstObject ast, boolean read, boolean write, DataFlowAnalyzer analyzer) {
        switch (ast.getObjectKind()) {
            case 9: {
                this.addDefined((AstVariable)ast);
                break;
            }
            case 36: {
                AstFieldReference astField = (AstFieldReference)ast;
                this.processRef(astField.getReferencedElement(), read, write);
                break;
            }
            case 29: 
            case 38: 
            case 39: {
                this.checkForSideEffects((AstReference)ast, analyzer);
                break;
            }
            case 40: {
                AstSimpleReference astRef = (AstSimpleReference)ast;
                this.processRef(astRef.getReferencedElement(), read, write);
                break;
            }
        }
    }

    private void processRef(AstDeclaration decl, boolean read, boolean write) {
        AstVariable v;
        if (decl instanceof AstVariable && (v = (AstVariable)decl) != null) {
            if (read) {
                this.addUsed(v);
            }
            if (write) {
                this.addDefined(v);
            }
        }
    }

    private void checkForSideEffects(AstReference ref, DataFlowAnalyzer analyzer) {
        AstType type;
        AstDeclaration d = ref.getReferencedElement();
        Object m = d instanceof AstMethod ? analyzer.getFor((AstMethod)d) : (d instanceof AstInitializer ? analyzer.getFor((AstInitializer)d) : null);
        this.sideEffects = m != null ? (this.sideEffects |= m.hasSideEffect()) : true;
        if (d != null && (type = ASTDAG.getTopType((AstObject)d)) != null) {
            if (this.calledTypes == null) {
                this.calledTypes = new HashSet();
            }
            this.calledTypes.add(type);
        }
    }

    private void addUsed(AstVariable var) {
        this.used.add(var);
    }

    private void addDefined(AstVariable var) {
        this.defined.add(var);
    }
}

