/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit.dc;

import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.internal.dataflow.DataFlowAnalyzer;
import com.togethersoft.sca.internal.plugin.audit.dc.ASTDAGNode;

public class ASTDAG {
    private ASTDAGNode[] nodes;

    ASTDAG(AstStatement[] stmts, DataFlowAnalyzer analyzer) {
        this.nodes = new ASTDAGNode[stmts.length];
        int i = 0;
        while (i < stmts.length) {
            this.nodes[i] = new ASTDAGNode(stmts[i], analyzer);
            ++i;
        }
    }

    AstStatement getStatement(int n) {
        return this.nodes[n].getStatement();
    }

    AstVariable[] getUsed(int n) {
        return this.nodes[n].getUsed();
    }

    AstVariable[] getDefined(int n) {
        return this.nodes[n].getDefined();
    }

    int findDefinitionNext(int n, AstVariable v) {
        boolean isLocal = this.isLocal(v);
        AstType topType = ASTDAG.getTopType((AstObject)v);
        AstType varType = this.getVarTopType(v);
        int i = n + 1;
        while (i < this.nodes.length) {
            if (this.nodes[i].mayBeDefined(v, isLocal, topType, varType)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int findDefinitionPrev(int n, AstVariable v) {
        boolean isLocal = this.isLocal(v);
        AstType topType = ASTDAG.getTopType((AstObject)v);
        AstType varType = this.getVarTopType(v);
        int i = n - 1;
        while (i >= 0) {
            if (this.nodes[i].mayBeDefined(v, isLocal, topType, varType)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    static AstType getTopType(AstObject ast) {
        AstType topType = ast.getObjectKind() == 8 ? (AstType)ast : ast.getDeclaringType();
        AstType nextType = topType;
        while (nextType != null) {
            topType = nextType;
            nextType = nextType.getDeclaringType();
        }
        return topType;
    }

    private boolean isLocal(AstVariable v) {
        if (v.getParent() == null) {
            return true;
        }
        if (v.getParent().getObjectKind() == 50) {
            return false;
        }
        AstTypeReference type = v.getType();
        return type.getBaseType() == null && type.numDimensions() == 0;
    }

    private AstType getVarTopType(AstVariable v) {
        AstType type = v.getType().getBaseType();
        if (type != null) {
            return ASTDAG.getTopType((AstObject)type);
        }
        return null;
    }
}

