/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit;

import com.togethersoft.sca.ast.AstComment;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.core.ICodeInspector;
import com.togethersoft.sca.core.ILog;
import com.togethersoft.sca.core.IMessage;
import com.togethersoft.sca.core.IProject;
import com.togethersoft.sca.core.Message;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.plugin.audit.Audit;
import com.togethersoft.sca.internal.plugin.audit.AuditMessage;
import com.togethersoft.sca.plugin.audit.IAuditRule;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;

public class ReportManager {
    protected ICodeInspector inspector;
    private ILog log;
    private boolean XMLOutput;
    private ArrayList messages = new ArrayList();
    private HashMap filters = new HashMap();
    private HashMap msgMap = new HashMap();

    public ReportManager(ILog log) {
        this.log = log;
        this.XMLOutput = log.isXML();
    }

    public IAuditMessage message(IAuditRule audit, AstObject element, String msg, Object[] values) {
        return this.message(audit, null, element, msg, values, false);
    }

    public IAuditMessage message(IAuditRule audit, IAuditMessage parentMsg, AstObject element, String msg, Object[] values) {
        return this.message(audit, parentMsg, element, msg, values, true);
    }

    private IAuditMessage message(IAuditRule audit, IAuditMessage parentMsg, AstObject element, String msg, Object[] values, boolean isSubMessage) {
        if (element != null) {
            AstComment[] comments = element.getComments();
            int i = 0;
            while (i < comments.length) {
                if (comments[i].isSingleLine()) {
                    String text = comments[i].getComment();
                    String id = audit.getAnalyzer().getId();
                    String filter = (String)this.filters.get(id);
                    if (filter == null) {
                        filter = "$SUP-" + id + '$';
                        this.filters.put(id, filter);
                    }
                    if (text.indexOf(filter) >= 0) {
                        return null;
                    }
                }
                ++i;
            }
        }
        AuditMessage m = null;
        if (!isSubMessage || parentMsg != null) {
            AstPackage pkg;
            if (!isSubMessage && this.isDuplicate(element, msg)) {
                return null;
            }
            if (this.XMLOutput && (pkg = element.getPackage()) == null) {
                this.log.log((IMessage)new Message(1, Audit.getResourceBundle().getString("ReportManager.2"), null));
                return null;
            }
            m = new AuditMessage(this.inspector, audit, element, msg, values);
            if (isSubMessage) {
                parentMsg.addSubMessage((IAuditMessage)m);
            } else {
                this.messages.add(m);
            }
        }
        return m;
    }

    public void printMessages(IProject project) {
        IAuditMessage[] arr = new IAuditMessage[this.messages.size()];
        this.messages.toArray(arr);
        Arrays.sort(arr, new Comparator(){

            public int compare(Object o1, Object o2) {
                IMessage m1 = (IMessage)o1;
                IMessage m2 = (IMessage)o2;
                int cmp = m1.getFileName().compareTo(m2.getFileName());
                if (cmp != 0) {
                    return cmp;
                }
                if (m1.getStartLine() < m2.getStartLine()) {
                    return -1;
                }
                if (m1.getStartLine() > m2.getStartLine()) {
                    return 1;
                }
                if (m1.getStartColumn() < m2.getStartColumn()) {
                    return -1;
                }
                if (m1.getStartColumn() > m2.getStartColumn()) {
                    return 1;
                }
                return 0;
            }
        });
        if (this.XMLOutput) {
            String projectroot = "";
            if (project.getSourceBases().length == 1) {
                projectroot = project.getSourceBases()[0].getBaseLocation();
            }
            String date = DateFormat.getDateInstance(3).format(new Date());
            this.log.log("<audit date=\"" + date + "\" projectroot=\"" + projectroot + "\">\n");
        }
        int i = 0;
        while (i < arr.length) {
            if (this.log == null) {
                System.out.println(arr[i].getMessage());
            } else {
                this.log.log((IMessage)arr[i]);
            }
            ++i;
        }
        if (this.XMLOutput) {
            this.log.log("</audit>");
        }
        this.messages.clear();
    }

    private boolean isDuplicate(AstObject element, String msg) {
        HashSet<String> entry = (HashSet<String>)this.msgMap.get(element);
        if (entry != null) {
            if (entry.contains(msg)) {
                return true;
            }
        } else {
            entry = new HashSet<String>();
            this.msgMap.put(element, entry);
        }
        entry.add(msg);
        return false;
    }
}

