/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit;

import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.core.plugin.HTMLTemplateFormatter;
import com.togethersoft.sca.core.plugin.ITemplateFormatter;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;

public class AuditTemplateFormatter
extends HTMLTemplateFormatter
implements ITemplateFormatter {
    public String format(boolean isQualified, char key, Object printObject) {
        switch (key) {
            case 'C': {
                int code = (Integer)printObject;
                switch (code) {
                    case 6: {
                        return "<<";
                    }
                    case 7: {
                        return ">>";
                    }
                    case 8: {
                        return ">>>";
                    }
                }
                return null;
            }
            case 'T': {
                int type = (Integer)printObject;
                switch (type) {
                    case 4: {
                        return "int";
                    }
                    case 5: {
                        return "long";
                    }
                }
                return null;
            }
            case 'I': {
                IIntegralDomain domain = (IIntegralDomain)printObject;
                return "[" + domain.getLowValue() + ":" + domain.getHighValue() + "]";
            }
            case 'R': {
                AstReference ast = (AstReference)printObject;
                return super.format(isQualified, 'd', (Object)ast.getReferencedElement());
            }
        }
        return super.format(isQualified, key, printObject);
    }
}

