/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit;

import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstSourcePosition;
import com.togethersoft.sca.core.ICodeInspector;
import com.togethersoft.sca.core.IExtension;
import com.togethersoft.sca.core.Message;
import com.togethersoft.sca.core.plugin.TemplateManager;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.plugin.audit.Audit;
import com.togethersoft.sca.plugin.audit.IAuditRule;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class AuditMessage
extends Message
implements IAuditMessage {
    private static final AutoFix[] NO_FIXES = new AutoFix[0];
    private ArrayList subMessages;
    private ArrayList fixes;
    private IAuditRule audit;

    public AuditMessage(ICodeInspector inspector, IAuditRule audit, AstObject ast, String text, Object[] values) {
        super(0, (IExtension)inspector, audit.getAnalyzer(), ast, text, values);
        this.audit = audit;
        this.subMessages = new ArrayList();
    }

    public String getProblemSeverity() {
        return this.audit.getSeverity();
    }

    public AutoFix[] getAutoFixes() {
        AutoFix supFix = this.audit.getSuppressionFix(this);
        int nFixes = 0;
        if (this.fixes != null) {
            nFixes = this.fixes.size();
        }
        if (supFix != null) {
            ++nFixes;
        }
        if (nFixes == 0) {
            return NO_FIXES;
        }
        AutoFix[] fixArr = new AutoFix[nFixes];
        int i = 0;
        if (this.fixes != null) {
            int n = this.fixes.size();
            while (i < n) {
                fixArr[i] = (AutoFix)this.fixes.get(i);
                ++i;
            }
        }
        if (supFix != null) {
            fixArr[i] = supFix;
        }
        return fixArr;
    }

    public void addAutoFix(AutoFix fix) {
        if (fix instanceof ESAutoFix ^ ESAutoFix.enabled) {
            return;
        }
        if (this.fixes == null) {
            this.fixes = new ArrayList();
        }
        this.fixes.add(fix);
    }

    public boolean addSubMessage(IAuditMessage msg) {
        return this.subMessages.add(msg);
    }

    public IAuditMessage[] getSubMessages() {
        return this.subMessages.toArray(new IAuditMessage[0]);
    }

    public String getMessage() {
        ResourceBundle resourceBundle = this.audit.getResourceBundle();
        if (resourceBundle == null) {
            resourceBundle = Audit.getResourceBundle();
        }
        return TemplateManager.getTemplateManager().format(resourceBundle, this.message, this.values);
    }

    public String getMessage(boolean isXML) {
        String msgText;
        String msg = this.getMessage();
        AstSourcePosition pos = this.getAstObject().getPosition();
        if (isXML) {
            AstPackage pkg = this.getAstObject().getPackage();
            String packageName = pkg.getQualifiedName();
            String filename = "";
            int line = 0;
            int col = 0;
            if (pos != null) {
                filename = pos.getFileName();
                line = pos.getStartLine();
                col = pos.getStartColumn();
            }
            StringBuffer sbuf = new StringBuffer(msg);
            this.replaceAll(sbuf, "<", "&lt;");
            this.replaceAll(sbuf, ">", "&gt;");
            msgText = "<testresult>\n\t<property name=\"id\" value=\"" + this.getAnalyzer().getId() + "\" />\n" + "\t<property name=\"message\" value=\"" + sbuf + "\" />\n" + "\t<property name=\"package\" value=\"" + packageName + "\" />\n" + "\t<property name=\"url\" file=\"" + filename + "\" line=\"" + line + "\" col=\"" + col + "\" />\n";
        } else {
            String url = pos != null ? pos.getFileName() + ":" + pos.getStartLine() + ":" + pos.getStartColumn() : "";
            msgText = url + ": " + msg;
        }
        IAuditMessage[] subMsgs = this.getSubMessages();
        int i = 0;
        while (i < subMsgs.length) {
            msgText = msgText + "\n" + subMsgs[i].getMessage(isXML);
            ++i;
        }
        if (isXML) {
            msgText = msgText + "</testresult>\n";
        }
        return msgText;
    }

    /*
     * WARNING - void declaration
     */
    private void replaceAll(StringBuffer sbuf, String from, String to) {
        int index;
        while ((index = sbuf.toString().indexOf(from)) >= 0) {
            void var4_4;
            sbuf.replace((int)var4_4, (int)(var4_4 + from.length()), to);
        }
    }

    public String getExplainMessage() {
        return this.audit.getExplainMessage(this.ast, this.message, this.values);
    }
}

