/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.audit;

import com.togethersoft.sca.ast.AstArrayCreationExpression;
import com.togethersoft.sca.ast.AstArrayInitializer;
import com.togethersoft.sca.ast.AstArrayReference;
import com.togethersoft.sca.ast.AstAssertStatement;
import com.togethersoft.sca.ast.AstAssignmentExpression;
import com.togethersoft.sca.ast.AstBinaryExpression;
import com.togethersoft.sca.ast.AstBreakStatement;
import com.togethersoft.sca.ast.AstCastExpression;
import com.togethersoft.sca.ast.AstCatchClause;
import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstConditionalExpression;
import com.togethersoft.sca.ast.AstConstructorInvocation;
import com.togethersoft.sca.ast.AstContinueStatement;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstDeclarationStatement;
import com.togethersoft.sca.ast.AstDoStatement;
import com.togethersoft.sca.ast.AstEmptyStatement;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstExpressionStatement;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstFieldReference;
import com.togethersoft.sca.ast.AstFinallyClause;
import com.togethersoft.sca.ast.AstForStatement;
import com.togethersoft.sca.ast.AstIfStatement;
import com.togethersoft.sca.ast.AstLiteral;
import com.togethersoft.sca.ast.AstMember;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstMethodCallExpression;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstObjectCreationExpression;
import com.togethersoft.sca.ast.AstObjectFactory;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstParenthesizedExpression;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.ast.AstReturnStatement;
import com.togethersoft.sca.ast.AstSimpleReference;
import com.togethersoft.sca.ast.AstSourcePosition;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstSuperExpression;
import com.togethersoft.sca.ast.AstSwitchGroup;
import com.togethersoft.sca.ast.AstSwitchStatement;
import com.togethersoft.sca.ast.AstSynchronizedStatement;
import com.togethersoft.sca.ast.AstThisExpression;
import com.togethersoft.sca.ast.AstThrowStatement;
import com.togethersoft.sca.ast.AstTryStatement;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeExpression;
import com.togethersoft.sca.ast.AstUnaryExpression;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.ast.AstWhileStatement;
import com.togethersoft.sca.core.Factory;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IAnalyzerRegistry;
import com.togethersoft.sca.core.ICodeInspectorExecutable;
import com.togethersoft.sca.core.ILog;
import com.togethersoft.sca.core.IMessage;
import com.togethersoft.sca.core.IParameter;
import com.togethersoft.sca.core.IParameterRegistry;
import com.togethersoft.sca.core.IParameterString;
import com.togethersoft.sca.core.IParameterStringEnum;
import com.togethersoft.sca.core.IProject;
import com.togethersoft.sca.core.JobControl;
import com.togethersoft.sca.core.Message;
import com.togethersoft.sca.core.plugin.ITemplateFormatter;
import com.togethersoft.sca.core.plugin.TemplateManager;
import com.togethersoft.sca.core.plugin.audit.AutoFix;
import com.togethersoft.sca.core.plugin.audit.IAuditMessage;
import com.togethersoft.sca.dataflow.IField;
import com.togethersoft.sca.dataflow.IMethod;
import com.togethersoft.sca.dataflow.flowgraph.IBasicBlock;
import com.togethersoft.sca.dataflow.flowgraph.IJavaLoop;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.ITupleSet;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.core.plugin.audit.ESAutoFix;
import com.togethersoft.sca.internal.dataflow.DataFlowAnalyzer;
import com.togethersoft.sca.internal.dataflow.Field;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.flowgraph.DataFlowGraph;
import com.togethersoft.sca.internal.dataflow.flowgraph.TupleSet;
import com.togethersoft.sca.internal.plugin.audit.ASTAutoFix;
import com.togethersoft.sca.internal.plugin.audit.AuditTemplateFormatter;
import com.togethersoft.sca.internal.plugin.audit.ReportManager;
import com.togethersoft.sca.internal.plugin.audit.impl.Util;
import com.togethersoft.sca.internal.plugin.audit.sync.CallContext;
import com.togethersoft.sca.internal.plugin.audit.sync.ClassDesc;
import com.togethersoft.sca.internal.plugin.audit.sync.FieldDesc;
import com.togethersoft.sca.internal.plugin.audit.sync.GraphVertex;
import com.togethersoft.sca.internal.plugin.audit.sync.MethodDesc;
import com.togethersoft.sca.internal.plugin.audit.sync.VertexList;
import com.togethersoft.sca.plugin.audit.AuditRule;
import com.togethersoft.sca.plugin.audit.IAuditRule;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;

public class Audit
implements ICodeInspectorExecutable {
    private static ReportManager logger;
    private boolean trace;
    private IAuditRule[][] rules = new IAuditRule[9][];
    private ILog projectLog;
    private IProject project;
    private JobControl jobControl;
    private double delta;
    private DataFlowAnalyzer analyzer;
    private boolean doDataflowAnalysis;
    private static IAuditRule[] builtinRules;
    private static String[] ruleNames;
    private static final String[] metricParams;
    private boolean excludeMetrics = true;
    private HashSet metricsList;
    public static final int MSG_SUPER_FINALIZE = 0;
    public static final int MSG_SHADOW_LOCAL = 1;
    public static final int MSG_SIDE_EFFECT = 2;
    public static final int MSG_PRECEDENCE = 3;
    public static final int MSG_ASSIGN_IN_CONDITION = 4;
    public static final int MSG_SYNC_LOOP = 5;
    public static final int MSG_WAIT = 6;
    public static final int MSG_NOSYNC = 7;
    public static final int MSG_RACE_CONDITION = 8;
    public static final int MSG_ACCESS_WITHOUT_LOCK = 9;
    public static final int MSG_INCONSISTENT_LOCKING = 10;
    public static final int MSG_WAIT_NOSYNC = 11;
    public static final int MSG_YIELD = 12;
    public static final int SCOPE_CLASS = 0;
    public static final int SCOPE_PACKAGE = 1;
    public static final int SCOPE_PROJECT = 2;
    private static int scope;
    private static final ResourceBundle resourceBundle;
    private static final ClassLoader myClassLoader;
    private static final TemplateManager templateManager;
    private static ClassDesc classes;
    private ClassDesc currentClass;
    private HashMap shadowedFields;
    private boolean superFinalize;
    private int superFinalizeLine = 0;
    private int superFinalizeColumn = 0;
    private VertexList monitors;
    private VertexList topLevelSyncBlocks;
    private ArrayList syncExprs;
    public static boolean reportAllLoops;
    public static boolean allPublicReentrant;
    public static boolean overrideAlienMethods;
    static /* synthetic */ Class class$com$togethersoft$sca$internal$plugin$audit$Audit;

    public static ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static ClassLoader getClassLoader() {
        return myClassLoader;
    }

    public static TemplateManager getTemplateManager() {
        return templateManager;
    }

    public static int getScope() {
        return scope;
    }

    public static boolean hasFullInfo(AstMember m) {
        return scope == 0 && m.isPrivate() || scope == 1 && (m.isPrivate() || m.isPackage()) || scope == 2;
    }

    public static IAuditMessage message(AuditRule rule, int depth, int weight, LinkedList trees) {
        IAuditMessage msg = null;
        int index = 0;
        Iterator i = trees.iterator();
        block0: while (i.hasNext()) {
            IAuditMessage submsg = null;
            ++index;
            AstStatement[] stmts = (AstStatement[])i.next();
            int j = 0;
            while (j < stmts.length) {
                AstStatement t = stmts[j];
                if (msg == null) {
                    msg = Audit.message((IAuditRule)rule, (AstObject)t, rule.getAnalyzer().getName(), null);
                }
                if (submsg == null) {
                    submsg = Audit.message(rule, msg, (AstObject)t, "AuditPlugin.DC.1", new Object[]{new Integer(index)});
                }
                if (stmts.length == 1) continue block0;
                Audit.message(rule, submsg, (AstObject)t, "AuditPlugin.11", new Object[]{new Integer(j + 1)});
                ++j;
            }
        }
        return msg;
    }

    public static boolean isSpecial(AstMethod method) {
        return method.isInitializer() || method.isConstructor() || method.getElementName().equals("main") && method.getSignature().equals("([Ljava/lang/String;)V");
    }

    public static AstMethod[] getMethodHierarchy(AstMethod method) {
        HashSet ovr = new HashSet();
        Audit.processMethod(ovr, method);
        return ((AbstractCollection)ovr).toArray(new AstMethod[ovr.size()]);
    }

    private static void processMethod(HashSet ovr, AstMethod method) {
        ovr.add(method);
        AstMethod[] overriders = method.overriddenBy();
        int i = 0;
        while (i < overriders.length) {
            ovr.add(overriders[i]);
            ++i;
        }
        AstMethod[] overridden = method.getOverridden();
        int i2 = 0;
        while (i2 < overridden.length) {
            Audit.processMethod(ovr, overridden[i2]);
            ++i2;
        }
    }

    public static IAuditMessage message(int rule, AstObject element) {
        if (rule >= 0 && rule < builtinRules.length && builtinRules[rule] != null) {
            return logger.message(builtinRules[rule], element, builtinRules[rule].getAnalyzer().getName(), null);
        }
        return null;
    }

    public static IAuditMessage message(int rule, AstObject element, String msg, Object[] values) {
        if (rule >= 0 && rule < builtinRules.length && builtinRules[rule] != null) {
            return logger.message(builtinRules[rule], element, msg, values);
        }
        return null;
    }

    public static IAuditMessage message(int rule, IAuditMessage parentMsg, AstObject element, String msg, Object[] values) {
        if (rule >= 0 && rule < builtinRules.length && builtinRules[rule] != null) {
            return logger.message(builtinRules[rule], parentMsg, element, msg, values);
        }
        return null;
    }

    public static IAuditMessage message(int rule, IAuditMessage parentMsg, AstObject element) {
        if (rule >= 0 && rule < builtinRules.length && builtinRules[rule] != null) {
            return logger.message(builtinRules[rule], parentMsg, element, builtinRules[rule].getAnalyzer().getName(), null);
        }
        return null;
    }

    public static IAuditMessage message(IAuditRule audit, AstObject element, String msg, Object[] values) {
        return logger.message(audit, element, msg, values);
    }

    public static IAuditMessage message(IAuditRule audit, IAuditMessage parentMessage, AstObject element, String msg, Object[] values) {
        return logger.message(audit, parentMessage, element, msg, values);
    }

    public Audit() {
        builtinRules = new IAuditRule[ruleNames.length];
    }

    public void setParameters(IParameterRegistry registry) {
        IParameterStringEnum iParameterStringEnum = (IParameterStringEnum)registry.getParameter("Scope", 4);
        if (iParameterStringEnum != null) {
            scope = iParameterStringEnum.getOrdinalValue();
        }
    }

    public void configureRegistry(IAnalyzerRegistry registry) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProject project, IAnalyzerDescriptor[] analyzers, JobControl jobControl) {
        block14: {
            block12: {
                block13: {
                    this.project = project;
                    this.jobControl = jobControl;
                    this.projectLog = project.getLog();
                    try {
                        try {
                            if (jobControl != null) {
                                int numFiles = project.getSourceFiles().length;
                                if (numFiles > 0) {
                                    jobControl.setScale(0.5);
                                    this.delta = 1.0 / (double)numFiles;
                                } else {
                                    jobControl.update(1.0);
                                    Object var6_7 = null;
                                    if (jobControl == null) break block12;
                                    break block13;
                                }
                            }
                            AstModel model = project.getModel();
                            this.analyzer = new DataFlowAnalyzer();
                            this.loadRules(analyzers);
                            if (this.doDataflowAnalysis) {
                                this.analyzer.setup(model, null);
                                this.analyzer.analyze(jobControl);
                            }
                            this.processModel(model);
                            logger.printMessages(project);
                            break block14;
                        }
                        catch (Throwable x) {
                            this.projectLog.log((IMessage)new Message(3, Audit.getResourceBundle().getString("AuditPlugin.3"), new Object[]{x}));
                            x.printStackTrace();
                            Object var6_9 = null;
                            if (jobControl != null) {
                                jobControl.setScale(2.0);
                            }
                            this.cleanup();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        if (jobControl != null) {
                            jobControl.setScale(2.0);
                        }
                        this.cleanup();
                        throw throwable;
                    }
                }
                jobControl.setScale(2.0);
            }
            this.cleanup();
            return;
        }
        Object var6_8 = null;
        if (jobControl != null) {
            jobControl.setScale(2.0);
        }
        this.cleanup();
    }

    private void cleanup() {
        if (this.analyzer != null) {
            this.analyzer.close();
        }
        logger = null;
        builtinRules = null;
        classes = null;
        GraphVertex.graph = null;
        MethodDesc.cleanup();
    }

    private void loadRules(IAnalyzerDescriptor[] analyzers) {
        LinkedList<AuditRule> stmtList = new LinkedList<AuditRule>();
        LinkedList<AuditRule> exprList = new LinkedList<AuditRule>();
        LinkedList<AuditRule> declList = new LinkedList<AuditRule>();
        LinkedList<AuditRule> tupleList = new LinkedList<AuditRule>();
        logger = new ReportManager(this.projectLog);
        this.trace = Boolean.getBoolean("trace");
        int i = 0;
        while (i < analyzers.length) {
            block13: {
                AuditRule ruleImpl;
                String severity;
                IAnalyzerDescriptor rule;
                block15: {
                    block14: {
                        IParameter paramSeverity;
                        IParameterRegistry registry;
                        block12: {
                            rule = analyzers[i];
                            registry = rule.getParameterRegistry();
                            paramSeverity = registry.getParameter("severity", 2);
                            if (paramSeverity != null) break block12;
                            this.projectLog.log(Audit.getResourceBundle().getString("AuditPlugin.7"), new Object[]{rule.getId()});
                            break block13;
                        }
                        severity = ((IParameterString)paramSeverity).getValue();
                        ruleImpl = null;
                        if (!rule.getImplementation().equals("builtin")) break block14;
                        int j = 0;
                        while (j < ruleNames.length) {
                            if (rule.getId().equals(ruleNames[j])) {
                                ruleImpl = new AuditRule(15);
                                Audit.builtinRules[j] = ruleImpl;
                                if (j != 5) break;
                                reportAllLoops = registry.getBooleanValue("report-all-loops", false);
                                allPublicReentrant = registry.getBooleanValue("all-public-reentrant", false);
                                overrideAlienMethods = registry.getBooleanValue("override-alien-methods", false);
                                break;
                            }
                            ++j;
                        }
                        if (ruleImpl != null) break block15;
                        this.projectLog.log((IMessage)new Message(2, Audit.getResourceBundle().getString("AuditPlugin.4"), new Object[]{rule.getName()}));
                        break block13;
                    }
                    ruleImpl = this.createAudit(this.projectLog, rule);
                    if (ruleImpl == null) break block13;
                }
                ruleImpl.setDataFlowAnalyzer(this.analyzer);
                ruleImpl.setProject(this.project);
                ruleImpl.setParameters(rule, severity, logger);
                if (ruleImpl.requiresDataFlowAnalysis()) {
                    this.doDataflowAnalysis = true;
                }
                if ((ruleImpl.getGroup() & 1) != 0) {
                    stmtList.add(ruleImpl);
                }
                if ((ruleImpl.getGroup() & 2) != 0) {
                    exprList.add(ruleImpl);
                }
                if ((ruleImpl.getGroup() & 4) != 0) {
                    declList.add(ruleImpl);
                }
                if ((ruleImpl.getGroup() & 8) != 0) {
                    tupleList.add(ruleImpl);
                }
            }
            ++i;
        }
        this.rules[1] = stmtList.toArray(new AuditRule[stmtList.size()]);
        this.rules[2] = exprList.toArray(new AuditRule[exprList.size()]);
        this.rules[4] = declList.toArray(new AuditRule[declList.size()]);
        this.rules[8] = tupleList.toArray(new AuditRule[tupleList.size()]);
        if (this.rules[8].length > 0) {
            this.doDataflowAnalysis = true;
        }
    }

    private AuditRule createAudit(ILog log, IAnalyzerDescriptor rule) {
        AuditRule impl = null;
        String runclass = rule.getImplementation();
        try {
            String library = rule.getLibrary();
            ClassLoader loader = library != null && !library.equals("") ? new URLClassLoader(new URL[]{new URL(rule.getInspector().getLocation() + "/" + library)}, this.getClass().getClassLoader()) : this.getClass().getClassLoader();
            Class<?> cls = Class.forName(runclass, true, loader);
            impl = (AuditRule)cls.newInstance();
        }
        catch (Exception e) {
            log.log((IMessage)new Message(2, Audit.getResourceBundle().getString("AuditPlugin.1"), new Object[]{runclass, e}));
        }
        catch (NoClassDefFoundError e) {
            log.log((IMessage)new Message(2, Audit.getResourceBundle().getString("AuditPlugin.1"), new Object[]{runclass, e}));
        }
        return impl;
    }

    private void processModel(AstModel model) {
        AstPackage[] pkgs = this.project.getModel().getPackages();
        int i = 0;
        while (i < pkgs.length) {
            if (this.jobControl != null && this.jobControl.isCanceled()) {
                return;
            }
            this.processPackage(pkgs[i]);
            ++i;
        }
        if (this.doDataflowAnalysis) {
            this.checkFields();
            this.checkMethods();
        }
        this.checkSync();
        int i2 = 0;
        while (i2 < this.rules[4].length) {
            this.rules[4][i2].checkModel(model);
            ++i2;
        }
    }

    private void processPackage(AstPackage pkg) {
        int i = 0;
        while (i < this.rules[4].length) {
            this.rules[4][i].enterPackage(pkg);
            ++i;
        }
        AstCompilationUnit[] units = pkg.getCompilationUnits();
        int i2 = 0;
        while (i2 < units.length) {
            try {
                this.processCompilationUnit(units[i2]);
                AstType[] types = units[i2].getTypes();
                int j = 0;
                while (j < types.length) {
                    this.processClass(types[j]);
                    ++j;
                }
            }
            catch (Throwable e) {
                this.projectLog.log((IMessage)new Message(3, Audit.getResourceBundle().getString("AuditPlugin.3"), new Object[]{e}));
                e.printStackTrace();
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.rules[4].length) {
            this.rules[4][i3].leavePackage(pkg);
            ++i3;
        }
        AstPackage[] subPkgs = pkg.getSubpackages();
        int i4 = 0;
        while (i4 < subPkgs.length) {
            this.processPackage(subPkgs[i4]);
            ++i4;
        }
    }

    private void processCompilationUnit(AstCompilationUnit cls) {
        int i = 0;
        while (i < this.rules[4].length) {
            this.rules[4][i].checkCompilationUnit(cls);
            ++i;
        }
        if (this.jobControl != null) {
            this.jobControl.update(this.delta);
        }
    }

    private void processClass(AstType cls) {
        ClassDesc saveCurrentClass = this.currentClass;
        int i = 0;
        while (i < this.rules[4].length) {
            this.rules[4][i].checkType(cls);
            ++i;
        }
        AstField[] fields = cls.getFields();
        int i2 = 0;
        while (i2 < fields.length) {
            AstField f = fields[i2];
            int j = 0;
            while (j < this.rules[4].length) {
                this.rules[4][j].checkField(f);
                ++j;
            }
            if (f.getInitializer() != null) {
                this.processExpression(null, null, f.getInitializer());
            }
            ++i2;
        }
        AstMethod[] methods = cls.getExecutableFragments();
        this.currentClass = Audit.getClass(cls);
        int i3 = 0;
        while (i3 < methods.length) {
            this.processMethod(methods[i3], Audit.getMethod(methods[i3]));
            ++i3;
        }
        AstType[] types = cls.getTypes();
        int i4 = 0;
        while (i4 < types.length) {
            this.processClass(types[i4]);
            ++i4;
        }
        this.currentClass = saveCurrentClass;
    }

    private void processMethod(AstMethod mth, MethodDesc methodDesc) {
        DataFlowGraph fg;
        AstCompoundStatement body;
        if (!mth.isConstructor() && !mth.isInitializer()) {
            int i = 0;
            while (i < this.rules[4].length) {
                this.rules[4][i].checkMethod(mth);
                ++i;
            }
        }
        if ((body = mth.getBody()) == null) {
            return;
        }
        AstVariable[] params = mth.getParameters();
        int i = 0;
        while (i < params.length) {
            this.processDecl(mth, methodDesc, (AstDeclaration)params[i]);
            ++i;
        }
        if (this.doDataflowAnalysis && (fg = this.analyzer.getDataFlowGraph(mth)) != null && mth.isErrorFree()) {
            if (this.trace) {
                fg.print(System.err);
            }
            this.lifetimeAnalysis(fg);
            IBasicBlock bl = fg.getBasicBlockList();
            if (bl != null) {
                this.loopAnalysis(bl.getCFG().getLoops());
            }
            while (bl != null) {
                this.basicBlockAnalysis(bl);
                bl = bl.getNext();
            }
            ITuple tuple = fg.getTupleList();
            while (tuple != null) {
                this.dataFlowAnalysis(tuple);
                tuple = tuple.getNext();
            }
        }
        HashMap savedShadowedFields = this.shadowedFields;
        boolean savedSuperFinalize = this.superFinalize;
        VertexList savedMonitors = this.monitors;
        VertexList savedTopLevelSyncBlocks = this.topLevelSyncBlocks;
        ArrayList savedSyncExprs = this.syncExprs;
        this.monitors = new VertexList();
        this.topLevelSyncBlocks = new VertexList();
        this.syncExprs = new ArrayList();
        if (mth.isSynchronized()) {
            GraphVertex monitor = mth.isStatic() ? methodDesc.cls.metaclassMonitor : methodDesc.cls.classMonitor;
            this.monitors.push(monitor);
            this.topLevelSyncBlocks.push(monitor);
            this.syncExprs.add(mth);
        }
        this.shadowedFields = new HashMap();
        this.superFinalize = false;
        this.processStatement(mth, methodDesc, (AstStatement)body);
        methodDesc.topLevelSyncBlocks = this.topLevelSyncBlocks.toArray();
        methodDesc.syncExpr = this.syncExprs.toArray(new AstObject[this.syncExprs.size()]);
        if (mth.getElementName().equals("finalize")) {
            IAuditMessage m;
            final AstMethod finalizeMethod = mth;
            AstStatement[] stms = finalizeMethod.getBody().getStatements();
            if (finalizeMethod.getParameters().length > 0) {
                m = Audit.message(0, (AstObject)finalizeMethod, "AuditCSF.1", new Object[]{finalizeMethod});
            }
            AstReference[] refs = finalizeMethod.getReferences();
            int i2 = 0;
            while (i2 < refs.length) {
                m = Audit.message(0, (AstObject)refs[i2], "AuditCSF.3", new Object[]{refs[i2]});
                ++i2;
            }
            if (stms.length == 0) {
                m = Audit.message(0, (AstObject)finalizeMethod, "AuditCSF.2", new Object[]{finalizeMethod});
            } else {
                int lastLine = stms[stms.length - 1].getPosition().getStartLine();
                int lastColumn = stms[stms.length - 1].getPosition().getStartColumn();
                if (!this.superFinalize || this.superFinalizeLine < lastLine || this.superFinalizeLine < lastColumn) {
                    m = Audit.message(0, (AstObject)finalizeMethod, "AuditCSF.4", new Object[]{finalizeMethod});
                    if (m != null) {
                        m.addAutoFix((AutoFix)new ASTAutoFix("AuditCSF.Autofix"){

                            public boolean fix() {
                                AstObjectFactory factory = Factory.getObjectFactory();
                                AstExpressionStatement invokeSuper = factory.createAstExpressionStatement((AstExpression)factory.createAstMethodCallExpression((AstExpression)factory.createAstFieldReference((AstExpression)factory.createAstSuperExpression(), 1, "finalize"), new AstExpression[0]));
                                finalizeMethod.getBody().prepend((AstStatement)invokeSuper);
                                return true;
                            }
                        });
                        AstStatement[] stmts = finalizeMethod.getBody().getStatements();
                        if (stmts.length > 0) {
                            ESAutoFix fix = new ESAutoFix(m, AuditRule.getAutoFixName(m));
                            fix.setTabSize(this.project.getTabSize());
                            fix.insertLine(stmts[0].getPosition(), "super.finilize();");
                            fix.indent(stmts[0].getPosition().getStartColumn());
                        }
                    }
                } else if (stms.length == 1) {
                    m = Audit.message(0, (AstObject)finalizeMethod, "AuditCSF.5", new Object[]{finalizeMethod});
                }
            }
        }
        this.shadowedFields = savedShadowedFields;
        this.superFinalize = savedSuperFinalize;
        this.monitors = savedMonitors;
        this.topLevelSyncBlocks = savedTopLevelSyncBlocks;
        this.syncExprs = savedSyncExprs;
        if (!mth.isConstructor() && !mth.isInitializer()) {
            int i3 = 0;
            while (i3 < this.rules[4].length) {
                this.rules[4][i3].leaveMethod(mth);
                ++i3;
            }
        }
    }

    private void loopAnalysis(IJavaLoop[] loops) {
        if (loops == null) {
            return;
        }
        int i = 0;
        while (i < loops.length) {
            IJavaLoop l = loops[i];
            this.loopAnalysis(l.subLoops());
            int j = 0;
            while (j < this.rules[8].length) {
                this.rules[8][j].checkLoop(l);
                ++j;
            }
            ++i;
        }
    }

    private void dataFlowAnalysis(ITuple tuple) {
        int cop = tuple.getCode();
        if (tuple.isAssertGenerated() && cop != 61) {
            return;
        }
        IVal[] operands = tuple.operands();
        IValueDomain[] values = tuple.operandValues();
        IValueDomain result = tuple.resultValue();
        if (values == null) {
            if (cop == 40 || cop == 44 || cop == 47 || cop == 33 || cop == 62 || cop == 43 && tuple.operands() == null || cop == 29 && tuple.operands() == null || cop == 30 && tuple.operands() == null) {
                return;
            }
            this.projectLog.log((IMessage)new Message(1, Audit.getResourceBundle().getString("AuditPlugin.2"), new Object[]{new Integer(cop), new Integer(tuple.getStartLine())}));
            return;
        }
        int i = 0;
        while (i < this.rules[8].length) {
            this.rules[8][i].checkTuple(tuple, operands, values, result);
            ++i;
        }
    }

    private void basicBlockAnalysis(IBasicBlock block) {
        int i = 0;
        while (i < this.rules[8].length) {
            this.rules[8][i].checkBasicBlock(block);
            ++i;
        }
    }

    private void processDecl(AstMethod method, MethodDesc methodDesc, AstDeclaration decl) {
        switch (decl.getObjectKind()) {
            case 9: {
                AstVariable var = (AstVariable)decl;
                int i = 0;
                while (i < this.rules[4].length) {
                    this.rules[4][i].checkVariable(var);
                    ++i;
                }
                if (var.getInitializer() == null) break;
                this.processExpression(method, methodDesc, var.getInitializer());
            }
        }
    }

    private void processStatement(AstMethod method, MethodDesc methodDesc, AstStatement aStmt) {
        switch (aStmt.getObjectKind()) {
            case 47: {
                AstAssertStatement stmt = (AstAssertStatement)aStmt;
                int j = 0;
                while (j < this.rules[1].length) {
                    this.rules[1][j].checkAssertStatement(stmt);
                    ++j;
                }
                this.processExpression(method, methodDesc, stmt.getCondition());
                if (stmt.getArgument() == null) break;
                this.processExpression(method, methodDesc, stmt.getArgument());
                break;
            }
            case 10: {
                AstWhileStatement stmt = (AstWhileStatement)aStmt;
                int j = 0;
                while (j < this.rules[1].length) {
                    this.rules[1][j].checkWhileStatement(stmt);
                    ++j;
                }
                this.processExpression(method, methodDesc, stmt.getCondition());
                this.processStatement(method, methodDesc, stmt.getBody());
                this.processCondition(stmt.getCondition());
                break;
            }
            case 11: {
                AstTryStatement stmt = (AstTryStatement)aStmt;
                int j = 0;
                while (j < this.rules[1].length) {
                    this.rules[1][j].checkTryStatement(stmt);
                    ++j;
                }
                AstCatchClause[] stmtCatchClauses = stmt.getCatchClauses();
                this.processStatement(method, methodDesc, (AstStatement)stmt.getBody());
                int i = 0;
                while (i < stmtCatchClauses.length) {
                    this.processStatement(method, methodDesc, (AstStatement)stmtCatchClauses[i]);
                    ++i;
                }
                AstFinallyClause finallyClause = stmt.getFinallyClause();
                if (finallyClause == null) break;
                this.processStatement(method, methodDesc, (AstStatement)finallyClause);
                break;
            }
            case 12: {
                AstSynchronizedStatement stmt = (AstSynchronizedStatement)aStmt;
                int j = 0;
                while (j < this.rules[1].length) {
                    this.rules[1][j].checkSynchronizedStatement(stmt);
                    ++j;
                }
                AstExpression expr = stmt.getExpression();
                this.processExpression(method, methodDesc, expr);
                GraphVertex monitor = null;
                if (expr instanceof AstReference) {
                    AstReference ref = (AstReference)expr;
                    if (ref instanceof AstFieldReference && ((AstFieldReference)ref).getBaseExpression().getObjectKind() == 42) {
                        monitor = method.isStatic() ? methodDesc.cls.metaclassMonitor : methodDesc.cls.classMonitor;
                    } else {
                        AstDeclaration decl = ref.getReferencedElement();
                        if (decl != null) {
                            if (decl.getObjectKind() == 9) {
                                AstVariable field = (AstVariable)decl;
                                AstType accessedClass = field.getDeclaringType();
                                ClassDesc objClsDesc = Audit.getClass(accessedClass);
                                FieldDesc fieldDesc = objClsDesc.getField(field);
                                monitor = fieldDesc.syncObject;
                                if (monitor == null) {
                                    fieldDesc.syncObject = monitor = new GraphVertex();
                                }
                            } else if (decl.getObjectKind() == 6) {
                                AstMethod calledMethod = (AstMethod)decl;
                                AstType calledClass = calledMethod.getDeclaringType();
                                ClassDesc cd = Audit.getClass(calledClass);
                                MethodDesc md = cd.getMethod(calledMethod);
                                monitor = md.syncObject;
                                if (monitor == null) {
                                    md.syncObject = monitor = new GraphVertex();
                                }
                            }
                        }
                    }
                }
                if (monitor == null) {
                    monitor = new GraphVertex();
                }
                if (!this.monitors.empty()) {
                    this.monitors.top().addEdge(monitor, (AstObject)expr, CallContext.synchronizedEnter);
                } else {
                    this.syncExprs.add(expr);
                    this.topLevelSyncBlocks.push(monitor);
                }
                this.monitors.push(monitor);
                this.processStatement(method, methodDesc, (AstStatement)stmt.getBody());
                this.monitors.pop();
                break;
            }
            case 13: {
                AstSwitchStatement stmt = (AstSwitchStatement)aStmt;
                int j = 0;
                while (j < this.rules[1].length) {
                    this.rules[1][j].checkSwitchStatement(stmt);
                    ++j;
                }
                this.processExpression(method, methodDesc, stmt.getCondition());
                this.processStatements(method, methodDesc, (AstStatement[])stmt.getBody());
                this.processCondition(stmt.getCondition());
                break;
            }
            case 26: {
                AstSwitchGroup stmt = (AstSwitchGroup)aStmt;
                this.processStatements(method, methodDesc, stmt.getStatements());
                break;
            }
            case 14: {
                AstReturnStatement stmt = (AstReturnStatement)aStmt;
                int j = 0;
                while (j < this.rules[1].length) {
                    this.rules[1][j].checkReturnStatement(stmt);
                    ++j;
                }
                AstExpression expr = stmt.getReturnExpression();
                if (expr == null) break;
                this.processExpression(method, methodDesc, stmt.getReturnExpression());
                break;
            }
            case 15: {
                AstThrowStatement stmt = (AstThrowStatement)aStmt;
                int j = 0;
                while (j < this.rules[1].length) {
                    this.rules[1][j].checkThrowStatement(stmt);
                    ++j;
                }
                this.processExpression(method, methodDesc, stmt.getExpression());
                break;
            }
            case 20: {
                AstCatchClause stmt = (AstCatchClause)aStmt;
                this.processStatement(method, methodDesc, (AstStatement)stmt.getBody());
                break;
            }
            case 25: {
                AstFinallyClause stmt = (AstFinallyClause)aStmt;
                this.processStatement(method, methodDesc, (AstStatement)stmt.getBody());
                break;
            }
            case 16: {
                AstIfStatement stmt = (AstIfStatement)aStmt;
                int j = 0;
                while (j < this.rules[1].length) {
                    this.rules[1][j].checkIfStatement(stmt);
                    ++j;
                }
                this.processExpression(method, methodDesc, stmt.getCondition());
                this.processStatement(method, methodDesc, stmt.getThenStatement());
                AstStatement elseStmt = stmt.getElseStatement();
                if (elseStmt != null) {
                    this.processStatement(method, methodDesc, elseStmt);
                }
                this.processCondition(stmt.getCondition());
                break;
            }
            case 17: {
                AstForStatement stmt = (AstForStatement)aStmt;
                int j = 0;
                while (j < this.rules[1].length) {
                    this.rules[1][j].checkForStatement(stmt);
                    ++j;
                }
                this.processStatements(method, methodDesc, stmt.getInitializers());
                AstExpression expr = stmt.getCondition();
                if (expr != null) {
                    this.processExpression(method, methodDesc, expr);
                }
                this.processStatements(method, methodDesc, stmt.getUpdateStatements());
                this.processStatement(method, methodDesc, stmt.getBody());
                this.processCondition(stmt.getCondition());
                break;
            }
            case 18: {
                AstBreakStatement stmt = (AstBreakStatement)aStmt;
                int j = 0;
                while (j < this.rules[1].length) {
                    this.rules[1][j].checkBreakStatement(stmt);
                    ++j;
                }
                break;
            }
            case 28: {
                AstContinueStatement stmt = (AstContinueStatement)aStmt;
                int j = 0;
                while (j < this.rules[1].length) {
                    this.rules[1][j].checkContinueStatement(stmt);
                    ++j;
                }
                break;
            }
            case 22: {
                AstEmptyStatement stmt = (AstEmptyStatement)aStmt;
                int j = 0;
                while (j < this.rules[1].length) {
                    this.rules[1][j].checkEmptyStatement(stmt);
                    ++j;
                }
                break;
            }
            case 24: {
                AstDeclarationStatement stmt = (AstDeclarationStatement)aStmt;
                AstDeclaration[] decl = stmt.getDeclarations();
                int j = 0;
                while (j < this.rules[1].length) {
                    this.rules[1][j].checkDeclarationStatement(stmt);
                    ++j;
                }
                int i = 0;
                while (i < decl.length) {
                    this.processDecl(method, methodDesc, decl[i]);
                    ++i;
                }
                break;
            }
            case 23: {
                AstExpressionStatement stmt = (AstExpressionStatement)aStmt;
                int j = 0;
                while (j < this.rules[1].length) {
                    this.rules[1][j].checkExpressionStatement(stmt);
                    ++j;
                }
                this.processExpression(method, methodDesc, stmt.getExpression());
                break;
            }
            case 21: {
                AstCompoundStatement stmt = (AstCompoundStatement)aStmt;
                int j = 0;
                while (j < this.rules[1].length) {
                    this.rules[1][j].checkCompoundStatement(stmt);
                    ++j;
                }
                AstVariable[] locals = stmt.getLocalVariables();
                ArrayList<AstField> shadowed = null;
                AstType type = stmt.getDeclaringType();
                int i = 0;
                while (i < locals.length) {
                    AstField field = type.findField(locals[i].getElementName(), true);
                    if (!(field == null || field.getDeclaringType() != type && (field.getModifiers() & 2) != 0 || method.isStatic() && !field.isStatic() || this.shadowedFields.get(field.getElementName()) != null)) {
                        if (shadowed == null) {
                            shadowed = new ArrayList<AstField>();
                        }
                        shadowed.add(field);
                        this.shadowedFields.put(field.getElementName(), new ShadowedField((AstVariable)field, locals[i]));
                    }
                    ++i;
                }
                this.processStatements(method, methodDesc, stmt.getStatements());
                int j2 = 0;
                while (j2 < this.rules[1].length) {
                    this.rules[1][j2].leaveCompoundStatement(stmt);
                    ++j2;
                }
                if (shadowed == null) break;
                Iterator iter = ((AbstractList)shadowed).iterator();
                while (iter.hasNext()) {
                    AstVariable v = (AstVariable)iter.next();
                    ShadowedField f = (ShadowedField)this.shadowedFields.remove(v.getElementName());
                    if (f.referenced) continue;
                    Audit.message(1, (AstObject)f.local, "AuditPlugin.8", new Object[]{v, f.field});
                }
                break;
            }
            case 27: {
                AstDoStatement stmt = (AstDoStatement)aStmt;
                int j = 0;
                while (j < this.rules[1].length) {
                    this.rules[1][j].checkDoStatement(stmt);
                    ++j;
                }
                this.processExpression(method, methodDesc, stmt.getCondition());
                this.processStatement(method, methodDesc, stmt.getBody());
                this.processCondition(stmt.getCondition());
                break;
            }
            default: {
                this.projectLog.log((IMessage)new Message(1, Audit.getResourceBundle().getString("AuditPlugin.5"), new Object[]{new Integer(aStmt.getObjectKind())}));
            }
        }
    }

    private void processStatements(AstMethod method, MethodDesc methodDesc, AstStatement[] stmts) {
        int i = 0;
        while (i < stmts.length) {
            this.processStatement(method, methodDesc, stmts[i]);
            ++i;
        }
    }

    private HashSet processExpression(AstMethod method, MethodDesc methodDesc, AstExpression expr) {
        int i;
        HashSet<AstVariable> uset = new HashSet<AstVariable>();
        switch (expr.getObjectKind()) {
            case 30: {
                AstArrayCreationExpression ex = (AstArrayCreationExpression)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkArrayCreationExpression(ex);
                    ++i;
                }
                break;
            }
            case 31: {
                AstArrayCreationExpression ex = (AstArrayReference)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkArrayReference((AstArrayReference)ex);
                    ++i;
                }
                break;
            }
            case 32: {
                AstArrayCreationExpression ex = (AstAssignmentExpression)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkAssignmentExpression((AstAssignmentExpression)ex);
                    ++i;
                }
                this.checkSideEffect(uset, ex.getLeftOperand());
                break;
            }
            case 33: {
                MethodDesc m;
                AstArrayCreationExpression ex = (AstBinaryExpression)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkBinaryExpression((AstBinaryExpression)ex);
                    ++i;
                }
                int cop = ex.getExpressionKind();
                final AstExpression left = ex.getLeftOperand();
                AstExpression right = ex.getRightOperand();
                if (!(Audit.isBitOp((AstExpression)ex) && (Audit.isCmpOp(left) || Audit.isCmpOp(right) || Audit.isShiftOp(left) || Audit.isShiftOp(right) || Audit.isBitOp(left) && ((AstBinaryExpression)left).getExpressionKind() != cop || Audit.isBitOp(right) && ((AstBinaryExpression)right).getExpressionKind() != cop) || Util.isLogicalOp((AstExpression)ex) && (Audit.isBitOp(left) || Audit.isBitOp(right)) || Audit.isShiftOp((AstExpression)ex) && (Audit.isArithmeticOp(left) || Audit.isArithmeticOp(right))) && (!Audit.isArithmeticOp((AstExpression)ex) || !Audit.isShiftOp(left) && !Audit.isShiftOp(right) && !Audit.isBitOp(left) && !Audit.isBitOp(right)) || (m = Audit.message(3, (AstObject)expr)) == null) break;
                m.addAutoFix(new ASTAutoFix((AstBinaryExpression)ex, right, "AuditMWAOP.Autofix"){
                    private final /* synthetic */ AstBinaryExpression val$ex;
                    private final /* synthetic */ AstExpression val$right;
                    {
                        this.val$ex = val$ex;
                        this.val$right = val$right;
                    }

                    public boolean fix() {
                        AstObjectFactory factory = Factory.getObjectFactory();
                        if (left instanceof AstBinaryExpression) {
                            left.replaceWith((AstObject)factory.createAstParenthesizedExpression(left), (AstObject)this.val$ex);
                        }
                        if (this.val$right instanceof AstBinaryExpression) {
                            this.val$right.replaceWith((AstObject)factory.createAstParenthesizedExpression(this.val$right), (AstObject)this.val$ex);
                        }
                        return true;
                    }
                });
                ESAutoFix fix = new ESAutoFix((IAuditMessage)m, AuditRule.getAutoFixName((IAuditMessage)m));
                fix.setTabSize(this.project.getTabSize());
                if (left instanceof AstBinaryExpression) {
                    fix.insert(left.getPosition(), "(");
                    fix.insertAfter(left.getPosition(), ")");
                }
                if (!(right instanceof AstBinaryExpression)) break;
                fix.insert(right.getPosition(), "(");
                fix.insertAfter(right.getPosition(), ")");
                break;
            }
            case 34: {
                AstArrayCreationExpression ex = (AstCastExpression)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkCastExpression((AstCastExpression)ex);
                    ++i;
                }
                break;
            }
            case 35: {
                AstArrayCreationExpression ex = (AstConditionalExpression)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkConditionalExpression((AstConditionalExpression)ex);
                    ++i;
                }
                break;
            }
            case 36: {
                AstArrayCreationExpression ex = (AstFieldReference)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkFieldReference((AstFieldReference)ex);
                    ++i;
                }
                if (methodDesc != null && ex.getFieldKind() == 1) {
                    this.accessField(methodDesc, (AstReference)ex);
                }
                if (ex.getBaseExpression().getObjectKind() != 42 && ex.getBaseExpression().getObjectKind() != 41) break;
                this.referenceField((AstReference)ex);
                break;
            }
            case 37: {
                AstArrayCreationExpression ex = (AstLiteral)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkLiteral((AstLiteral)ex);
                    ++i;
                }
                break;
            }
            case 38: {
                AstMethod calledMethod;
                AstArrayCreationExpression ex = (AstMethodCallExpression)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkMethodCallExpression((AstMethodCallExpression)ex);
                    ++i;
                }
                AstExpression methodExpr = ((AstMethodCallExpression)expr).getMethodExpression();
                if (methodExpr.getObjectKind() == 36 && ((AstFieldReference)methodExpr).getBaseExpression().getObjectKind() == 41 && ((AstFieldReference)methodExpr).getIdentifier().equals("finalize")) {
                    this.superFinalize = true;
                    this.superFinalizeLine = methodExpr.getPosition().getStartLine();
                    this.superFinalizeColumn = methodExpr.getPosition().getStartColumn();
                }
                if (method == null || (calledMethod = (AstMethod)ex.getReferencedElement()) == null) break;
                AstType calledClass = calledMethod.getDeclaringType();
                String calledName = calledMethod.getElementName();
                if (calledClass.getQualifiedName().equals("java/lang/Object")) {
                    if ((method.getModifiers() & 0x20) == 0 && this.monitors.empty() && (calledName.equals("notify") || calledName.equals("notifyAll") || calledName.equals("wait"))) {
                        Audit.message(11, (AstObject)expr, "AuditPlugin.9", new Object[]{calledMethod});
                    }
                    if (calledName.equals("wait")) {
                        methodDesc.attr |= 0x10000;
                    }
                } else if (calledClass.getQualifiedName().equals("java/lang/Thread") && calledName.equals("yield")) {
                    Audit.message(12, (AstObject)expr, "AuditPlugin.10", null);
                }
                ClassDesc cls = Audit.getClass(calledClass);
                MethodDesc m = cls.getMethod(calledMethod);
                int callAttr = 0;
                if (!calledMethod.isStatic() && calledClass == this.currentClass.cls) {
                    callAttr |= 1;
                }
                if (!this.monitors.empty()) {
                    callAttr |= 2;
                }
                if (methodExpr instanceof AstFieldReference && ((AstFieldReference)methodExpr).getBaseExpression().getObjectKind() == 41) {
                    callAttr |= 8;
                }
                methodDesc.addCallee(m, callAttr, (AstExpression)ex, this.monitors);
                break;
            }
            case 39: {
                AstMethod calledConstructor;
                AstArrayCreationExpression ex = (AstObjectCreationExpression)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkObjectCreationExpression((AstObjectCreationExpression)ex);
                    ++i;
                }
                if (ex.getClassBody() != null) {
                    this.processClass(ex.getClassBody());
                }
                if ((calledConstructor = (AstMethod)ex.getReferencedElement()) == null || methodDesc == null) break;
                AstType createdClass = calledConstructor.getDeclaringType();
                ClassDesc cls = Audit.getClass(createdClass);
                MethodDesc m = cls.getMethod(calledConstructor);
                methodDesc.addCallee(m, 9, (AstExpression)ex, this.monitors);
                break;
            }
            case 46: {
                AstArrayCreationExpression ex = (AstParenthesizedExpression)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkParenthesizedExpression((AstParenthesizedExpression)ex);
                    ++i;
                }
                break;
            }
            case 40: {
                AstArrayCreationExpression ex = (AstSimpleReference)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkSimpleReference((AstSimpleReference)ex);
                    ++i;
                }
                if (methodDesc == null) break;
                this.accessField(methodDesc, (AstReference)ex);
                break;
            }
            case 41: {
                AstArrayCreationExpression ex = (AstSuperExpression)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkSuperExpression((AstSuperExpression)ex);
                    ++i;
                }
                break;
            }
            case 42: {
                AstArrayCreationExpression ex = (AstThisExpression)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkThisExpression((AstThisExpression)ex);
                    ++i;
                }
                break;
            }
            case 43: {
                AstArrayCreationExpression ex = (AstUnaryExpression)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkUnaryExpression((AstUnaryExpression)ex);
                    ++i;
                }
                int cop = ex.getExpressionKind();
                if (cop != 4 && cop != 5 && cop != 6 && cop != 7) break;
                this.checkSideEffect(uset, ex.getOperand());
                break;
            }
            case 44: {
                AstArrayCreationExpression ex = (AstArrayInitializer)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkArrayInitializer((AstArrayInitializer)ex);
                    ++i;
                }
                break;
            }
            case 45: {
                AstArrayCreationExpression ex = (AstTypeExpression)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkTypeExpression((AstTypeExpression)ex);
                    ++i;
                }
                break;
            }
            case 29: {
                AstArrayCreationExpression ex = (AstConstructorInvocation)expr;
                i = 0;
                while (i < this.rules[2].length) {
                    this.rules[2][i].checkConstructorInvocation((AstConstructorInvocation)ex);
                    ++i;
                }
                AstMethod calledConstructor = (AstMethod)ex.getReferencedElement();
                if (calledConstructor == null || methodDesc == null) break;
                AstType createdClass = calledConstructor.getDeclaringType();
                ClassDesc cls = Audit.getClass(createdClass);
                MethodDesc m = cls.getMethod(calledConstructor);
                methodDesc.addCallee(m, 9, (AstExpression)ex, this.monitors);
                break;
            }
            default: {
                this.projectLog.log((IMessage)new Message(1, Audit.getResourceBundle().getString("AuditPlugin.6"), new Object[]{new Integer(expr.getObjectKind())}));
            }
        }
        AstExpression[] opnds = expr.getOperands();
        i = 0;
        while (i < opnds.length) {
            HashSet s = this.processExpression(method, methodDesc, opnds[i]);
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                AstVariable v = (AstVariable)iter.next();
                if (uset.add(v)) continue;
                Audit.message(2, (AstObject)expr);
            }
            ++i;
        }
        return uset;
    }

    private void checkSideEffect(HashSet uset, AstExpression expr) {
        AstDeclaration ref = null;
        if (expr.getObjectKind() == 40) {
            ref = ((AstSimpleReference)expr).getReferencedElement();
        } else if (expr.getObjectKind() == 36) {
            AstExpression base = ((AstFieldReference)expr).getBaseExpression();
            int kind = base.getObjectKind();
            if (kind == 41 || kind == 42 || kind == 36 && (((AstFieldReference)base).getFieldKind() == 3 || ((AstFieldReference)base).getFieldKind() == 4)) {
                ref = ((AstFieldReference)expr).getReferencedElement();
            } else {
                AstDeclaration r = ((AstFieldReference)expr).getReferencedElement();
                if (r != null && (r.getModifiers() & 8) != 0) {
                    ref = r;
                }
            }
        }
        if (ref != null && ref.getObjectKind() == 9) {
            uset.add(ref);
        }
    }

    private void referenceField(AstReference ref) {
        ShadowedField f;
        AstDeclaration decl = ref.getReferencedElement();
        if (decl != null && this.shadowedFields != null && decl.getObjectKind() == 9 && (f = (ShadowedField)this.shadowedFields.get(decl.getElementName())) != null && f.field == decl) {
            f.referenced = true;
        }
    }

    private void accessField(MethodDesc methodDesc, AstReference ref) {
        AstObject varDecl;
        AstDeclaration decl = ref.getReferencedElement();
        if (decl != null && decl.getObjectKind() == 9 && (varDecl = decl.getParent()) != null && varDecl.getObjectKind() == 50 && !decl.isFinal()) {
            AstObject parent;
            AstVariable field = (AstVariable)decl;
            AstType fieldClass = field.getDeclaringType();
            ClassDesc objClsDesc = Audit.getClass(fieldClass);
            FieldDesc fieldDesc = objClsDesc.getField(field);
            int accAttr = 0;
            if (fieldClass == this.currentClass.cls) {
                accAttr |= 1;
                if (methodDesc.isConstructor()) {
                    return;
                }
            }
            if ((parent = ref.getParent()) instanceof AstAssignmentExpression && ((AstAssignmentExpression)parent).getLeftOperand() == ref) {
                accAttr |= 2;
            }
            fieldDesc.addAccessor(methodDesc, this.monitors, accAttr, (AstObject)ref);
        }
    }

    private void processCondition(AstExpression expr) {
        if (expr != null && expr.getObjectKind() == 32 && ((AstAssignmentExpression)expr).getExpressionKind() == 0) {
            Audit.message(4, (AstObject)expr);
        }
    }

    private static boolean isBitOp(AstExpression expr) {
        if (expr.getObjectKind() != 33) {
            return false;
        }
        int kind = ((AstBinaryExpression)expr).getExpressionKind();
        return kind == 12 || kind == 13 || kind == 14;
    }

    private static boolean isShiftOp(AstExpression expr) {
        if (expr.getObjectKind() != 33) {
            return false;
        }
        int kind = ((AstBinaryExpression)expr).getExpressionKind();
        return kind == 7 || kind == 6 || kind == 8;
    }

    private static boolean isCmpOp(AstExpression expr) {
        if (expr.getObjectKind() != 33) {
            return false;
        }
        int kind = ((AstBinaryExpression)expr).getExpressionKind();
        return kind == 10 || kind == 11 || kind == 17 || kind == 18 || kind == 19 || kind == 20;
    }

    private static boolean isArithmeticOp(AstExpression expr) {
        if (expr.getObjectKind() != 33) {
            return false;
        }
        int kind = ((AstBinaryExpression)expr).getExpressionKind();
        return kind == 1 || kind == 2 || kind == 3 || kind == 4 || kind == 5;
    }

    private void checkFields() {
        Field f = this.analyzer.fieldList();
        while (f != null) {
            AstSourcePosition pos = f.getAstObject().getPosition();
            if (pos != null && !pos.getFileName().equals("")) {
                AstField field = (AstField)f.getAstObject();
                int i = 0;
                while (i < this.rules[8].length) {
                    this.rules[8][i].checkField((IField)f, field);
                    ++i;
                }
            }
            f = f.getNext();
        }
    }

    private void checkMethods() {
        Method m = this.analyzer.methodList();
        while (m != null) {
            AstMethod ast = (AstMethod)m.getAstObject();
            if (ast.getDeclaringType() != null && !ast.getDeclaringType().isBinary() && ast.getDeclaringType().isSource()) {
                int i = 0;
                while (i < this.rules[8].length) {
                    this.rules[8][i].checkMethod((IMethod)m, ast);
                    ++i;
                }
            }
            m = m.getNext();
        }
    }

    private void lifetimeAnalysis(DataFlowGraph fg) {
        TupleSet[][] webs = fg.getWebs();
        int i = 0;
        while (i < this.rules[8].length) {
            this.rules[8][i].checkLifetime((ITupleSet[][])webs);
            ++i;
        }
    }

    private void checkSync() {
        ClassDesc cls = classes;
        while (cls != null) {
            cls.calculateAttributes();
            cls = cls.next;
        }
        cls = classes;
        while (cls != null) {
            cls.verify();
            cls = cls.next;
        }
        cls = classes;
        while (cls != null) {
            cls.addOverriddenMethodInvocations();
            cls = cls.next;
        }
        ClassDesc.buildConcurrentClosure();
        GraphVertex.verify();
        cls = classes;
        while (cls != null) {
            if (cls.cls.isSource()) {
                cls.checkRaceConditions();
                cls.findWaitsWithLockedMonitors();
            }
            cls = cls.next;
        }
    }

    public static ClassDesc getClass(AstType key) {
        ClassDesc cls = classes;
        while (cls != null) {
            if (cls.cls == key) {
                return cls;
            }
            cls = cls.next;
        }
        classes = new ClassDesc(classes, key);
        return classes;
    }

    public static MethodDesc getMethod(AstMethod key) {
        ClassDesc cls = Audit.getClass(key.getDeclaringType());
        return cls.getMethod(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ruleNames = new String[]{"CSF", "HN", "OHSSE", "MWAOP", "ACE", "LMCCD", "MWIML", "SMONSM", "FARC", "FANL", "FAIL", "NMCNSM", "AUY"};
        metricParams = new String[]{"PackageLowerLimit", "ClassLowerLimit", "MethodLowerLimit", "PackageUpperLimit", "ClassUpperLimit", "MethodUpperLimit"};
        resourceBundle = ResourceBundle.getBundle("com.togethersoft.sca.internal.plugin.audit.AuditPluginMessages");
        myClassLoader = (class$com$togethersoft$sca$internal$plugin$audit$Audit == null ? (class$com$togethersoft$sca$internal$plugin$audit$Audit = Audit.class$("com.togethersoft.sca.internal.plugin.audit.Audit")) : class$com$togethersoft$sca$internal$plugin$audit$Audit).getClassLoader();
        templateManager = new TemplateManager((ITemplateFormatter)new AuditTemplateFormatter());
        reportAllLoops = false;
        allPublicReentrant = false;
        overrideAlienMethods = false;
    }

    private class ShadowedField {
        AstVariable field;
        AstVariable local;
        boolean referenced;

        ShadowedField(AstVariable field, AstVariable local) {
            this.field = field;
            this.local = local;
            this.referenced = false;
        }
    }
}

