/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.jsse.net;

import iaik.security.jsse.net.JSSESessionManager;
import iaik.security.jsse.net.SSLSessionWrapper;
import iaik.security.jsse.utils.Debug;
import iaik.security.jsse.utils.Util;
import iaik.security.ssl.CipherSuite;
import iaik.security.ssl.CipherSuiteList;
import iaik.security.ssl.SSLContext;
import iaik.security.ssl.SSLServerContext;
import iaik.security.ssl.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class IAIKSSLSocketWrapper
extends SSLSocket {
    private SSLSessionWrapper a = null;
    private SSLContext d;
    private boolean i = true;
    private boolean f = false;
    private boolean e = true;
    private Vector b = new Vector();
    private boolean h = true;
    private iaik.security.ssl.SSLSocket c;
    private static Debug g = Debug.getInstance();

    public String toString() {
        return this.c.toString();
    }

    public void startHandshake() throws IOException {
        JSSESessionManager jSSESessionManager;
        Session session;
        if (!this.e && (session = (jSSESessionManager = (JSSESessionManager)this.d.getSessionManager()).getSession(this.c.getTransport(), null)) == null) {
            throw new RuntimeException("session creation not allowed and no valid session cached");
        }
        if (this.f) {
            g.println("\n **** SocketWrapper RENEGOTIATE ****");
            this.c.renegotiate();
            this.i = true;
            g.println("\n **** SocketWrapper\n **** Current session of encapsulated SSLSocket:\n **** " + this.c.getSession().getID() + "\n");
            if (this.c.getSession().isValid()) {
                g.println(" **** SocketWrapper \n **** Session of encapsulated Socket is valid");
            } else {
                g.println(" **** SocketWrapper \n **** Session of encapsulated Socket NOT valid");
            }
        } else {
            g.println("\n **** SocketWrapper START HANDSHAKE ****");
            this.c.startHandshake();
            this.f = true;
        }
        this.a();
    }

    public void setWantClientAuth(boolean bl) {
        if (this.c.getUseClientMode()) {
            throw new IllegalArgumentException("Not a serverside socket");
        }
        ((SSLServerContext)this.d).setRequestClientCertificate(bl);
        if (bl) {
            this.d.addTrustedCertificate(null);
        }
    }

    public void setUseClientMode(boolean bl) throws IllegalArgumentException {
        try {
            this.c.setUseClientMode(bl);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.toString());
        }
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.c.setTcpNoDelay(bl);
    }

    public static void setSocketImplFactory(SocketImplFactory socketImplFactory) throws IOException {
        Socket.setSocketImplFactory(socketImplFactory);
    }

    public void setSoTimeout(int n) throws SocketException {
        this.c.setSoTimeout(n);
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.c.setSoLinger(bl, n);
    }

    public void setSendBufferSize(int n) throws SocketException {
        throw new RuntimeException("sorry method not implemented (to be compatible with jdk1.1.x");
    }

    void a(SSLContext sSLContext) {
        this.d = sSLContext;
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        throw new RuntimeException("sorry method not implemented (to be compatible with jdk1.1.x");
    }

    public void setNeedClientAuth(boolean bl) {
        if (this.c.getUseClientMode()) {
            throw new IllegalArgumentException("Not a server side socket");
        }
        ((SSLServerContext)this.d).setRequestClientCertificate(bl);
        if (bl) {
            this.d.getChainVerifier().removeTrustedCertificate(null);
        }
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.d.setEnabledCipherSuiteList(Util.fromStringArray(stringArray));
        this.d.updateCipherSuites();
    }

    public void setEnableSessionCreation(boolean bl) {
        this.e = bl;
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        while (this.b.removeElement(handshakeCompletedListener)) {
        }
    }

    private void a() {
        g.println("jsse_debug: SocketWrapper: Notifying Listeners");
        HandshakeCompletedEvent handshakeCompletedEvent = new HandshakeCompletedEvent(this, this.getSession());
        int n = 0;
        while (n < this.b.size()) {
            HandshakeCompletedListener handshakeCompletedListener = (HandshakeCompletedListener)this.b.elementAt(n);
            handshakeCompletedListener.handshakeCompleted(handshakeCompletedEvent);
            ++n;
        }
    }

    public void init(Socket socket, SSLContext sSLContext, boolean bl) throws IOException {
        this.c.init(socket, sSLContext, bl);
        if (g.getDebugMode() == 0) {
            this.c.setDebugStream((OutputStream)g.getDebugStream());
        }
    }

    public boolean getWantClientAuth() {
        if (this.c.getUseClientMode()) {
            throw new IllegalArgumentException("Not a serverside socket");
        }
        return ((SSLServerContext)this.d).getRequestClientCertificate();
    }

    public boolean getUseClientMode() {
        return this.c.getUseClientMode();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.c.getTcpNoDelay();
    }

    public String[] getSupportedCipherSuites() {
        CipherSuiteList cipherSuiteList = new CipherSuiteList(3);
        String[] stringArray = new String[cipherSuiteList.size()];
        int n = 0;
        while (n < cipherSuiteList.size()) {
            stringArray[n] = cipherSuiteList.elementAt(n).getName();
            ++n;
        }
        return stringArray;
    }

    public int getSoTimeout() throws SocketException {
        return this.c.getSoTimeout();
    }

    public int getSoLinger() throws SocketException {
        return this.c.getSoLinger();
    }

    public SSLSession getSession() {
        if (!this.f) {
            try {
                this.startHandshake();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (this.i || !this.a.equals(this.c.getSession())) {
            this.a = new SSLSessionWrapper(this.c.getSession(), (JSSESessionManager)this.d.getSessionManager(), this.c.getTransport().getRemoteInetAddress());
            this.i = false;
        }
        return this.a;
    }

    public int getSendBufferSize() throws SocketException {
        throw new RuntimeException("sorry method not implemented (to be compatible with jdk1.1.x");
    }

    public int getReceiveBufferSize() throws SocketException {
        throw new RuntimeException("sorry method not implemented (to be compatible with jdk1.1.x");
    }

    public int getPort() {
        return this.c.getPort();
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.f) {
            this.startHandshake();
        }
        OutputStream outputStream = this.c.getOutputStream();
        return outputStream;
    }

    public boolean getNeedClientAuth() {
        if (!this.c.getUseClientMode()) {
            try {
                return ((SSLServerContext)this.d).getRequestClientCertificate();
            }
            catch (Exception exception) {
                g.println(exception);
            }
        }
        throw new RuntimeException("Not a server side socket");
    }

    public int getLocalPort() {
        return this.c.getLocalPort();
    }

    public InetAddress getLocalAddress() {
        return this.c.getLocalAddress();
    }

    public InputStream getInputStream() throws IOException {
        if (!this.f) {
            this.startHandshake();
        }
        InputStream inputStream = this.c.getInputStream();
        return inputStream;
    }

    public InetAddress getInetAddress() {
        return this.c.getInetAddress();
    }

    public String[] getEnabledCipherSuites() {
        CipherSuite[] cipherSuiteArray = this.d.getEnabledCipherSuiteList().toArray();
        String[] stringArray = new String[cipherSuiteArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = cipherSuiteArray[n].toString();
            ++n;
        }
        return stringArray;
    }

    public boolean getEnableSessionCreation() {
        return this.e;
    }

    public void close() throws IOException {
        if (this.h) {
            this.c.close();
        } else {
            this.c.shutdown();
        }
        this.f = false;
        this.i = true;
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.b.addElement(handshakeCompletedListener);
    }

    protected IAIKSSLSocketWrapper(Socket socket, String string, int n, boolean bl, SSLContext sSLContext) throws IOException {
        this.h = bl;
        this.c = new iaik.security.ssl.SSLSocket(socket, sSLContext, string, n);
        if (g.getDebugMode() == 0) {
            this.c.setDebugStream((OutputStream)g.getDebugStream());
        }
        this.d = sSLContext;
    }

    IAIKSSLSocketWrapper(Socket socket, SSLContext sSLContext) throws IOException {
        this.c = new iaik.security.ssl.SSLSocket(socket, sSLContext);
        if (g.getDebugMode() == 0) {
            this.c.setDebugStream((OutputStream)g.getDebugStream());
        }
        this.d = sSLContext;
    }

    protected IAIKSSLSocketWrapper(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, SSLContext sSLContext) throws UnknownHostException, IOException {
        this.c = new iaik.security.ssl.SSLSocket(inetAddress, n, inetAddress2, n2, sSLContext);
        if (g.getDebugMode() == 0) {
            this.c.setDebugStream((OutputStream)g.getDebugStream());
        }
        this.d = sSLContext;
    }

    protected IAIKSSLSocketWrapper(InetAddress inetAddress, int n, SSLContext sSLContext) throws IOException {
        this.c = new iaik.security.ssl.SSLSocket(inetAddress, n, sSLContext);
        if (g.getDebugMode() == 0) {
            this.c.setDebugStream((OutputStream)g.getDebugStream());
        }
        this.d = sSLContext;
    }

    protected IAIKSSLSocketWrapper(String string, int n, InetAddress inetAddress, int n2, SSLContext sSLContext) throws IOException {
        this.c = new iaik.security.ssl.SSLSocket(string, n, inetAddress, n2, sSLContext);
        if (g.getDebugMode() == 0) {
            this.c.setDebugStream((OutputStream)g.getDebugStream());
        }
        this.d = sSLContext;
    }

    protected IAIKSSLSocketWrapper(String string, int n, SSLContext sSLContext) throws IOException {
        this.c = new iaik.security.ssl.SSLSocket(string, n, sSLContext);
        if (g.getDebugMode() == 0) {
            this.c.setDebugStream((OutputStream)g.getDebugStream());
        }
        this.d = sSLContext;
    }
}

