/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.admin.ui.dnd;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.admin.ui.dnd.IntegrateCommandDialog;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.dnd.commands.VFSDNDCommand;
import com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsIntegrationMode;
import java.util.Arrays;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Shell;

public class VFSInregrateToWorkspaceCommand
extends VFSDNDCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$admin$ui$dnd$VFSInregrateToWorkspaceCommand == null ? (class$com$tssap$dtr$client$eclipse$admin$ui$dnd$VFSInregrateToWorkspaceCommand = VFSInregrateToWorkspaceCommand.class$("com.tssap.dtr.client.eclipse.admin.ui.dnd.VFSInregrateToWorkspaceCommand")) : class$com$tssap$dtr$client$eclipse$admin$ui$dnd$VFSInregrateToWorkspaceCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$admin$ui$dnd$VFSInregrateToWorkspaceCommand;

    public VFSInregrateToWorkspaceCommand() {
        super(class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace = VFSInregrateToWorkspaceCommand.class$("com.tssap.dtr.client.lib.vfs.IVfsWorkspace")) : class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace);
    }

    protected void performAction(Object[] elements, Object destination) {
        IntegrateCommandDialog dialog = new IntegrateCommandDialog(this.getShell(), Arrays.asList(elements), (IVfsWorkspace)destination);
        if (dialog.open() == 0) {
            VfsIntegrationMode mode = dialog.getIntegrationMode();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof ClosedActivityWrapper) {
                    IVfsActivity activity = ((ClosedActivityWrapper)elements[i]).activity;
                    try {
                        activity.integrate((IVfsWorkspace)destination, mode);
                    }
                    catch (VfsException e) {
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                        try {
                            MessageDialog.openError((Shell)this.getShell(), (String)"Integration failed", (String)(activity.getDisplayName() + "\n\n\t" + e.getMessage()));
                        }
                        catch (VfsException e1) {
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e1);
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected boolean checkSourceElements(Object[] elements, Object destination) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof ClosedActivityWrapper) {
                IVfsActivity activity = ((ClosedActivityWrapper)elements[i]).activity;
                try {
                    if (!(activity.isInvalid() || activity.isOpen() || activity.getWorkspace().equals(destination))) {
                        return true;
                    }
                }
                catch (VfsException e) {
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
            }
            ++i;
        }
        return false;
    }

    protected String getErrorMessage() {
        return "Following activities couldn't be integrated into destination workspace:";
    }

    public void setDNDResponse(DropTargetEvent event) {
        event.detail = 4;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

