/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.admin.ui.actions;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspaceFolder;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class CreateFolderAction
extends VfsObjectSelectionAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$admin$ui$actions$CreateFolderAction == null ? (class$com$tssap$dtr$client$eclipse$admin$ui$actions$CreateFolderAction = CreateFolderAction.class$("com.tssap.dtr.client.eclipse.admin.ui.actions.CreateFolderAction")) : class$com$tssap$dtr$client$eclipse$admin$ui$actions$CreateFolderAction));
    private static final String DIALOG_TITLE_ATTRIBUTE = "dialogTitle";
    private static final String DIALOG_MESSAGE_ATTRIBUTE = "dialogMessage";
    private static final String DEFAULT_DIALOG_TITLE = "New Folder";
    private static final String DEFAULT_DIALOG_MESSAGE = "Please type in folder name";
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$admin$ui$actions$CreateFolderAction;

    protected boolean isEnabled(IStructuredSelection selection) {
        return selection.getFirstElement() instanceof IVfsWorkspace || selection.getFirstElement() instanceof IVfsWorkspaceFolder;
    }

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        String dialogTitle = this.getConfigProperty(DIALOG_TITLE_ATTRIBUTE, DEFAULT_DIALOG_TITLE);
        String dialogMessage = this.getConfigProperty(DIALOG_MESSAGE_ATTRIBUTE, DEFAULT_DIALOG_MESSAGE);
        InputDialog inputDialog = new InputDialog(this.getShell(), dialogTitle, dialogMessage, "", null);
        if (0 == inputDialog.open()) {
            String folderName = inputDialog.getValue();
            if (selection.getFirstElement() instanceof IVfsWorkspaceFolder) {
                try {
                    ((IVfsWorkspaceFolder)selection.getFirstElement()).createSubfolder(folderName);
                }
                catch (VfsException x) {
                    this.showErrorMessage(x.getMessage());
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                }
            } else if (selection.getFirstElement() instanceof IVfsWorkspace) {
                ((IVfsWorkspace)selection.getFirstElement()).createSubFolder(folderName);
            }
        }
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

