/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.admin.ui;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsImmutablePropertySupport;
import com.tssap.dtr.client.lib.vfs.IVfsProperty;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.impl.PropertiesFeature;
import com.tssap.dtr.client.lib.vfs.impl.VfsProperty;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class PropertyViewer {
    private boolean _useVcrInCase;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$admin$ui$PropertyViewer == null ? (class$com$tssap$dtr$client$eclipse$admin$ui$PropertyViewer = PropertyViewer.class$("com.tssap.dtr.client.eclipse.admin.ui.PropertyViewer")) : class$com$tssap$dtr$client$eclipse$admin$ui$PropertyViewer));
    private IVfsContext _context;
    private int _connectionTemplateId;
    private String _resourceUrl;
    private Composite _parent;
    private TableTreeViewer _viewer;
    private IVfsImmutablePropertySupport myItem;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$admin$ui$PropertyViewer;

    public PropertyViewer(IVfsImmutablePropertySupport item, boolean useVcrInCase, IVfsContext context, int connectionTemplateId) {
        this.myItem = item;
        this._useVcrInCase = useVcrInCase;
        this._context = context;
        this._connectionTemplateId = connectionTemplateId;
    }

    private void setTitle() {
        Shell shell = this._parent.getShell();
        if (shell != null && this._resourceUrl != null) {
            shell.setText(this._resourceUrl);
        }
    }

    public Composite createContents(Composite parent) {
        this._parent = parent;
        Composite grid = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        grid.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 600;
        grid.setLayoutData((Object)gridData);
        try {
            this._resourceUrl = this.myItem.getUrl();
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
        }
        IVfsRemoteLocator serverLocator = null;
        if (this._context != null && this._resourceUrl != null) {
            IVfsRemoteLocator[] rootLocators = this._context.getRootRemoteLocators();
            int i = 0;
            while (i < rootLocators.length) {
                IVfsRemoteLocator rootLocator = rootLocators[i];
                if (rootLocator.getConnectionTemplateId() == this._connectionTemplateId) {
                    serverLocator = rootLocator;
                    break;
                }
                ++i;
            }
        }
        final String serverUrl = this._context.getUrl(serverLocator);
        final String webLocator = this._context.getWebLocator(this._connectionTemplateId);
        if (serverUrl != null && webLocator != null) {
            Composite navigationBar = new Composite(grid, 0);
            gridLayout = new GridLayout(3, false);
            gridLayout.marginWidth = 2;
            navigationBar.setLayout((Layout)gridLayout);
            navigationBar.setLayoutData((Object)new GridData(768));
            Label label = new Label(navigationBar, 0);
            label.setText(serverUrl);
            final Text text = new Text(navigationBar, 2052);
            String resourceRelativePath = this._resourceUrl.substring(serverUrl.length());
            text.setText(resourceRelativePath);
            text.setLayoutData((Object)new GridData(768));
            Button button = new Button(navigationBar, 0);
            button.setText(IDialogConstants.OK_LABEL);
            button.setFocus();
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            int heightHint = LayoutHelper.getControlHeigthHint((Control)text) - 3;
            GridData buttonGridData = new GridData(128);
            buttonGridData.heightHint = heightHint;
            button.setLayoutData((Object)buttonGridData);
            button.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                }

                public void widgetSelected(SelectionEvent event) {
                    IResourceFactory factory = ResourceFactoryManager.getInstance().getProxyFactory();
                    IResource resource = null;
                    try {
                        PropertyViewer.this._resourceUrl = serverUrl + text.getText().trim();
                        String absoluteRemotePath = PropertyViewer.this._resourceUrl.substring(webLocator.length());
                        resource = factory.createResource(PropertyViewer.this._connectionTemplateId, absoluteRemotePath, PathEncodingFlag.DECODED);
                    }
                    catch (VcmFailure vcmFailure) {
                        Logbook.getErrorChapter().println(vcmFailure.getMessage());
                        LogUtil.logException((Location)LOCATION, (Throwable)vcmFailure);
                    }
                    PropertyViewer.this._viewer.setInput(resource);
                    PropertyViewer.this.setTitle();
                }
            });
        }
        Composite tableArea = new Composite(grid, 0);
        tableArea.setLayout((Layout)new FillLayout());
        tableArea.setLayoutData((Object)new GridData(1808));
        this._viewer = new TableTreeViewer(tableArea, 68354);
        TableLayout layout = new TableLayout();
        final Table table = this._viewer.getTableTree().getTable();
        table.setLayout((Layout)layout);
        TableColumn column = new TableColumn(table, 0);
        column.setText("Property");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, 10));
        column = new TableColumn(table, 0);
        column.setText("Value");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, 120));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this._viewer.setContentProvider((IContentProvider)new PropertyContentProvider());
        this._viewer.setLabelProvider((IBaseLabelProvider)new PropertyLabelProvider());
        this._viewer.setInput((Object)this.myItem);
        this.setTitle();
        this._viewer.getTableTree().getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.stateMask == 262144 && event.character == '\u0001') {
                    table.selectAll();
                }
                if (event.stateMask == 262144 && event.character == '\u0003') {
                    PropertyViewer.this.copySelectionToClipboard();
                }
            }
        });
        MenuManager contextMenuManager = new MenuManager();
        Menu menu = contextMenuManager.createContextMenu((Control)table);
        table.setMenu(menu);
        contextMenuManager.add((IAction)new Action(){

            public String getText() {
                return "Copy";
            }

            public ImageDescriptor getImageDescriptor() {
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                if (sharedImages != null) {
                    return sharedImages.getImageDescriptor("IMG_TOOL_COPY_HOVER");
                }
                return null;
            }

            public void run() {
                PropertyViewer.this.copySelectionToClipboard();
            }
        });
        return grid;
    }

    private void copySelectionToClipboard() {
        Clipboard clipboard = new Clipboard(Display.getDefault());
        TableTreeItem[] tableTreeItems = this._viewer.getTableTree().getSelection();
        StringBuffer buffer = new StringBuffer();
        String EOL = System.getProperty("line.separator");
        int i = 0;
        while (i < tableTreeItems.length) {
            TableTreeItem tableTreeItem;
            TableTreeItem parent = tableTreeItem = tableTreeItems[i];
            while ((parent = parent.getParentItem()) != null) {
                buffer.append("\t");
            }
            String name = tableTreeItem.getText(0);
            StringTokenizer tokenizer = new StringTokenizer(name, " ");
            while (tokenizer.hasMoreTokens()) {
                buffer.append(tokenizer.nextToken());
            }
            String value = tableTreeItem.getText(1);
            if (value.length() > 0) {
                buffer.append("=\"");
                buffer.append(value);
                buffer.append("\"");
            }
            buffer.append(EOL);
            ++i;
        }
        Object[] data = new Object[]{buffer.toString()};
        Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
        clipboard.setContents(data, transferTypes);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PropertyLabelProvider
    implements ITableLabelProvider {
        PropertyLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof IVfsProperty)) {
                return "?";
            }
            IVfsProperty property = (IVfsProperty)element;
            switch (columnIndex) {
                case 0: {
                    return property.getNamespace() + " : " + property.getName();
                }
                case 1: {
                    return property.getValue();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class PropertyContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private static final String DAV_HREF = "DAV:href";

        PropertyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IVfsActivityRecordedFolderItem) {
                IVfsActivityRecordedFolderItem folderItem = (IVfsActivityRecordedFolderItem)inputElement;
                try {
                    if (PropertyViewer.this._useVcrInCase) {
                        return new PropertiesFeature().getAllVcrProperties(folderItem);
                    }
                    return new PropertiesFeature().getAllVersionProperties(folderItem);
                }
                catch (VfsException e) {
                    Logbook.getErrorChapter().println(e.getMessage());
                    return new Object[0];
                }
            }
            if (inputElement instanceof IVfsImmutablePropertySupport) {
                try {
                    return ((IVfsImmutablePropertySupport)inputElement).getAllProperties();
                }
                catch (VfsException e) {
                    Logbook.getErrorChapter().println(e.getMessage());
                }
            }
            if (inputElement instanceof IResource) {
                try {
                    return new PropertiesFeature().getAllProperties((IResource)inputElement);
                }
                catch (VfsException e) {
                    Logbook.getErrorChapter().println(e.getMessage());
                    return new Object[0];
                }
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object o) {
            if (o instanceof IVfsProperty) {
                IVfsProperty property = (IVfsProperty)o;
                if (property.toString().equals(DAV_HREF) && property.getValue().trim().length() > 0 && property instanceof VfsProperty) {
                    try {
                        IResource thisResource = ((VfsProperty)property).getDvResource();
                        IResource targetResource = ResourceFactoryManager.getInstance().getProxyFactory().createResource(thisResource.getConnectionTemplID(), property.getValue().trim(), PathEncodingFlag.ENCODED);
                        String[] propertyNames = targetResource.getPropertyNames();
                        Map map = VfsProperty.getProperties((IResource)targetResource, (String[])propertyNames);
                        Iterator iterator = map.values().iterator();
                        Object[] properties = new IVfsProperty[map.values().size()];
                        int i = 0;
                        while (i < properties.length) {
                            properties[i] = (IVfsProperty)iterator.next();
                            ++i;
                        }
                        return properties;
                    }
                    catch (VcmFailure vcmFailure) {
                        Logbook.getErrorChapter().println(vcmFailure.getMessage());
                    }
                    catch (VfsException e) {
                        Logbook.getErrorChapter().println(e.getMessage());
                    }
                }
                return property.getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object o) {
            return null;
        }

        public boolean hasChildren(Object o) {
            if (o instanceof IVfsProperty) {
                IVfsProperty property = (IVfsProperty)o;
                return property.hasChildren() || property.toString().equals(DAV_HREF);
            }
            return false;
        }
    }
}

