/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.admin.ui;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.admin.DTRAdminPlugin;
import com.tssap.dtr.client.eclipse.admin.ui.EditAceDialog;
import com.tssap.dtr.client.eclipse.internal.IIDELoginListener;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.acl.ACLException;
import com.tssap.dtr.client.lib.acl.ACLFactory;
import com.tssap.dtr.client.lib.acl.GrantTypes;
import com.tssap.dtr.client.lib.acl.IACE;
import com.tssap.dtr.client.lib.acl.IACL;
import com.tssap.dtr.client.lib.acl.IACLListener;
import com.tssap.dtr.client.lib.acl.IACLManager;
import com.tssap.dtr.client.lib.acl.IInheritanceAwareACLListener;
import com.tssap.dtr.client.lib.acl.PrivilegeTypes;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.um.IPrincipal;
import com.tssap.dtr.client.lib.um.IPrincipalManager;
import com.tssap.dtr.client.lib.um.PrincipalException;
import com.tssap.dtr.client.lib.um.PrincipalFactory;
import com.tssap.dtr.client.lib.um.PrincipalTypes;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsRepository;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.IConfigurationListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class PermissionViewer
extends Viewer
implements IInheritanceAwareACLListener,
IIDELoginListener,
IConfigurationListener {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$admin$ui$PermissionViewer == null ? (class$com$tssap$dtr$client$eclipse$admin$ui$PermissionViewer = PermissionViewer.class$("com.tssap.dtr.client.eclipse.admin.ui.PermissionViewer")) : class$com$tssap$dtr$client$eclipse$admin$ui$PermissionViewer));
    private static final String PREFIX = "com.tssap.dtr.client.eclipse.admin.ui.acl.";
    private static final String P_PRINCIPAL = "com.tssap.dtr.client.eclipse.admin.ui.acl.principal";
    private static final String P_PRINCIPAL_TYPE = "com.tssap.dtr.client.eclipse.admin.ui.acl.principalType";
    private static final String P_DESCRIPTION = "com.tssap.dtr.client.eclipse.admin.ui.acl.description";
    private static final String P_INHERITED = "com.tssap.dtr.client.eclipse.admin.ui.acl.inherited";
    private static final String P_GRANT_TYPE = "com.tssap.dtr.client.eclipse.admin.ui.acl.grantType";
    private static final String P_PRIVILEGE_ACCESS = "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeAccess";
    private static final String P_PRIVILEGE_READ = "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeRead";
    private static final String P_PRIVILEGE_WRITE = "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeWrite";
    private static final String P_PRIVILEGE_CHECKIN = "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeCheckin";
    private static final String P_PRIVILEGE_IMPORT = "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeImport";
    private static final String P_PRIVILEGE_EXPORT = "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeExport";
    private static final String P_PRIVILEGE_INTEGRATION = "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeIntegration";
    private static final String P_PRIVILEGE_ADMINA = "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeAdminA";
    private static final String P_PRIVILEGE_ADMINX = "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeAdminX";
    protected static final Image IMAGE_ACCESS = DTRAdminPlugin.getDefault().getAtomicImage("priv_access.gif");
    protected static final Image IMAGE_READ = DTRAdminPlugin.getDefault().getAtomicImage("priv_read.gif");
    protected static final Image IMAGE_WRITE = DTRAdminPlugin.getDefault().getAtomicImage("priv_write.gif");
    protected static final Image IMAGE_CHECKIN = DTRAdminPlugin.getDefault().getAtomicImage("priv_checkin.gif");
    protected static final Image IMAGE_IMPORT = DTRAdminPlugin.getDefault().getAtomicImage("priv_import.gif");
    protected static final Image IMAGE_EXPORT = DTRAdminPlugin.getDefault().getAtomicImage("priv_export.gif");
    protected static final Image IMAGE_INTEGRATE = DTRAdminPlugin.getDefault().getAtomicImage("priv_integrate.gif");
    protected static final Image IMAGE_ADMINA = DTRAdminPlugin.getDefault().getAtomicImage("priv_adminA.gif");
    protected static final Image IMAGE_ADMINX = DTRAdminPlugin.getDefault().getAtomicImage("priv_adminX.gif");
    private static final String[] COLUMN_HEADERS = new String[]{"Principal", "Principal Type", "Description", "Inherited from", "Grant Type", "", "", "", "", "", "", "", "", ""};
    private static final int[] COLUMN_STYLES = new int[]{0, 0, 0, 0, 0, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000};
    private static final ColumnLayoutData[] COLUMN_LAYOUTS = new ColumnLayoutData[]{new ColumnWeightData(80, 80, true), new ColumnWeightData(70, 70, true), new ColumnWeightData(100, 100, true), new ColumnWeightData(100, 100, true), new ColumnWeightData(70, 70, true), new ColumnPixelData(30, false), new ColumnPixelData(30, false), new ColumnPixelData(30, false), new ColumnPixelData(30, false), new ColumnPixelData(30, false), new ColumnPixelData(30, false), new ColumnPixelData(30, false), new ColumnPixelData(30, false), new ColumnPixelData(30, false)};
    private static String[] COLUMN_PROPERTIES = new String[]{"com.tssap.dtr.client.eclipse.admin.ui.acl.principal", "com.tssap.dtr.client.eclipse.admin.ui.acl.principalType", "com.tssap.dtr.client.eclipse.admin.ui.acl.description", "com.tssap.dtr.client.eclipse.admin.ui.acl.inherited", "com.tssap.dtr.client.eclipse.admin.ui.acl.grantType", "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeAccess", "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeRead", "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeWrite", "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeCheckin", "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeImport", "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeExport", "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeIntegration", "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeAdminA", "com.tssap.dtr.client.eclipse.admin.ui.acl.privilegeAdminX"};
    private boolean[] m_columnSorting = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private IACL m_acl = null;
    private IACL[] m_parentAcls;
    private IAction m_actCreateAce;
    private IAction m_actEditAce;
    private IAction m_actDeleteAce;
    private IAction m_actSaveAcl;
    private IAction m_actRevert;
    private IAction m_actDeleteAcl;
    private IAction m_actRefreshAcl;
    private IAction m_actIgnoreInheritance;
    private IAction m_actSetFinal;
    private IAction m_actActivateChanges;
    private IAction m_actGotoDefinitionAcl;
    private IAction m_actGotoTopFinalAcl;
    private IAction m_actGotoNextIgnoreAcl;
    private IAction m_actOpenAcl;
    private IAction m_actClearHistory;
    private Set m_visitedAcls = new HashSet();
    private Set m_inactiveAcls = new HashSet();
    private Set m_inputListeners = new HashSet();
    private TableViewer m_tableViewer;
    private TableEditor m_tableEditor;
    private boolean m_viewerDisposed;
    private boolean m_refreshEventFromRefreshAction;
    private IStatusLineManager m_statusLineManager;
    private Composite m_parent;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$admin$ui$PermissionViewer;

    public Composite createControl(Composite parent, int style) {
        this.m_parent = parent;
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new FillLayout());
        base.setLayoutData((Object)new GridData(1808));
        this.m_tableViewer = new TableViewer(base, style);
        TableLayout layout = new TableLayout();
        final Table table = this.m_tableViewer.getTable();
        table.setLayout((Layout)layout);
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int columnIndex = table.indexOf((TableColumn)e.widget);
                if (PermissionViewer.this.m_acl != null) {
                    PermissionViewer.this.m_tableViewer.setSorter((ViewerSorter)new AclTableViewerSorter(columnIndex, !PermissionViewer.this.m_columnSorting[columnIndex]));
                    boolean bl = ((PermissionViewer)PermissionViewer.this).m_columnSorting[columnIndex] = !PermissionViewer.this.m_columnSorting[columnIndex];
                }
                if (PermissionViewer.this.getStatusLineManager() != null) {
                    PermissionViewer.this.clearStatusBar();
                    if (columnIndex > 4) {
                        PermissionViewer.this.getStatusLineManager().setMessage(PermissionViewer.this.getCloumnExplanation(columnIndex));
                    }
                }
            }
        };
        int i = 0;
        while (i < COLUMN_HEADERS.length) {
            TableColumn column = new TableColumn(table, COLUMN_STYLES[i]);
            if (!"".equals(COLUMN_HEADERS[i])) {
                column.setText(COLUMN_HEADERS[i]);
            } else {
                column.setImage(this.getDefaultColumnIcon(i));
                column.pack();
            }
            column.setResizable(PermissionViewer.COLUMN_LAYOUTS[i].resizable);
            layout.addColumnData(COLUMN_LAYOUTS[i]);
            column.addSelectionListener((SelectionListener)headerListener);
            ++i;
        }
        this.createCellEditors(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.m_tableViewer.setContentProvider((IContentProvider)new AclContentProvider());
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)new AclLabelProvider());
        this.m_tableViewer.setSorter((ViewerSorter)new AclTableViewerSorter(0, true));
        this.m_tableViewer.setUseHashlookup(true);
        this.createActions();
        this.createContextMenus();
        this.addMouseListener();
        this.addKeyListener();
        this.registerAclListenerForCurrent(true, (IACLListener)this);
        if (VfsManagerProvider.getInstance().isSapIDELoginAvailable()) {
            VfsManagerProvider.getInstance().addIDELoginListener((IIDELoginListener)this);
        }
        Configuration.getConfiguration().addConfigurationListener((IConfigurationListener)this);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!PermissionViewer.this.m_inactiveAcls.isEmpty()) {
                    PermissionViewer.this.m_viewerDisposed = true;
                    String resourcePaths = "";
                    Iterator iter = PermissionViewer.this.m_inactiveAcls.iterator();
                    while (iter.hasNext()) {
                        resourcePaths = resourcePaths + "\n\t- " + ((IACL)iter.next()).getResourcePath();
                    }
                    boolean okPressed = MessageDialog.openConfirm((Shell)PermissionViewer.this.getShell(), (String)"Inactive Changes", (String)("You have still inactive changes on permissions for resource(s):" + resourcePaths + "\n\nPress " + IDialogConstants.OK_LABEL.toUpperCase() + " to activate all changes,\npress " + IDialogConstants.CANCEL_LABEL.toUpperCase() + " to revert the changes."));
                    if (okPressed) {
                        PermissionViewer.this.handleActivateAll();
                    } else {
                        BusyIndicator.showWhile((Display)PermissionViewer.this.getShell().getDisplay(), (Runnable)new Runnable(this){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                Iterator<E> iter = PermissionViewer.access$800(2.access$1200(this.this$1)).iterator();
                                while (iter.hasNext()) {
                                    try {
                                        ((IACL)iter.next()).revert();
                                    }
                                    catch (ACLException x) {
                                        PermissionViewer.access$1300(2.access$1200(this.this$1), x.getMessage());
                                        LogUtil.logException((Location)PermissionViewer.access$1400(), (Throwable)x);
                                    }
                                }
                            }
                        });
                    }
                }
                PermissionViewer.this.m_inactiveAcls.clear();
                PermissionViewer.this.m_visitedAcls.clear();
                PermissionViewer.this.registerAclListenerForCurrent(false, (IACLListener)PermissionViewer.this);
                if (VfsManagerProvider.getInstance().isSapIDELoginAvailable()) {
                    VfsManagerProvider.getInstance().removeIDELoginListener((IIDELoginListener)PermissionViewer.this);
                }
                Configuration.getConfiguration().removeConfigurationListener((IConfigurationListener)PermissionViewer.this);
            }

            static /* synthetic */ PermissionViewer access$1200(2 x0) {
                return x0.PermissionViewer.this;
            }
        });
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PermissionViewer.this.clearStatusBar();
            }
        });
        return base;
    }

    private void createCellEditors(Table table) {
        this.m_tableEditor = new TableEditor(table);
        CellEditor[] editors = new CellEditor[COLUMN_HEADERS.length];
        editors[0] = new TextCellEditor((Composite)table);
        String[] principalTypes = new String[]{PrincipalTypes.getPrincipalTypeByShort((short)1).toUpperCase(), PrincipalTypes.getPrincipalTypeByShort((short)2).toUpperCase(), PrincipalTypes.getPrincipalTypeByShort((short)3).toUpperCase()};
        editors[1] = new ComboBoxCellEditor((Composite)table, principalTypes, 8);
        editors[2] = new TextCellEditor((Composite)table);
        String[] grantTypes = new String[]{GrantTypes.getGrantTypeByInt((int)1).toUpperCase(), GrantTypes.getGrantTypeByInt((int)2).toUpperCase(), "FINAL DENY"};
        editors[4] = new ComboBoxCellEditor((Composite)table, grantTypes, 8);
        this.m_tableViewer.setCellEditors(editors);
        ICellModifier cellModifier = new ICellModifier(){

            public Object getValue(Object element, String property) {
                IACE ace = (IACE)element;
                if (property.equals(PermissionViewer.P_PRINCIPAL)) {
                    return ace.getPrincipal().getName();
                }
                if (property.equals(PermissionViewer.P_PRINCIPAL_TYPE)) {
                    short type = ace.getPrincipal().getType();
                    switch (type) {
                        case 1: {
                            return new Integer(0);
                        }
                        case 2: {
                            return new Integer(1);
                        }
                    }
                    return new Integer(2);
                }
                if (property.equals(PermissionViewer.P_DESCRIPTION)) {
                    return ace.getDescription();
                }
                if (property.equals(PermissionViewer.P_GRANT_TYPE)) {
                    int type = ace.getGrantType();
                    if (type == 1) {
                        return new Integer(0);
                    }
                    if (type == 2) {
                        return new Integer(1);
                    }
                    return new Integer(2);
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                IACE ace = (IACE)element;
                if (ace.isInherited()) {
                    return false;
                }
                boolean isChangeable = true;
                if (!isChangeable) {
                    return false;
                }
                return property.equals(PermissionViewer.P_PRINCIPAL) && ace.getPrincipal().getType() != 3 || property.equals(PermissionViewer.P_PRINCIPAL_TYPE) || property.equals(PermissionViewer.P_DESCRIPTION) || property.equals(PermissionViewer.P_GRANT_TYPE);
            }

            public void modify(Object element, String property, Object value) {
                PermissionViewer.this.clearStatusBar();
                TableItem item = (TableItem)element;
                IACE ace = (IACE)item.getData();
                if (ace.isInherited()) {
                    return;
                }
                if (property.equals(PermissionViewer.P_PRINCIPAL) && value instanceof String) {
                    String name = (String)value;
                    if (name.equals("")) {
                        PermissionViewer.this.showErrorMessage("Principal name must not be empty.");
                        return;
                    }
                    short type = ace.getPrincipal().getType();
                    if (name.equals("<All Users>") && type != 3) {
                        PermissionViewer.this.showErrorMessage("\"<All Users>\" is reserved. Please choose another principal name.");
                        return;
                    }
                    IPrincipalManager principalManager = PermissionViewer.this.getPrincipalManager(ace);
                    if (principalManager == null) {
                        PermissionViewer.this.showErrorMessage("Principal manager is <null>.");
                        return;
                    }
                    BusyIndicator.showWhile((Display)PermissionViewer.this.getShell().getDisplay(), (Runnable)new Runnable(this, type, principalManager, name, ace){
                        private final /* synthetic */ short val$type;
                        private final /* synthetic */ IPrincipalManager val$principalManager;
                        private final /* synthetic */ String val$name;
                        private final /* synthetic */ IACE val$ace;
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$type = val$type;
                            this.val$principalManager = val$principalManager;
                            this.val$name = val$name;
                            this.val$ace = val$ace;
                        }

                        public void run() {
                            Object principal = this.val$type == 1 ? this.val$principalManager.getUser(this.val$name) : (this.val$type == 2 ? this.val$principalManager.getGroup(this.val$name) : this.val$principalManager.getPrincipal(this.val$type));
                            try {
                                this.val$ace.setPrincipal((IPrincipal)principal);
                            }
                            catch (ACLException x) {
                                PermissionViewer.access$1300(5.access$1700(this.this$1), x.getMessage());
                                LogUtil.logException((Location)PermissionViewer.access$1400(), (Throwable)x);
                            }
                        }
                    });
                } else if (property.equals(PermissionViewer.P_PRINCIPAL_TYPE) && value instanceof Integer) {
                    IPrincipalManager principalManager = PermissionViewer.this.getPrincipalManager(ace);
                    if (principalManager == null) {
                        PermissionViewer.this.showErrorMessage("Principal manager is <null>.");
                        return;
                    }
                    BusyIndicator.showWhile((Display)PermissionViewer.this.getShell().getDisplay(), (Runnable)new Runnable(this, ace, value, principalManager){
                        private final /* synthetic */ IACE val$ace;
                        private final /* synthetic */ Object val$value;
                        private final /* synthetic */ IPrincipalManager val$principalManager;
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$ace = val$ace;
                            this.val$value = val$value;
                            this.val$principalManager = val$principalManager;
                        }

                        public void run() {
                            IPrincipal principal;
                            String name = this.val$ace.getPrincipal().getName();
                            int selectionIndex = (Integer)this.val$value;
                            switch (selectionIndex) {
                                case 0: {
                                    if (name == null || name.equals("")) {
                                        name = "[User Name]";
                                    }
                                    principal = this.val$principalManager.getUser(name);
                                    break;
                                }
                                case 1: {
                                    if (name == null || name.equals("")) {
                                        name = "[Group Name]";
                                    }
                                    principal = this.val$principalManager.getGroup(name);
                                    break;
                                }
                                default: {
                                    principal = this.val$principalManager.getPrincipal((short)3);
                                }
                            }
                            try {
                                this.val$ace.setPrincipal(principal);
                            }
                            catch (ACLException x) {
                                PermissionViewer.access$1300(5.access$1700(this.this$1), x.getMessage());
                                LogUtil.logException((Location)PermissionViewer.access$1400(), (Throwable)x);
                            }
                        }
                    });
                } else if (property.equals(PermissionViewer.P_DESCRIPTION) && value instanceof String) {
                    BusyIndicator.showWhile((Display)PermissionViewer.this.getShell().getDisplay(), (Runnable)new Runnable(this, ace, value){
                        private final /* synthetic */ IACE val$ace;
                        private final /* synthetic */ Object val$value;
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$ace = val$ace;
                            this.val$value = val$value;
                        }

                        public void run() {
                            try {
                                this.val$ace.setDescription((String)this.val$value);
                            }
                            catch (ACLException x) {
                                PermissionViewer.access$1300(5.access$1700(this.this$1), x.getMessage());
                                LogUtil.logException((Location)PermissionViewer.access$1400(), (Throwable)x);
                            }
                        }
                    });
                } else if (property.equals(PermissionViewer.P_GRANT_TYPE) && value instanceof Integer) {
                    BusyIndicator.showWhile((Display)PermissionViewer.this.getShell().getDisplay(), (Runnable)new Runnable(this, value, ace){
                        private final /* synthetic */ Object val$value;
                        private final /* synthetic */ IACE val$ace;
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$value = val$value;
                            this.val$ace = val$ace;
                        }

                        public void run() {
                            int selectionIndex = (Integer)this.val$value;
                            try {
                                if (selectionIndex == 0) {
                                    this.val$ace.setGrantType(1);
                                } else if (selectionIndex == 1) {
                                    this.val$ace.setGrantType(2);
                                } else if (selectionIndex == 2) {
                                    MessageDialog.openWarning((Shell)PermissionViewer.access$1000(5.access$1700(this.this$1)), (String)"Obsolete Grant Type \"FINAL DENY\"", (String)"The grant type \"FINAL DENY\" is not longer supported (since support package 11 for SAP NetWeaver Developer Studio).\n\nUse \"DENY\" and set the ACL as \"FINAL\" (button \"F\" on the view toolbar) instead.");
                                }
                            }
                            catch (ACLException x) {
                                PermissionViewer.access$1300(5.access$1700(this.this$1), x.getMessage());
                                LogUtil.logException((Location)PermissionViewer.access$1400(), (Throwable)x);
                            }
                        }
                    });
                }
            }

            static /* synthetic */ PermissionViewer access$1700(5 x0) {
                return x0.PermissionViewer.this;
            }
        };
        this.m_tableViewer.setCellModifier(cellModifier);
        this.m_tableViewer.setColumnProperties(COLUMN_PROPERTIES);
    }

    private void createActions() {
        this.m_actCreateAce = new Action("Add Principal"){

            public ImageDescriptor getImageDescriptor() {
                return DTRAdminPlugin.getDefault().createImageDescriptor("add_ace.gif");
            }

            public void run() {
                PermissionViewer.this.handleCreateAce();
            }
        };
        this.m_actEditAce = new Action("Edit Principal"){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)PermissionViewer.this.getSelection();
                Object item = selection.getFirstElement();
                if (item instanceof IACE) {
                    new EditAceDialog(PermissionViewer.this.getShell(), (IACE)item).open();
                } else {
                    PermissionViewer.this.showErrorMessage("Selection is not ACE object.");
                }
            }
        };
        this.m_actGotoDefinitionAcl = new Action("Definition ACL of this Principal"){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)PermissionViewer.this.getSelection();
                Object item = selection.getFirstElement();
                if (item instanceof IACE) {
                    PermissionViewer.this.setInput(((IACE)item).getResourceURL());
                }
            }
        };
        this.m_actGotoTopFinalAcl = new Action("Top \"Final\" Definition"){

            public ImageDescriptor getImageDescriptor() {
                return DTRAdminPlugin.getDefault().createImageDescriptor("goto_final.gif");
            }

            public void run() {
                PermissionViewer.this.setInput(PermissionViewer.this.getTopAclWithFinalDefinition());
            }
        };
        this.m_actGotoNextIgnoreAcl = new Action("Next \"Ignore Inheritance\" Definition"){

            public ImageDescriptor getImageDescriptor() {
                return DTRAdminPlugin.getDefault().createImageDescriptor("goto_ignore.gif");
            }

            public void run() {
                PermissionViewer.this.setInput(PermissionViewer.this.getNextAclWithIgnoreInheritanceDefinition());
            }
        };
        this.m_actDeleteAce = new Action("Delete Principal"){

            public ImageDescriptor getImageDescriptor() {
                return DTRAdminPlugin.getDefault().createImageDescriptor("delete_ace.gif");
            }

            public void run() {
                ISelection selection = PermissionViewer.this.getSelection();
                if (selection instanceof IStructuredSelection) {
                    PermissionViewer.this.handleDeleteAce((IStructuredSelection)selection);
                }
            }
        };
        this.m_actDeleteAcl = new Action("Delete ACL"){

            public void run() {
                PermissionViewer.this.handleDeleteAcl();
            }
        };
        this.m_actRevert = new Action("Revert Changes"){

            public ImageDescriptor getImageDescriptor() {
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                return sharedImages.getImageDescriptor("IMG_TOOL_UNDO_HOVER");
            }

            public void run() {
                PermissionViewer.this.handleRevertAcl();
            }
        };
        this.m_actSaveAcl = new Action("Save Changes"){

            public ImageDescriptor getImageDescriptor() {
                return DTRAdminPlugin.getDefault().createImageDescriptor("save.gif");
            }

            public void run() {
                PermissionViewer.this.handleSaveAcl();
            }
        };
        this.m_actRefreshAcl = new Action("Refresh"){

            public ImageDescriptor getImageDescriptor() {
                return DTRAdminPlugin.getDefault().createImageDescriptor("refresh.gif");
            }

            public void run() {
                PermissionViewer.this.handleRefreshAcl();
            }
        };
        this.m_actIgnoreInheritance = new Action("Ignore Inheritance"){

            public int getStyle() {
                return 2;
            }

            public ImageDescriptor getImageDescriptor() {
                return DTRAdminPlugin.getDefault().createImageDescriptor("ignore_inheritance.gif");
            }

            public void run() {
                PermissionViewer.this.handleIgnoreInheritance();
            }
        };
        this.m_actSetFinal = new Action("Set as Final"){

            public int getStyle() {
                return 2;
            }

            public ImageDescriptor getImageDescriptor() {
                return DTRAdminPlugin.getDefault().createImageDescriptor("final.gif");
            }

            public void run() {
                PermissionViewer.this.handleSetAsFinal();
            }
        };
        this.m_actActivateChanges = new Action("Activate all Changes"){

            public ImageDescriptor getImageDescriptor() {
                return DTRAdminPlugin.getDefault().createImageDescriptor("activate.gif");
            }

            public void run() {
                PermissionViewer.this.handleActivateAll();
                this.setEnabled(false);
            }
        };
        this.m_actOpenAcl = new Action("View Permission for URL..."){

            public ImageDescriptor getImageDescriptor() {
                return DTRAdminPlugin.getDefault().createImageDescriptor("new_acl.gif");
            }

            public void run() {
                PermissionViewer.this.handleOpenAcl();
            }
        };
        this.m_actClearHistory = new Action("Clear History"){

            public void run() {
                PermissionViewer.this.handleClearHistory();
            }
        };
    }

    private void handleCreateAce() {
        if (this.m_acl != null) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    new EditAceDialog(PermissionViewer.this.getShell(), PermissionViewer.this.m_acl).open();
                }
            });
        }
    }

    private void handleDeleteAce(final IStructuredSelection selectedAces) {
        if (this.m_acl != null && selectedAces.size() > 0) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    Iterator iter = selectedAces.iterator();
                    while (iter.hasNext()) {
                        IACE ace = (IACE)iter.next();
                        try {
                            PermissionViewer.this.m_acl.removeACE(ace);
                        }
                        catch (ACLException x) {
                            PermissionViewer.this.showErrorMessage(x.getMessage());
                            LogUtil.logException((Location)LOCATION, (Throwable)x);
                        }
                    }
                }
            });
        }
    }

    private void handleSaveAcl() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    PermissionViewer.this.m_acl.save();
                }
                catch (ACLException x) {
                    PermissionViewer.this.showErrorMessage(x.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                }
            }
        });
    }

    private void handleRevertAcl() {
        if (!this.m_acl.isRevertable() && !this.openWarningDialog("Revert Changes", "This action will result in the loss of all local changes. \n\nProceed with revert?", 1)) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    PermissionViewer.this.m_acl.revert();
                }
                catch (ACLException x) {
                    PermissionViewer.this.showErrorMessage(x.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                }
            }
        });
    }

    private void handleDeleteAcl() {
        if (!this.m_acl.isDeleted() && this.openWarningDialog("Delete Permissions", "Are you sure to delete the pemissions for resource \n\n[ " + this.m_acl.getResourcePath() + " ]?", 1)) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        PermissionViewer.this.m_acl.delete();
                    }
                    catch (ACLException x) {
                        PermissionViewer.this.showErrorMessage(x.getMessage());
                        LogUtil.logException((Location)LOCATION, (Throwable)x);
                    }
                }
            });
        }
    }

    private void handleIgnoreInheritance() {
        final boolean isChecked = this.m_actIgnoreInheritance.isChecked();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    PermissionViewer.this.m_acl.setInheritanceType(isChecked ? 3 : 1);
                }
                catch (ACLException x) {
                    PermissionViewer.this.showErrorMessage(x.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                }
            }
        });
    }

    private void handleSetAsFinal() {
        final boolean isChecked = this.m_actSetFinal.isChecked();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    PermissionViewer.this.m_acl.setInheritanceType(isChecked ? 4 : 1);
                }
                catch (ACLException x) {
                    PermissionViewer.this.showErrorMessage(x.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                }
            }
        });
    }

    private void handleRefreshAcl() {
        if (!this.m_acl.isRefreshable() && !this.openWarningDialog("Refresh ACL", "This action will result in the loss of all unsaved changes. \n\nProceed with refresh?", 1)) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    PermissionViewer.this.m_refreshEventFromRefreshAction = true;
                    PermissionViewer.this.m_acl.refresh();
                }
                catch (ACLException x) {
                    PermissionViewer.this.showErrorMessage(x.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                }
            }
        });
    }

    private void handleOpenAcl() {
        InputDialog newAclDialog;
        IVfsRepository[] repositories;
        String url = "<URL of resource>";
        IVersionedFileSystemManager vfsManager = this.getCurrentVfsManager();
        if (vfsManager != null && (repositories = vfsManager.getRepositories()) != null && repositories[0] != null) {
            url = repositories[0].getUrl();
        }
        if ((newAclDialog = new InputDialog(this.getShell(), "View Permission", "Enter a URL of resource:", url, new IInputValidator(){

            public String isValid(String newText) {
                if ("".equals(newText)) {
                    return "URL of resource must not be empty.";
                }
                try {
                    new URL(newText);
                }
                catch (MalformedURLException x) {
                    return x.getMessage();
                }
                return null;
            }
        })).open() == 0) {
            this.setInput(newAclDialog.getValue());
        }
    }

    private void handleActivateAll() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    IACLManager aclManager = PermissionViewer.this.getCurrentAclManager();
                    if (aclManager != null) {
                        aclManager.activate(PermissionViewer.this.m_inactiveAcls);
                    } else if (PermissionViewer.this.isDisposed()) {
                        MessageDialog.openError((Shell)PermissionViewer.this.getShell(), (String)"Activation Failed", (String)"ACL manager is <null>!");
                    } else {
                        PermissionViewer.this.showErrorMessage("ACL manager is <null>!");
                    }
                }
                catch (ACLException x) {
                    if (PermissionViewer.this.isDisposed()) {
                        MessageDialog.openError((Shell)PermissionViewer.this.getShell(), (String)"Activation Failed", (String)("Unable to activate permissions for [" + x.getACL().getResourcePath() + "].\n\n" + "Reason:\n" + x.getMessage()));
                    } else {
                        PermissionViewer.this.showErrorMessage(x.getMessage());
                    }
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                }
            }
        });
    }

    protected void handleClearHistory() {
        if (!this.m_inactiveAcls.isEmpty() && !this.openWarningDialog("Inactive Changes", "You have still inactive changes.\n\nInactive ACLs will not removed from history.", 0)) {
            return;
        }
        this.m_visitedAcls.clear();
        if (!this.m_inactiveAcls.isEmpty()) {
            this.m_visitedAcls.addAll(this.m_inactiveAcls);
        }
    }

    private boolean openWarningDialog(String title, String message, int indexOfDefaultButton) {
        MessageDialog warnDialog = new MessageDialog(this.getShell(), title, null, message, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, indexOfDefaultButton);
        return warnDialog.open() == 0;
    }

    private IAction getCreateAceAction() {
        return this.m_actCreateAce;
    }

    private IAction getEditAceAction() {
        return this.m_actEditAce;
    }

    private IAction getGotoDefinitionAclAction() {
        return this.m_actGotoDefinitionAcl;
    }

    private IAction getGotoTopFinalAclAction() {
        return this.m_actGotoTopFinalAcl;
    }

    private IAction getGotoNextIgnoreInheritanceAclAction() {
        return this.m_actGotoNextIgnoreAcl;
    }

    private IAction getDeleteAceAction() {
        return this.m_actDeleteAce;
    }

    IAction getSaveAclAction() {
        return this.m_actSaveAcl;
    }

    IAction getRevertChangesAction() {
        return this.m_actRevert;
    }

    IAction getDeleteAclAction() {
        return this.m_actDeleteAcl;
    }

    IAction getIgnoreInheritanceAction() {
        return this.m_actIgnoreInheritance;
    }

    IAction getSetAsFinalAction() {
        return this.m_actSetFinal;
    }

    IAction getRefreshAclAction() {
        return this.m_actRefreshAcl;
    }

    IAction getOpenAclAction() {
        return this.m_actOpenAcl;
    }

    IAction getActivateChangesAction() {
        return this.m_actActivateChanges;
    }

    IAction getClearHistoryAction() {
        return this.m_actClearHistory;
    }

    protected boolean isIgnoreInheritanceActionEnabled() {
        if (this.m_acl != null) {
            try {
                IACE[] aces = this.m_acl.getACEs();
                if (aces != null) {
                    int i = 0;
                    while (i < aces.length) {
                        if (!aces[i].isInherited()) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
            catch (ACLException x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
        }
        return false;
    }

    protected boolean isSetAsFinalActionEnabled() {
        return this.getTopAclWithFinalDefinition() == null;
    }

    private void createContextMenus() {
        MenuManager menuManager = new MenuManager();
        menuManager.add(this.getCreateAceAction());
        menuManager.add(this.getEditAceAction());
        MenuManager subMenuManager_goto = new MenuManager("Go To");
        subMenuManager_goto.add(this.getGotoNextIgnoreInheritanceAclAction());
        subMenuManager_goto.add(this.getGotoTopFinalAclAction());
        subMenuManager_goto.add(this.getGotoDefinitionAclAction());
        menuManager.add((IContributionItem)subMenuManager_goto);
        subMenuManager_goto.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object selected;
                IStructuredSelection selection;
                if (PermissionViewer.this.m_acl == null) {
                    PermissionViewer.this.getGotoTopFinalAclAction().setEnabled(false);
                    PermissionViewer.this.getGotoNextIgnoreInheritanceAclAction().setEnabled(false);
                    PermissionViewer.this.getGotoDefinitionAclAction().setEnabled(false);
                    return;
                }
                PermissionViewer.this.getGotoNextIgnoreInheritanceAclAction().setEnabled(PermissionViewer.this.getNextAclWithIgnoreInheritanceDefinition() != null);
                PermissionViewer.this.getGotoTopFinalAclAction().setEnabled(PermissionViewer.this.getTopAclWithFinalDefinition() != null);
                boolean enableGotoDefinitionAclAction = false;
                if (PermissionViewer.this.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)PermissionViewer.this.getSelection()).size() == 1 && (selected = selection.getFirstElement()) instanceof IACE && ((IACE)selected).isInherited()) {
                    enableGotoDefinitionAclAction = true;
                }
                PermissionViewer.this.getGotoDefinitionAclAction().setEnabled(enableGotoDefinitionAclAction);
            }
        });
        menuManager.add(this.getDeleteAceAction());
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getRevertChangesAction());
        menuManager.add(this.getSaveAclAction());
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getRefreshAclAction());
        Menu contextMenu = menuManager.createContextMenu((Control)this.m_tableViewer.getTable());
        this.m_tableViewer.getTable().setMenu(contextMenu);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                boolean enableDeleteAceAction;
                boolean enableEditAceAction;
                block3: {
                    IStructuredSelection selection;
                    boolean isChangeable;
                    block4: {
                        if (PermissionViewer.this.m_acl == null) {
                            PermissionViewer.this.getCreateAceAction().setEnabled(false);
                            PermissionViewer.this.getEditAceAction().setEnabled(false);
                            PermissionViewer.this.getGotoDefinitionAclAction().setEnabled(false);
                            PermissionViewer.this.getDeleteAceAction().setEnabled(false);
                            PermissionViewer.this.getRevertChangesAction().setEnabled(false);
                            PermissionViewer.this.getSaveAclAction().setEnabled(false);
                            PermissionViewer.this.getRefreshAclAction().setEnabled(false);
                            return;
                        }
                        isChangeable = true;
                        PermissionViewer.this.getCreateAceAction().setEnabled(isChangeable);
                        enableEditAceAction = false;
                        enableDeleteAceAction = false;
                        if (!(PermissionViewer.this.getSelection() instanceof IStructuredSelection)) break block3;
                        selection = (IStructuredSelection)PermissionViewer.this.getSelection();
                        if (selection.size() != 1) break block4;
                        Object selected = selection.getFirstElement();
                        if (!(selected instanceof IACE) || !isChangeable) break block3;
                        enableEditAceAction = true;
                        enableDeleteAceAction = true;
                        break block3;
                    }
                    if (isChangeable && selection.size() > 0) {
                        enableDeleteAceAction = true;
                        Iterator iter = selection.iterator();
                        while (iter.hasNext()) {
                            if (iter.next() instanceof IACE) continue;
                            enableDeleteAceAction = false;
                            break;
                        }
                    }
                }
                PermissionViewer.this.getEditAceAction().setEnabled(enableEditAceAction);
                PermissionViewer.this.getDeleteAceAction().setEnabled(enableDeleteAceAction);
                PermissionViewer.this.getRevertChangesAction().setEnabled(PermissionViewer.this.isInactive(PermissionViewer.this.m_acl));
                PermissionViewer.this.getSaveAclAction().setEnabled(PermissionViewer.this.m_acl.isChanged());
                PermissionViewer.this.getRefreshAclAction().setEnabled(true);
            }
        });
    }

    private void addMouseListener() {
        this.m_tableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                Object data;
                Point pt = new Point(e.x, e.y);
                TableItem item = PermissionViewer.this.m_tableViewer.getTable().getItem(pt);
                if (item != null && (data = item.getData()) instanceof IACE) {
                    IACE ace = (IACE)data;
                    if (ace.isInherited()) {
                        PermissionViewer.this.setInput(ace.getResourceURL());
                    } else {
                        new EditAceDialog(PermissionViewer.this.getShell(), (IACE)data).open();
                    }
                }
            }
        });
    }

    private void addKeyListener() {
        this.m_tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f' && e.stateMask == 0) {
                    PermissionViewer.this.getDeleteAceAction().run();
                } else if (e.keyCode == 0x100000E && e.stateMask == 0) {
                    PermissionViewer.this.getRefreshAclAction().run();
                } else if (e.character == '\t' && e.keyCode == 262144) {
                    PermissionViewer.this.getCreateAceAction().run();
                }
            }
        });
    }

    public void setFocus() {
        this.m_tableViewer.getTable().setFocus();
    }

    public Control getControl() {
        return this.m_tableViewer.getTable();
    }

    public Object getInput() {
        return this.m_acl;
    }

    public ISelection getSelection() {
        return this.m_tableViewer.getSelection();
    }

    public void refresh() {
        this.m_tableViewer.refresh();
    }

    public void setInput(final Object input) {
        this.clearStatusBar();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IACL newInput = null;
                if (input instanceof IACL) {
                    newInput = (IACL)input;
                } else if (input instanceof IVfsFolderItem) {
                    newInput = PermissionViewer.this.getAcl((IVfsFolderItem)input);
                } else if (input instanceof String) {
                    newInput = PermissionViewer.this.getAcl((String)input);
                }
                if (newInput != null) {
                    if (!newInput.equals(PermissionViewer.this.m_acl)) {
                        PermissionViewer.this.m_visitedAcls.add(newInput);
                        PermissionViewer.access$3802(PermissionViewer.this, null);
                        PermissionViewer.this.m_tableViewer.setInput((Object)newInput);
                        PermissionViewer.this.m_acl = newInput;
                        PermissionViewer.this.fireInputChangedEvent(newInput);
                    }
                } else if (PermissionViewer.this.m_acl != null) {
                    PermissionViewer.access$3802(PermissionViewer.this, null);
                    PermissionViewer.this.m_tableViewer.setInput((Object)newInput);
                    PermissionViewer.this.m_acl = newInput;
                    PermissionViewer.this.fireInputChangedEvent(newInput);
                }
            }
        });
    }

    private void fireInputChangedEvent(IACL newInput) {
        Iterator iter = this.m_inputListeners.iterator();
        while (iter.hasNext()) {
            ((IContentProvider)iter.next()).inputChanged((Viewer)this.m_tableViewer, (Object)this.m_acl, (Object)newInput);
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.m_tableViewer.setSelection(selection, reveal);
    }

    public void setStatusLineManager(IStatusLineManager manager) {
        this.m_statusLineManager = manager;
    }

    private IStatusLineManager getStatusLineManager() {
        return this.m_statusLineManager;
    }

    private void clearStatusBar() {
        if (this.getStatusLineManager() != null) {
            this.getStatusLineManager().setMessage(null, null);
            this.getStatusLineManager().setErrorMessage(null, null);
        }
    }

    protected Set getVisitedAcls() {
        return this.m_visitedAcls;
    }

    protected boolean hasInactiveChanges() {
        return !this.m_inactiveAcls.isEmpty();
    }

    protected boolean isInactive(IACL acl) {
        return this.m_inactiveAcls.contains(acl);
    }

    protected boolean updateInactiveAclCache(IACL acl, boolean add) {
        if (add) {
            return this.m_inactiveAcls.add(acl);
        }
        return this.m_inactiveAcls.remove(acl);
    }

    protected boolean comesEventFromRefreshAction() {
        return this.m_refreshEventFromRefreshAction;
    }

    protected void resetFlagForRefreshEvent() {
        this.m_refreshEventFromRefreshAction = false;
    }

    protected IACLManager getCurrentAclManager() {
        IVersionedFileSystemManager vfsManager = this.getCurrentVfsManager();
        if (vfsManager != null) {
            try {
                return ACLFactory.getACLManager((IVersionedFileSystemManager)vfsManager);
            }
            catch (ACLException x) {
                this.showErrorMessage("Getting aclManager failed: " + x.getMessage());
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
        }
        return null;
    }

    protected IACLManager getAclManager(IClient client) {
        if (client == null) {
            return null;
        }
        try {
            IVersionedFileSystemManager vfsManager = VfsManagerProvider.getInstance().getVersionedFileSystemManager(client.getContext());
            if (vfsManager != null) {
                return ACLFactory.getACLManager((IVersionedFileSystemManager)vfsManager);
            }
        }
        catch (VfsException x) {
            this.showErrorMessage(x.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
        }
        catch (ACLException x) {
            this.showErrorMessage("Getting aclManager failed: " + x.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)x);
        }
        return null;
    }

    private IVersionedFileSystemManager getCurrentVfsManager() {
        IClient activeClient = Configuration.getConfiguration().getActiveClient();
        if (activeClient != null) {
            try {
                return VfsManagerProvider.getInstance().getVersionedFileSystemManager(activeClient.getContext());
            }
            catch (VfsException x) {
                this.showErrorMessage(x.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        }
        return null;
    }

    private IVersionedFileSystemManager getVfsManager(IACL acl) {
        IACLManager aclManager;
        if (acl != null && (aclManager = acl.getACLManager()) != null) {
            return aclManager.getVfsManager();
        }
        return null;
    }

    protected String getClientName(IACL acl) {
        IVersionedFileSystemManager vfsManager = this.getVfsManager(acl);
        if (vfsManager != null) {
            return vfsManager.getClientName();
        }
        return null;
    }

    private IPrincipalManager getPrincipalManager(IACE ace) {
        IACL acl;
        IVersionedFileSystemManager vfsManager;
        if (ace != null && (vfsManager = this.getVfsManager(acl = ace.getACL())) != null) {
            try {
                return PrincipalFactory.getPrincipalManager((IVersionedFileSystemManager)vfsManager);
            }
            catch (PrincipalException x) {
                this.showErrorMessage("Getting principal manager failed: " + x.getMessage());
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
        }
        return null;
    }

    private IACL getAcl(IVfsFolderItem folderItem) {
        IACLManager aclManager = this.getCurrentAclManager();
        if (aclManager != null) {
            try {
                return aclManager.getACL(folderItem);
            }
            catch (ACLException x) {
                String resourceUrl = null;
                try {
                    resourceUrl = folderItem.getUrl();
                }
                catch (VfsException ex) {
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)ex);
                }
                if (resourceUrl != null) {
                    this.showErrorMessage("Retrieving ACL for resource [" + resourceUrl + "] failed: " + x.getMessage());
                } else {
                    this.showErrorMessage("Retrieving ACL for resource failed: " + x.getMessage());
                }
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        }
        return null;
    }

    private IACL getAcl(String resourceUrl) {
        IACLManager aclManager = this.getCurrentAclManager();
        if (aclManager != null) {
            try {
                return aclManager.getACL(resourceUrl);
            }
            catch (ACLException x) {
                this.showErrorMessage("Retrieving ACL for resource [" + resourceUrl + "] failed: " + x.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        }
        return null;
    }

    protected boolean isDisposed() {
        return this.m_viewerDisposed;
    }

    private Shell getShell() {
        if (this.m_parent != null) {
            return this.m_parent.getShell();
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private void showErrorMessage(String message) {
        this.showMessage(message, 3);
    }

    private void showMessage(String message, int messageType) {
        if (this.m_statusLineManager != null) {
            this.m_statusLineManager.setErrorMessage(null);
            this.m_statusLineManager.setMessage(null);
            switch (messageType) {
                case 3: {
                    this.m_statusLineManager.setErrorMessage(Dialog.getImage((String)"dialog_message_error_image"), message);
                    break;
                }
                case 1: {
                    this.m_statusLineManager.setMessage(Dialog.getImage((String)"dialog_messasge_info_image"), message);
                    break;
                }
                case 2: {
                    this.m_statusLineManager.setMessage(Dialog.getImage((String)"dialog_messasge_warning_image"), message);
                    break;
                }
                default: {
                    this.m_statusLineManager.setMessage(message);
                    break;
                }
            }
        } else if (!this.isDisposed()) {
            switch (messageType) {
                case 3: {
                    Logbook.getErrorChapter().println(message);
                    break;
                }
                case 1: {
                    Logbook.getInfoChapter().println(message);
                    break;
                }
                case 2: {
                    Logbook.getWarnChapter().println(message);
                    break;
                }
                default: {
                    Logbook.getPlainChapter().println(message);
                }
            }
        }
    }

    private Image getDefaultColumnIcon(int columnIndex) {
        switch (columnIndex) {
            case 5: {
                return DTRAdminPlugin.getDefault().getAtomicImage("priv_access_co.gif");
            }
            case 6: {
                return DTRAdminPlugin.getDefault().getAtomicImage("priv_read_co.gif");
            }
            case 7: {
                return DTRAdminPlugin.getDefault().getAtomicImage("priv_write_co.gif");
            }
            case 8: {
                return DTRAdminPlugin.getDefault().getAtomicImage("priv_checkin_co.gif");
            }
            case 9: {
                return DTRAdminPlugin.getDefault().getAtomicImage("priv_import_co.gif");
            }
            case 10: {
                return DTRAdminPlugin.getDefault().getAtomicImage("priv_export_co.gif");
            }
            case 11: {
                return DTRAdminPlugin.getDefault().getAtomicImage("priv_integrate_co.gif");
            }
            case 12: {
                return DTRAdminPlugin.getDefault().getAtomicImage("priv_adminA_co.gif");
            }
            case 13: {
                return DTRAdminPlugin.getDefault().getAtomicImage("priv_adminX_co.gif");
            }
        }
        return null;
    }

    private String getCloumnExplanation(int columnIndex) {
        switch (columnIndex) {
            case 5: {
                return "Privilege <access>";
            }
            case 6: {
                return "Privilege <read>";
            }
            case 7: {
                return "Privilege <write>";
            }
            case 8: {
                return "Privilege <checkin>";
            }
            case 9: {
                return "Privilege <import>";
            }
            case 10: {
                return "Privilege <export>";
            }
            case 11: {
                return "Privilege <integrate>";
            }
            case 12: {
                return "Privilege <adminA>";
            }
            case 13: {
                return "Privilege <adminX>";
            }
        }
        return null;
    }

    public void addInputChangelistener(IContentProvider listener) {
        this.m_inputListeners.add(listener);
    }

    public void removeInputChangelistener(IContentProvider listener) {
        this.m_inputListeners.remove(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_tableViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_tableViewer.removeSelectionChangedListener(listener);
    }

    public void added(IACL acl) {
    }

    public void activated(IACL acl) {
        if (!this.isDisposed()) {
            this.m_inactiveAcls.remove(acl);
        }
    }

    public void saved(IACL acl) {
    }

    public void deleted(IACL acl) {
        if (acl.equals(this.getInput())) {
            this.m_tableViewer.refresh();
        }
        this.m_inactiveAcls.add(acl);
    }

    public void refreshed(IACL acl) {
        if (!this.isDisposed() && acl != null && acl.equals(this.getInput())) {
            this.m_tableViewer.refresh();
        }
    }

    public void aceAdded(IACL acl, IACE ace) {
        if (acl != null) {
            if (acl.equals(this.getInput()) && this.m_tableViewer.testFindItem((Object)ace) == null) {
                this.m_tableViewer.add((Object)ace);
                this.m_tableViewer.setSelection((ISelection)new StructuredSelection((Object)ace), true);
            }
            this.m_inactiveAcls.add(acl);
        }
    }

    public void aceRemoved(IACL acl, IACE ace) {
        if (acl != null) {
            if (acl.equals(this.getInput())) {
                this.m_tableViewer.remove((Object)ace);
            }
            this.m_inactiveAcls.add(acl);
        }
    }

    public void aceChanged(IACL acl, IACE ace) {
        if (acl != null) {
            if (acl.equals(this.getInput())) {
                this.m_tableViewer.refresh((Object)ace, true);
            }
            this.m_inactiveAcls.add(acl);
        }
    }

    public void inheritanceChanged(IACL acl, int newType) {
        if (acl != null) {
            if (acl.equals(this.getInput())) {
                this.m_tableViewer.refresh();
            }
            this.m_inactiveAcls.add(acl);
        }
    }

    public void onUserLoggedIn(String[] userAndPassword, KeyStore[] serverAndClientCerts) {
        this.registerAclListenerForCurrent(true, (IACLListener)this);
    }

    public void onUserLoggedOut() {
    }

    public void onActiveClientChanged(IClient newClient, IClient oldClient) {
        this.handleActiveClientChanged(newClient, oldClient, (IACLListener)this);
    }

    public void onConfigurationChanged(IConfiguration configuration) {
    }

    protected void registerAclListenerForCurrent(boolean register, IACLListener aclListener) {
        IACLManager aclManager = this.getCurrentAclManager();
        if (aclManager != null) {
            if (register) {
                aclManager.addACLListener(aclListener);
            } else {
                aclManager.removeACLListener(aclListener);
            }
        }
    }

    protected void handleActiveClientChanged(IClient newClient, IClient oldClient, IACLListener aclListener) {
        IACLManager newAclManager;
        IACLManager oldAclManager = this.getAclManager(oldClient);
        if (oldAclManager != null) {
            oldAclManager.removeACLListener(aclListener);
        }
        if ((newAclManager = this.getAclManager(newClient)) != null) {
            newAclManager.addACLListener(aclListener);
        }
    }

    private IACL[] getParentAcls() {
        if (this.m_parentAcls == null) {
            if (this.getInput() instanceof IACL) {
                try {
                    this.m_parentAcls = ((IACL)this.getInput()).getParentACLs();
                }
                catch (ACLException x) {
                    this.showErrorMessage(x.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                }
            } else {
                return null;
            }
        }
        return this.m_parentAcls;
    }

    private IACL getTopAclWithFinalDefinition() {
        if (this.getParentAcls() != null) {
            IACL[] parentAcls = this.getParentAcls();
            int i = parentAcls.length - 1;
            while (i >= 0) {
                if (parentAcls[i].getInheritanceType() == 4) {
                    return parentAcls[i];
                }
                --i;
            }
        }
        return null;
    }

    private IACL getNextAclWithIgnoreInheritanceDefinition() {
        if (this.getParentAcls() != null) {
            IACL[] parentAcls = this.getParentAcls();
            int i = 0;
            while (i < parentAcls.length) {
                if (parentAcls[i].getInheritanceType() == 3) {
                    return parentAcls[i];
                }
                ++i;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ IACL[] access$3802(PermissionViewer x0, IACL[] x1) {
        x0.m_parentAcls = x1;
        return x1;
    }

    private class AclTableViewerSorter
    extends ViewerSorter {
        private int m_columnIndex;
        private boolean m_ascending;

        public AclTableViewerSorter(int columnIndex, boolean ascending) {
            this.m_columnIndex = columnIndex;
            this.m_ascending = ascending;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IBaseLabelProvider labelProvider;
            if (viewer instanceof StructuredViewer && (labelProvider = ((StructuredViewer)viewer).getLabelProvider()) instanceof AclLabelProvider) {
                if (this.m_columnIndex > 4) {
                    Image img1 = ((AclLabelProvider)labelProvider).getColumnImage(e1, this.m_columnIndex);
                    Image img2 = ((AclLabelProvider)labelProvider).getColumnImage(e2, this.m_columnIndex);
                    if (img1 != null) {
                        if (img2 != null) {
                            return 0;
                        }
                        if (this.m_ascending) {
                            return 1;
                        }
                        return -1;
                    }
                    if (img2 == null) {
                        return 0;
                    }
                    if (this.m_ascending) {
                        return -1;
                    }
                    return 1;
                }
                String str1 = ((AclLabelProvider)labelProvider).getColumnText(e1, this.m_columnIndex);
                String str2 = ((AclLabelProvider)labelProvider).getColumnText(e2, this.m_columnIndex);
                if (str1 == null || str2 == null) {
                    Logbook.getWarnChapter().println("Argument's toString in AclTableViewerSorter.compare is <null>.");
                    Logbook.getWarnChapter().flush();
                    throw new IllegalStateException("Can't compare <null> toString'ed arguments.");
                }
                return this.m_ascending ? str1.compareToIgnoreCase(str2) : -str1.compareToIgnoreCase(str2);
            }
            return 0;
        }
    }

    private class AclLabelProvider
    implements ITableLabelProvider {
        private AclLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof IACE) {
                IACE ace = (IACE)element;
                int privilege = ace.getPrivilege();
                switch (columnIndex) {
                    case 5: {
                        return PrivilegeTypes.privilegeMatch((int)1, (int)privilege) ? IMAGE_ACCESS : null;
                    }
                    case 6: {
                        return PrivilegeTypes.privilegeMatch((int)2, (int)privilege) ? IMAGE_READ : null;
                    }
                    case 7: {
                        return PrivilegeTypes.privilegeMatch((int)4, (int)privilege) ? IMAGE_WRITE : null;
                    }
                    case 8: {
                        return PrivilegeTypes.privilegeMatch((int)8, (int)privilege) ? IMAGE_CHECKIN : null;
                    }
                    case 9: {
                        return PrivilegeTypes.privilegeMatch((int)16, (int)privilege) ? IMAGE_IMPORT : null;
                    }
                    case 10: {
                        return PrivilegeTypes.privilegeMatch((int)32, (int)privilege) ? IMAGE_EXPORT : null;
                    }
                    case 11: {
                        return PrivilegeTypes.privilegeMatch((int)64, (int)privilege) ? IMAGE_INTEGRATE : null;
                    }
                    case 12: {
                        return PrivilegeTypes.privilegeMatch((int)128, (int)privilege) ? IMAGE_ADMINA : null;
                    }
                    case 13: {
                        return PrivilegeTypes.privilegeMatch((int)256, (int)privilege) ? IMAGE_ADMINX : null;
                    }
                }
                return null;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IACE ace;
            IPrincipal principal;
            if (element instanceof IACE && (principal = (ace = (IACE)element).getPrincipal()) != null) {
                switch (columnIndex) {
                    case 0: {
                        return principal.getType() == 3 ? "<All Users>" : principal.getName();
                    }
                    case 1: {
                        return PrincipalTypes.getPrincipalTypeByShort((short)principal.getType()).toUpperCase();
                    }
                    case 2: {
                        return ace.getDescription() == null ? "" : ace.getDescription();
                    }
                    case 3: {
                        return ace.isInherited() ? ace.getResourcePath() : "";
                    }
                    case 4: {
                        int grantType = ace.getGrantType();
                        if (grantType == 1) {
                            return GrantTypes.getGrantTypeByInt((int)1).toUpperCase();
                        }
                        if (grantType == 2) {
                            return GrantTypes.getGrantTypeByInt((int)2).toUpperCase();
                        }
                        if (grantType == 3) {
                            PermissionViewer.this.showMessage("Usages of obsolete grant type \"FINAL DENY\" detected", 2);
                            return "FINAL DENY";
                        }
                        return "";
                    }
                }
                return "";
            }
            return "?";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class AclContentProvider
    implements IStructuredContentProvider {
        private AclContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IACL) {
                try {
                    return ((IACL)inputElement).getACEs();
                }
                catch (ACLException e) {
                    PermissionViewer.this.showErrorMessage(e.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                }
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

