/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.admin.ui;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.admin.DTRAdminPlugin;
import com.tssap.dtr.client.eclipse.admin.ui.PermissionViewer;
import com.tssap.dtr.client.eclipse.internal.IIDELoginListener;
import com.tssap.dtr.client.eclipse.ui.LegendDialog;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.IRepositoryViewLegendManager;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.eclipse.ui.util.ConcreteCompositeImageDescriptor;
import com.tssap.dtr.client.eclipse.util.ILegend;
import com.tssap.dtr.client.eclipse.util.LegendElement;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.acl.IACE;
import com.tssap.dtr.client.lib.acl.IACL;
import com.tssap.dtr.client.lib.acl.IACLListener;
import com.tssap.dtr.client.lib.acl.IInheritanceAwareACLListener;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.IConfigurationListener;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class PermissionView
extends ViewPart
implements IContentProvider,
ISelectionChangedListener,
IInheritanceAwareACLListener,
IIDELoginListener,
IConfigurationListener {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$admin$ui$PermissionView == null ? (class$com$tssap$dtr$client$eclipse$admin$ui$PermissionView = PermissionView.class$("com.tssap.dtr.client.eclipse.admin.ui.PermissionView")) : class$com$tssap$dtr$client$eclipse$admin$ui$PermissionView));
    private static final String VIEW_TITLE_SEPARATOR = " - ";
    private static final String CLIENT_NAME_MARK_BEGIN = "  [";
    private static final String CLIENT_NAME_MARK_END = "]";
    private static final String CHANGED_MARK = "*";
    private static final String INACTIVE_MARK = "(!) ";
    private static final String PRESTORE_KEYPART_LINK_WITH_BROWSER = "_linkWithRepositoryBrowser";
    private static final ImageDescriptor DECORATOR_CHANGED = DTRAdminPlugin.getDefault().createImageDescriptor("changed.gif");
    private static final ImageDescriptor DECORATOR_INACTIVE = DTRAdminPlugin.getDefault().createImageDescriptor("inactive.gif");
    private PermissionViewer m_viewer;
    private IAction m_actRevert;
    private IAction m_actSaveAcl;
    private IAction m_actDeleteAcl;
    private IAction m_actRefreshAcl;
    private IAction m_actIgnoreInheritance;
    private IAction m_actSetFinal;
    private IAction m_actActivateChanges;
    private IAction m_actOpenAcl;
    private IAction m_actClearHistory;
    private TreeViewer m_treeViewerOfRepositoryBrowser;
    private Image m_defaultViewTitleImage;
    private IRepositoryViewLegendManager m_legendManager;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$admin$ui$PermissionView;

    public void createPartControl(Composite parent) {
        this.m_viewer = new PermissionViewer();
        this.getPermissionViewer().createControl(parent, 66306);
        this.getPermissionViewer().setStatusLineManager(this.getViewSite().getActionBars().getStatusLineManager());
        this.getPermissionViewer().addInputChangelistener(this);
        this.getPermissionViewer().addSelectionChangedListener(this);
        this.getPermissionViewer().registerAclListenerForCurrent(true, (IACLListener)this);
        if (VfsManagerProvider.getInstance().isSapIDELoginAvailable()) {
            VfsManagerProvider.getInstance().addIDELoginListener((IIDELoginListener)this);
        }
        Configuration.getConfiguration().addConfigurationListener((IConfigurationListener)this);
        this.createActions();
        this.createToolbar();
        this.createMenu();
    }

    private void createActions() {
        this.m_actRevert = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return PermissionView.this.getPermissionViewer().getRevertChangesAction().getImageDescriptor();
            }

            public String getToolTipText() {
                return PermissionView.this.getPermissionViewer().getRevertChangesAction().getText();
            }

            public void run() {
                PermissionView.this.getPermissionViewer().getRevertChangesAction().run();
            }
        };
        this.m_actSaveAcl = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return PermissionView.this.getPermissionViewer().getSaveAclAction().getImageDescriptor();
            }

            public String getToolTipText() {
                return PermissionView.this.getPermissionViewer().getSaveAclAction().getText();
            }

            public void run() {
                PermissionView.this.getPermissionViewer().getSaveAclAction().run();
            }
        };
        this.m_actDeleteAcl = new Action(){

            public ImageDescriptor getImageDescriptor() {
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                return sharedImages.getImageDescriptor("IMG_TOOL_DELETE_HOVER");
            }

            public String getToolTipText() {
                return PermissionView.this.getPermissionViewer().getDeleteAclAction().getText();
            }

            public void run() {
                PermissionView.this.getPermissionViewer().getDeleteAclAction().run();
            }
        };
        this.m_actRefreshAcl = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return PermissionView.this.getPermissionViewer().getRefreshAclAction().getImageDescriptor();
            }

            public String getToolTipText() {
                return PermissionView.this.getPermissionViewer().getRefreshAclAction().getText() + "   [F5]";
            }

            public void run() {
                PermissionView.this.getPermissionViewer().getRefreshAclAction().run();
            }
        };
        this.m_actIgnoreInheritance = new Action(){

            public int getStyle() {
                return PermissionView.this.getPermissionViewer().getIgnoreInheritanceAction().getStyle();
            }

            public ImageDescriptor getImageDescriptor() {
                return PermissionView.this.getPermissionViewer().getIgnoreInheritanceAction().getImageDescriptor();
            }

            public String getToolTipText() {
                return PermissionView.this.getPermissionViewer().getIgnoreInheritanceAction().getText();
            }

            public void run() {
                PermissionView.this.getPermissionViewer().getIgnoreInheritanceAction().setChecked(this.isChecked());
                PermissionView.this.getPermissionViewer().getIgnoreInheritanceAction().run();
            }
        };
        this.m_actIgnoreInheritance.setChecked(false);
        this.m_actSetFinal = new Action(){

            public int getStyle() {
                return PermissionView.this.getPermissionViewer().getSetAsFinalAction().getStyle();
            }

            public ImageDescriptor getImageDescriptor() {
                return PermissionView.this.getPermissionViewer().getSetAsFinalAction().getImageDescriptor();
            }

            public String getToolTipText() {
                return PermissionView.this.getPermissionViewer().getSetAsFinalAction().getText();
            }

            public void run() {
                PermissionView.this.getPermissionViewer().getSetAsFinalAction().setChecked(this.isChecked());
                PermissionView.this.getPermissionViewer().getSetAsFinalAction().run();
            }
        };
        this.m_actSetFinal.setChecked(false);
        this.m_actOpenAcl = new Action(){

            public String getText() {
                return PermissionView.this.getPermissionViewer().getOpenAclAction().getText();
            }

            public ImageDescriptor getImageDescriptor() {
                return PermissionView.this.getPermissionViewer().getOpenAclAction().getImageDescriptor();
            }

            public String getToolTipText() {
                return PermissionView.this.getPermissionViewer().getOpenAclAction().getText();
            }

            public void run() {
                PermissionView.this.getPermissionViewer().getOpenAclAction().run();
            }
        };
        this.m_actActivateChanges = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return PermissionView.this.getPermissionViewer().getActivateChangesAction().getImageDescriptor();
            }

            public String getToolTipText() {
                return PermissionView.this.getPermissionViewer().getActivateChangesAction().getText();
            }

            public void run() {
                PermissionView.this.getPermissionViewer().getActivateChangesAction().run();
            }
        };
        this.disableAllActions();
        this.m_actClearHistory = new Action(this.getPermissionViewer().getClearHistoryAction().getText()){

            public void run() {
                PermissionView.this.getPermissionViewer().getClearHistoryAction().run();
            }
        };
    }

    private void createToolbar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add(this.m_actIgnoreInheritance);
        toolbarManager.add(this.m_actSetFinal);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add(this.m_actRefreshAcl);
        toolbarManager.add(this.m_actRevert);
        toolbarManager.add(this.m_actSaveAcl);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add(this.m_actActivateChanges);
    }

    private void disableAllActions() {
        this.m_actDeleteAcl.setEnabled(false);
        this.m_actRefreshAcl.setEnabled(false);
        this.m_actIgnoreInheritance.setEnabled(false);
        this.m_actSetFinal.setEnabled(false);
        this.m_actRevert.setEnabled(false);
        this.m_actSaveAcl.setEnabled(false);
        this.m_actActivateChanges.setEnabled(false);
    }

    private void createMenu() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        Action dummyAction = new Action("<emtpy>"){

            public boolean isEnabled() {
                return false;
            }
        };
        MenuManager openAclsMenu = new MenuManager("Open ACLs");
        openAclsMenu.add((IAction)dummyAction);
        menuManager.add((IContributionItem)openAclsMenu);
        openAclsMenu.addMenuListener(new IMenuListener((IAction)dummyAction){
            private final /* synthetic */ IAction val$dummyAction;
            {
                this.val$dummyAction = val$dummyAction;
            }

            public void menuAboutToShow(IMenuManager manager) {
                manager.removeAll();
                Set visitedAcls = PermissionView.this.getPermissionViewer().getVisitedAcls();
                if (visitedAcls.isEmpty()) {
                    manager.add(this.val$dummyAction);
                } else {
                    ArrayList list = new ArrayList(visitedAcls.size());
                    Iterator iter = visitedAcls.iterator();
                    while (iter.hasNext()) {
                        list.add(iter.next());
                    }
                    Collections.sort(list, new Comparator(this){
                        private final /* synthetic */ 11 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public int compare(Object o1, Object o2) {
                            if (o1 instanceof IACL && o2 instanceof IACL) {
                                String str1 = ((IACL)o1).getResourceURL();
                                String str2 = ((IACL)o2).getResourceURL();
                                if (str1 != null && str2 != null) {
                                    return str1.compareToIgnoreCase(str2);
                                }
                            }
                            return 0;
                        }
                    });
                    iter = list.iterator();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        if (!(obj instanceof IACL)) continue;
                        Action action = new Action(this, obj){
                            private final /* synthetic */ Object val$obj;
                            private final /* synthetic */ 11 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$obj = val$obj;
                            }

                            public void run() {
                                11.access$000(this.this$1).getPermissionViewer().setInput(this.val$obj);
                            }
                        };
                        IACL acl = (IACL)obj;
                        boolean isInactive = PermissionView.this.getPermissionViewer().isInactive(acl);
                        String label = acl.isChanged() ? PermissionView.CHANGED_MARK : (isInactive ? PermissionView.INACTIVE_MARK : "");
                        label = label + acl.getResourcePath();
                        label = label + PermissionView.CLIENT_NAME_MARK_BEGIN + PermissionView.this.getPermissionViewer().getClientName((IACL)obj) + PermissionView.CLIENT_NAME_MARK_END;
                        action.setText(label);
                        action.setChecked(obj.equals(PermissionView.this.getPermissionViewer().getInput()));
                        manager.add((IAction)action);
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add(PermissionView.this.m_actClearHistory);
                }
            }

            static /* synthetic */ PermissionView access$000(11 x0) {
                return x0.PermissionView.this;
            }
        });
        menuManager.add(this.m_actOpenAcl);
        menuManager.add((IContributionItem)new Separator());
        Action actLink = new Action("Link With Repository Browser"){

            public void run() {
                DTRAdminPlugin.getDefault().getPreferenceStore().setValue("com.tssap.dtr.client.eclipse.admin.ui.PermissionView_linkWithRepositoryBrowser", this.isChecked());
                if (this.isChecked() && PermissionView.this.getPermissionViewer() != null) {
                    PermissionView.this.linkWithRepositoryBrowser(PermissionView.this.getPermissionViewer().getInput());
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return DTRAdminPlugin.getDefault().createImageDescriptor("linkWith.gif");
            }
        };
        menuManager.add((IAction)actLink);
        menuManager.add((IContributionItem)new Separator());
        Action actViewLegend = new Action("Display Legend"){

            public void run() {
                new LegendDialog(PermissionView.this.getSite().getShell(), PermissionView.this.getLegendManager(), this.getImageDescriptor().createImage(true)).open();
            }

            public ImageDescriptor getImageDescriptor() {
                return DTRAdminPlugin.getDefault().createImageDescriptor("showlegend.gif");
            }
        };
        menuManager.add((IAction)actViewLegend);
        menuManager.addMenuListener(new IMenuListener((IAction)actLink){
            private final /* synthetic */ IAction val$actLink;
            {
                this.val$actLink = val$actLink;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.val$actLink.setChecked(PermissionView.this.isLinkedWithRepositoryBrowser());
            }
        });
    }

    private boolean isLinkedWithRepositoryBrowser() {
        return DTRAdminPlugin.getDefault().getPreferenceStore().getBoolean("com.tssap.dtr.client.eclipse.admin.ui.PermissionView_linkWithRepositoryBrowser");
    }

    private IRepositoryViewLegendManager getLegendManager() {
        if (this.m_legendManager == null) {
            this.m_legendManager = new IRepositoryViewLegendManager(){

                public ILegend[] getViewLegend() {
                    ArrayList<LegendElement> legendList = new ArrayList<LegendElement>();
                    legendList.add(new LegendElement("Privileges:"));
                    legendList.add(new LegendElement(PermissionViewer.IMAGE_ACCESS, "Provides access to meta-data like OPTIONS method, but no access to the contents of a folder or file"));
                    legendList.add(new LegendElement(PermissionViewer.IMAGE_READ, "Allows read access to specific resources"));
                    legendList.add(new LegendElement(PermissionViewer.IMAGE_WRITE, "No read access (ACL specification); can add/modify/delete files/folders"));
                    legendList.add(new LegendElement(PermissionViewer.IMAGE_CHECKIN, "Allows to check-in activities - applicable to the target workspace"));
                    legendList.add(new LegendElement(PermissionViewer.IMAGE_IMPORT, "Allows to import activities into the database - applicable to the root folder and ignored everywhere else"));
                    legendList.add(new LegendElement(PermissionViewer.IMAGE_EXPORT, "Allows to export activities from the database - applicable to activities and propagation lists"));
                    legendList.add(new LegendElement(PermissionViewer.IMAGE_INTEGRATE, "Allows to integrate activities to a workspace - applicable to the target workspace where the activity is to be integrated"));
                    legendList.add(new LegendElement(PermissionViewer.IMAGE_ADMINA, "Administrative category A - allows for minimal administrative tasks like creation of workspaces, etc."));
                    legendList.add(new LegendElement(PermissionViewer.IMAGE_ADMINX, "Administrative category X - allows to perform critical administrative tasks like deletion of version-history, etc."));
                    Image titleImage = PermissionView.this.getDefaultViewTitleImage();
                    if (titleImage != null) {
                        legendList.add(new LegendElement("States of Changes:"));
                        ConcreteCompositeImageDescriptor decoratedImageDescriptor = new ConcreteCompositeImageDescriptor(titleImage, 5, DECORATOR_CHANGED, 10);
                        legendList.add(new LegendElement(decoratedImageDescriptor.createImage(), "Unsaved changes on current ACL"));
                        decoratedImageDescriptor = new ConcreteCompositeImageDescriptor(titleImage, 5, DECORATOR_INACTIVE, 10);
                        legendList.add(new LegendElement(decoratedImageDescriptor.createImage(), "Inactive changes on current ACL"));
                    }
                    legendList.add(new LegendElement("Toolbar Actions:"));
                    legendList.add(new LegendElement(PermissionView.this.getPermissionViewer().getIgnoreInheritanceAction().getImageDescriptor().createImage(), "Add/remove attribute \"Ignore Inheritance\" on the current ACL"));
                    legendList.add(new LegendElement(PermissionView.this.getPermissionViewer().getSetAsFinalAction().getImageDescriptor().createImage(), "Add/remove attribute \"Final\" on the current ACL"));
                    legendList.add(new LegendElement(PermissionView.this.getPermissionViewer().getRefreshAclAction().getImageDescriptor().createImage(), "Refresh the current ACL"));
                    legendList.add(new LegendElement(PermissionView.this.getPermissionViewer().getRevertChangesAction().getImageDescriptor().createImage(), "Revert changes on the current ACL"));
                    legendList.add(new LegendElement(PermissionView.this.getPermissionViewer().getSaveAclAction().getImageDescriptor().createImage(), "Save changes of the current ACL"));
                    legendList.add(new LegendElement(PermissionView.this.getPermissionViewer().getActivateChangesAction().getImageDescriptor().createImage(), "Activate changes on all ACLs"));
                    return legendList.toArray(new ILegend[legendList.size()]);
                }

                public String getViewId() {
                    return "com.tssap.dtr.client.eclipse.admin.ui.PermissionView";
                }

                public String getViewName() {
                    return "Permissions";
                }
            };
        }
        return this.m_legendManager;
    }

    public void setFocus() {
        this.getPermissionViewer().setFocus();
    }

    public void setInput(final IVfsFolderItem folderItem) {
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                PermissionView.this.getPermissionViewer().setInput(folderItem);
            }
        });
    }

    public void setInput(final String resourceUrl) {
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                PermissionView.this.getPermissionViewer().setInput(resourceUrl);
            }
        });
    }

    public void dispose() {
        this.getPermissionViewer().removeInputChangelistener(this);
        this.getPermissionViewer().removeSelectionChangedListener(this);
        this.getPermissionViewer().registerAclListenerForCurrent(false, (IACLListener)this);
        if (VfsManagerProvider.getInstance().isSapIDELoginAvailable()) {
            VfsManagerProvider.getInstance().removeIDELoginListener((IIDELoginListener)this);
        }
        Configuration.getConfiguration().removeConfigurationListener((IConfigurationListener)this);
        super.dispose();
    }

    protected PermissionViewer getPermissionViewer() {
        return this.m_viewer;
    }

    private void showErrorMessage(String message) {
        this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(Dialog.getImage((String)"dialog_message_error_image"), message);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof IACL) {
            this.updateViewState((IACL)newInput);
        } else {
            this.updateViewState(null);
        }
        if (this.isLinkedWithRepositoryBrowser()) {
            this.linkWithRepositoryBrowser(newInput);
        }
    }

    private void linkWithRepositoryBrowser(Object aclInput) {
        TreeViewer treeViewer = this.getTreeViewerOfRepositoryBrowser();
        if (treeViewer == null) {
            return;
        }
        Object vfsManager = treeViewer.getInput();
        if (!(vfsManager instanceof IVersionedFileSystemManager)) {
            return;
        }
        String browsePath = null;
        if (aclInput instanceof IACL && (browsePath = ((IACL)aclInput).getResourcePath()) != null) {
            String prefix = "/ws/";
            browsePath = browsePath.startsWith(prefix) ? browsePath.substring(prefix.length() - 1) : null;
        }
        if (browsePath != null) {
            try {
                IVfsFolderItem folderItem = ((IVersionedFileSystemManager)vfsManager).getFolderItemByBrowsePath(browsePath);
                if (folderItem != null) {
                    treeViewer.setSelection((ISelection)new StructuredSelection((Object)folderItem), true);
                    if (treeViewer.testFindItem((Object)folderItem) != null) {
                        return;
                    }
                }
            }
            catch (VfsException x) {
                this.showErrorMessage(x.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
        }
        treeViewer.getTree().deselectAll();
    }

    private TreeViewer getTreeViewerOfRepositoryBrowser() {
        if (this.m_treeViewerOfRepositoryBrowser == null) {
            IViewSite viewSite = this.getViewSite();
            if (viewSite == null) {
                return null;
            }
            IWorkbenchWindow window = this.getViewSite().getWorkbenchWindow();
            if (window == null) {
                return null;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return null;
            }
            IViewPart part = page.findView("com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView");
            if (part == null || !(part instanceof RepositoryView)) {
                return null;
            }
            this.m_treeViewerOfRepositoryBrowser = ((RepositoryView)part).getRepositoryTreeViewer().getTreeViewer();
        }
        return this.m_treeViewerOfRepositoryBrowser;
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void added(IACL acl) {
    }

    public void activated(IACL acl) {
        if (this.getPermissionViewer().isDisposed()) {
            return;
        }
        this.getPermissionViewer().updateInactiveAclCache(acl, false);
        this.updateViewState(acl);
    }

    public void saved(IACL acl) {
        if (this.getPermissionViewer().isDisposed()) {
            return;
        }
        this.updateViewState(acl);
    }

    public void deleted(IACL acl) {
        this.getPermissionViewer().updateInactiveAclCache(acl, true);
        this.updateViewState(acl);
    }

    public void refreshed(IACL acl) {
        if (this.getPermissionViewer().isDisposed()) {
            return;
        }
        if (!this.getPermissionViewer().comesEventFromRefreshAction()) {
            this.getPermissionViewer().updateInactiveAclCache(acl, false);
        } else {
            this.getPermissionViewer().resetFlagForRefreshEvent();
        }
        this.updateViewState(acl);
    }

    public void aceAdded(IACL acl, IACE ace) {
        this.getPermissionViewer().updateInactiveAclCache(acl, true);
        this.updateViewState(acl);
    }

    public void aceRemoved(IACL acl, IACE ace) {
        this.getPermissionViewer().updateInactiveAclCache(acl, true);
        this.updateViewState(acl);
    }

    public void aceChanged(IACL acl, IACE ace) {
        this.getPermissionViewer().updateInactiveAclCache(acl, true);
        this.updateViewState(acl);
    }

    public void inheritanceChanged(IACL acl, int newType) {
        this.getPermissionViewer().updateInactiveAclCache(acl, true);
        this.updateViewState(acl);
    }

    private void updateViewState(IACL input) {
        this.m_actDeleteAcl.setEnabled(input != null);
        this.m_actRefreshAcl.setEnabled(input != null);
        this.m_actIgnoreInheritance.setEnabled(this.getPermissionViewer().isIgnoreInheritanceActionEnabled());
        this.m_actIgnoreInheritance.setChecked(input != null && input.getInheritanceType() == 3);
        this.m_actSetFinal.setEnabled(this.getPermissionViewer().isSetAsFinalActionEnabled());
        this.m_actSetFinal.setChecked(input != null && input.getInheritanceType() == 4);
        boolean isInactive = this.getPermissionViewer().isInactive(input);
        this.m_actRevert.setEnabled(isInactive);
        this.m_actSaveAcl.setEnabled(input != null && input.isChanged());
        this.m_actActivateChanges.setEnabled(this.getPermissionViewer().hasInactiveChanges());
        this.updateViewTitle(input, isInactive);
        this.updateViewTitleImage(input, isInactive);
    }

    private void updateViewTitle(IACL input, boolean isInactive) {
        String title = this.getTitle();
        if (title.indexOf(VIEW_TITLE_SEPARATOR) != -1) {
            title = title.substring(0, title.indexOf(VIEW_TITLE_SEPARATOR));
        }
        if (input != null) {
            this.setTitle(title + VIEW_TITLE_SEPARATOR + input.getResourcePath() + CLIENT_NAME_MARK_BEGIN + this.getPermissionViewer().getClientName(input) + CLIENT_NAME_MARK_END);
        } else {
            this.setTitle(title);
        }
    }

    private void updateViewTitleImage(IACL input, boolean isInactive) {
        Image titleImage = this.getDefaultViewTitleImage();
        if (titleImage == null) {
            return;
        }
        ConcreteCompositeImageDescriptor decoratedImageDescriptor = null;
        if (input != null && input.isChanged()) {
            decoratedImageDescriptor = new ConcreteCompositeImageDescriptor(titleImage, 5, DECORATOR_CHANGED, 10);
            this.setTitleToolTip("Unsaved Changes on Permission");
        } else if (input != null && isInactive) {
            decoratedImageDescriptor = new ConcreteCompositeImageDescriptor(titleImage, 5, DECORATOR_INACTIVE, 10);
            this.setTitleToolTip("Inactive Changes on Permission");
        }
        if (decoratedImageDescriptor != null) {
            titleImage = decoratedImageDescriptor.createImage();
        } else {
            this.setTitleToolTip(null);
        }
        this.setTitleImage(titleImage);
    }

    private Image getDefaultViewTitleImage() {
        if (this.m_defaultViewTitleImage == null) {
            this.m_defaultViewTitleImage = this.getTitleImage();
        }
        return this.m_defaultViewTitleImage;
    }

    public void onUserLoggedIn(String[] userAndPassword, KeyStore[] serverAndClientCerts) {
        this.getPermissionViewer().registerAclListenerForCurrent(true, (IACLListener)this);
    }

    public void onUserLoggedOut() {
    }

    public void onActiveClientChanged(IClient newClient, IClient oldClient) {
        this.getPermissionViewer().handleActiveClientChanged(newClient, oldClient, (IACLListener)this);
        this.m_treeViewerOfRepositoryBrowser = null;
    }

    public void onConfigurationChanged(IConfiguration configuration) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

