/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.admin.ui;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.admin.ui.PermissionViewer;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.lib.acl.ACLException;
import com.tssap.dtr.client.lib.acl.GrantTypes;
import com.tssap.dtr.client.lib.acl.IACE;
import com.tssap.dtr.client.lib.acl.IACL;
import com.tssap.dtr.client.lib.acl.IACLManager;
import com.tssap.dtr.client.lib.acl.PrivilegeTypes;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.um.IPrincipal;
import com.tssap.dtr.client.lib.um.IPrincipalManager;
import com.tssap.dtr.client.lib.um.PrincipalException;
import com.tssap.dtr.client.lib.um.PrincipalFactory;
import com.tssap.dtr.client.lib.um.PrincipalTypes;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class EditAceDialog
extends Dialog {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$admin$ui$EditAceDialog == null ? (class$com$tssap$dtr$client$eclipse$admin$ui$EditAceDialog = EditAceDialog.class$("com.tssap.dtr.client.eclipse.admin.ui.EditAceDialog")) : class$com$tssap$dtr$client$eclipse$admin$ui$EditAceDialog));
    private static final Integer[] PRIVILEGES = new Integer[]{new Integer(1), new Integer(2), new Integer(4), new Integer(8), new Integer(16), new Integer(32), new Integer(64), new Integer(128), new Integer(256)};
    private IACE m_ace;
    private IACL m_acl;
    private IPrincipal m_principal;
    private short m_principalType;
    private int m_grantType;
    private Label m_image;
    private Label m_message;
    private Text m_txPrincipalName;
    private Text m_txDescription;
    private CheckboxTableViewer m_tableViewer;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$admin$ui$EditAceDialog;

    public EditAceDialog(Shell parentShell, IACE ace) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        if (ace == null) {
            throw new IllegalArgumentException("Clould not initialize EditAceDialog because ACE is <null>.");
        }
        this.m_ace = ace;
        this.m_principal = this.m_ace.getPrincipal();
    }

    public EditAceDialog(Shell parentShell, IACL acl) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        if (acl == null) {
            throw new IllegalArgumentException("Clould not initialize EditAceDialog because ACL is <null>.");
        }
        this.m_acl = acl;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.m_acl != null) {
            newShell.setText("New Principal");
        } else {
            String principalName = "";
            if (this.m_principal != null) {
                principalName = this.m_principal.getType() == 3 ? "<All Users>" : this.m_principal.getName();
            }
            newShell.setText("Edit Principal [" + principalName + "]");
            this.m_grantType = this.m_ace.getGrantType();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite baseArea = (Composite)super.createDialogArea(parent);
        Composite messageArea = new Composite(baseArea, 64);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        messageArea.setLayout((Layout)gridLayout);
        messageArea.setLayoutData((Object)new GridData(768));
        this.m_image = new Label(messageArea, 0);
        this.m_image.setImage(LayoutHelper.EMPTY_IMAGE.getImage());
        this.m_image.setLayoutData((Object)new GridData());
        this.m_message = new Label(messageArea, 64);
        this.m_message.setText("");
        this.m_message.setLayoutData((Object)new GridData(768));
        Composite editArea = new Composite(baseArea, 0);
        gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        editArea.setLayout((Layout)gridLayout);
        editArea.setLayoutData((Object)new GridData(1808));
        int defaultMessageWidth = this.getMinimumMessageWidth();
        Label label = new Label(editArea, 0);
        label.setText("Principal Type:");
        Button bnUser = new Button(editArea, 16);
        bnUser.setText(PrincipalTypes.getPrincipalTypeByShort((short)1).toUpperCase());
        bnUser.setLayoutData((Object)new GridData(768));
        Button bnGroup = new Button(editArea, 16);
        bnGroup.setText(PrincipalTypes.getPrincipalTypeByShort((short)2).toUpperCase());
        bnGroup.setLayoutData((Object)new GridData(768));
        Button bnAll = new Button(editArea, 16);
        bnAll.setText(PrincipalTypes.getPrincipalTypeByShort((short)3).toUpperCase());
        bnAll.setLayoutData((Object)new GridData(768));
        label = new Label(editArea, 0);
        label.setText("Principal:");
        this.m_txPrincipalName = new Text(editArea, 2052);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.widthHint = defaultMessageWidth;
        this.m_txPrincipalName.setLayoutData((Object)gridData);
        label = new Label(editArea, 0);
        label.setText("Description:");
        label.setLayoutData((Object)new GridData(2));
        this.m_txDescription = new Text(editArea, 2624);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.heightHint = defaultMessageWidth / 6;
        this.m_txDescription.setLayoutData((Object)gridData);
        Group gpPrivileges = new Group(editArea, 0);
        gpPrivileges.setText("Privileges");
        gpPrivileges.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        gpPrivileges.setLayoutData((Object)gridData);
        Composite typeArea = new Composite((Composite)gpPrivileges, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        typeArea.setLayout((Layout)gridLayout);
        typeArea.setLayoutData((Object)new GridData(8));
        new Label(typeArea, 0).setLayoutData((Object)new GridData(1040));
        label = new Label(typeArea, 0);
        label.setText("Types:");
        Button bnTypeGrant = new Button(typeArea, 16);
        bnTypeGrant.setText(GrantTypes.getGrantTypeByInt((int)1).toUpperCase());
        Button bnTypeDeny = new Button(typeArea, 16);
        bnTypeDeny.setText(GrantTypes.getGrantTypeByInt((int)2).toUpperCase());
        Button bnTypeFinalDeny = new Button(typeArea, 16);
        bnTypeFinalDeny.setText("FINAL DENY (obsolete)");
        bnTypeFinalDeny.setEnabled(false);
        Composite privisArea = new Composite((Composite)gpPrivileges, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        privisArea.setLayout((Layout)gridLayout);
        privisArea.setLayoutData((Object)new GridData(1808));
        Table table = new Table(privisArea, 2848);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        TableColumn column = new TableColumn(table, 0, 0);
        column.setText("Privilege");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(110));
        column = new TableColumn(table, 0, 1);
        column.setText("Explanation");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(250));
        this.m_tableViewer = new CheckboxTableViewer(table);
        gridData = new GridData(1808);
        gridData.heightHint = 157;
        this.m_tableViewer.getTable().setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.m_tableViewer.setContentProvider((IContentProvider)new PrivilegesContentProvider());
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)new PrivilegesLabelProvider());
        if (this.m_acl != null) {
            this.m_tableViewer.setInput((Object)this.m_acl);
        } else {
            this.m_tableViewer.setInput((Object)this.m_ace);
        }
        if (this.m_acl != null) {
            bnUser.setSelection(true);
            this.m_principalType = 1;
            bnTypeGrant.setSelection(true);
            this.m_grantType = 1;
            this.m_txPrincipalName.setFocus();
        } else {
            String name = "";
            if (this.m_principal != null) {
                name = this.m_principal.getType() == 3 ? "<All Users>" : this.m_principal.getName();
                this.m_principalType = this.m_principal.getType();
                switch (this.m_principalType) {
                    case 1: {
                        bnUser.setSelection(true);
                        break;
                    }
                    case 2: {
                        bnGroup.setSelection(true);
                        break;
                    }
                    case 3: {
                        bnAll.setSelection(true);
                    }
                }
            }
            this.m_txPrincipalName.setText(name);
            if ("<All Users>".equals(name)) {
                this.m_txPrincipalName.setEditable(false);
                this.m_txDescription.setFocus();
            }
            this.m_txDescription.setText(this.m_ace.getDescription() == null ? "" : this.m_ace.getDescription());
            if (this.m_ace.getGrantType() != 0) {
                bnTypeGrant.setSelection(this.m_ace.getGrantType() == 1);
                bnTypeDeny.setSelection(this.m_ace.getGrantType() == 2);
                bnTypeFinalDeny.setSelection(this.m_ace.getGrantType() == 3);
                if (this.m_ace.getGrantType() == 3) {
                    this.showMessage("Grant type \"FINAL DENY\" is obsolete.", 2);
                }
            } else {
                bnTypeGrant.setSelection(true);
                this.m_grantType = 1;
            }
            this.m_tableViewer.setCheckedElements((Object[])this.getPrivilegeViewerObjects(this.m_ace.getPrivilege()));
        }
        bnAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditAceDialog.this.m_principalType = (short)3;
                EditAceDialog.this.m_txPrincipalName.setText("<All Users>");
                EditAceDialog.this.m_txPrincipalName.setEditable(false);
                EditAceDialog.this.m_txDescription.setFocus();
                EditAceDialog.this.m_txDescription.selectAll();
            }
        });
        bnGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditAceDialog.this.m_principalType = (short)2;
                if ("".equals(EditAceDialog.this.getPrincipalName()) || "<All Users>".equalsIgnoreCase(EditAceDialog.this.getPrincipalName()) || "[User Name]".equalsIgnoreCase(EditAceDialog.this.getPrincipalName())) {
                    EditAceDialog.this.m_txPrincipalName.setText("[Group Name]");
                }
                EditAceDialog.this.m_txPrincipalName.setEditable(true);
                EditAceDialog.this.m_txPrincipalName.setFocus();
                EditAceDialog.this.m_txPrincipalName.selectAll();
                EditAceDialog.this.clearMessageArea();
            }
        });
        bnUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditAceDialog.this.m_principalType = (short)1;
                if ("".equals(EditAceDialog.this.getPrincipalName()) || "<All Users>".equalsIgnoreCase(EditAceDialog.this.getPrincipalName()) || "[Group Name]".equalsIgnoreCase(EditAceDialog.this.getPrincipalName())) {
                    EditAceDialog.this.m_txPrincipalName.setText("[User Name]");
                }
                EditAceDialog.this.m_txPrincipalName.setEditable(true);
                EditAceDialog.this.m_txPrincipalName.setFocus();
                EditAceDialog.this.m_txPrincipalName.selectAll();
                EditAceDialog.this.clearMessageArea();
            }
        });
        this.m_txPrincipalName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditAceDialog.this.clearMessageArea();
            }
        });
        this.m_txDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditAceDialog.this.clearMessageArea();
            }
        });
        bnTypeGrant.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditAceDialog.this.m_grantType = 1;
                EditAceDialog.this.clearMessageArea();
            }
        });
        bnTypeDeny.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditAceDialog.this.m_grantType = 2;
                EditAceDialog.this.clearMessageArea();
            }
        });
        bnTypeFinalDeny.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditAceDialog.this.m_grantType = 3;
                EditAceDialog.this.clearMessageArea();
            }
        });
        this.m_tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                EditAceDialog.this.clearMessageArea();
            }
        });
        return baseArea;
    }

    private int getMinimumMessageWidth() {
        return this.convertHorizontalDLUsToPixels(300);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String name = this.getPrincipalName().trim();
            if (name.equals("")) {
                this.showErrorMessage("Principal name must not be empty.");
                return;
            }
            if (name.equals("<All Users>") && this.getPrincipalType() != 3) {
                this.showErrorMessage("\"<All Users>\" is reserved. Please choose another principal name.");
                return;
            }
            IPrincipalManager principalManager = this.getPrincipalManager();
            if (principalManager == null) {
                return;
            }
            this.m_principal = this.getPrincipalType() == 1 ? principalManager.getUser(name) : (this.getPrincipalType() == 2 ? principalManager.getGroup(name) : principalManager.getPrincipal(this.getPrincipalType()));
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        if (EditAceDialog.this.m_acl != null) {
                            EditAceDialog.this.m_ace = EditAceDialog.this.m_acl.createACE(EditAceDialog.this.m_principal, EditAceDialog.this.getDescription(), EditAceDialog.this.getGrantType(), EditAceDialog.this.getSelectedPrivilege());
                        } else {
                            EditAceDialog.this.m_ace.setProperties(EditAceDialog.this.m_principal, EditAceDialog.this.getDescription(), EditAceDialog.this.getGrantType(), EditAceDialog.this.getSelectedPrivilege());
                        }
                    }
                    catch (ACLException x) {
                        EditAceDialog.this.showErrorMessage(x.getMessage());
                        LogUtil.logException((Location)LOCATION, (Throwable)x);
                    }
                }
            });
        }
        super.buttonPressed(buttonId);
    }

    private Image getPrivilegeImage(int privilege) {
        switch (privilege) {
            case 1: {
                return PermissionViewer.IMAGE_ACCESS;
            }
            case 2: {
                return PermissionViewer.IMAGE_READ;
            }
            case 4: {
                return PermissionViewer.IMAGE_WRITE;
            }
            case 8: {
                return PermissionViewer.IMAGE_CHECKIN;
            }
            case 16: {
                return PermissionViewer.IMAGE_IMPORT;
            }
            case 32: {
                return PermissionViewer.IMAGE_EXPORT;
            }
            case 64: {
                return PermissionViewer.IMAGE_INTEGRATE;
            }
            case 128: {
                return PermissionViewer.IMAGE_ADMINA;
            }
            case 256: {
                return PermissionViewer.IMAGE_ADMINX;
            }
        }
        return null;
    }

    private Integer[] getPrivilegeViewerObjects(int privilege) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < PRIVILEGES.length) {
            if (PrivilegeTypes.privilegeMatch((int)PRIVILEGES[i], (int)privilege)) {
                list.add(PRIVILEGES[i]);
            }
            ++i;
        }
        return list.toArray(new Integer[list.size()]);
    }

    private String getPrincipalName() {
        return this.m_txPrincipalName.getText();
    }

    private short getPrincipalType() {
        return this.m_principalType;
    }

    private String getDescription() {
        return this.m_txDescription.getText();
    }

    private int getGrantType() {
        return this.m_grantType;
    }

    private int getSelectedPrivilege() {
        Object[] selections = this.m_tableViewer.getCheckedElements();
        int privilege = 0;
        int i = 0;
        while (i < selections.length) {
            if (selections[i] instanceof Integer) {
                privilege += ((Integer)selections[i]).intValue();
            }
            ++i;
        }
        return privilege;
    }

    protected IPrincipalManager getPrincipalManager() {
        IVersionedFileSystemManager vfsManager;
        IACLManager aclManager;
        IACL acl = this.m_acl != null ? this.m_acl : this.m_ace.getACL();
        if (acl != null && (aclManager = acl.getACLManager()) != null && (vfsManager = aclManager.getVfsManager()) != null) {
            try {
                return PrincipalFactory.getPrincipalManager((IVersionedFileSystemManager)vfsManager);
            }
            catch (PrincipalException x) {
                this.showErrorMessage("Getting principal manager failed: " + x.getMessage());
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
        }
        return null;
    }

    private void showErrorMessage(String message) {
        this.showMessage(message, 3);
    }

    private void showMessage(String message, int messageType) {
        Button okButton = this.getButton(0);
        if (messageType == 3) {
            this.m_message.setForeground(this.getShell().getDisplay().getSystemColor(3));
            this.m_message.setBackground(this.getShell().getDisplay().getSystemColor(22));
            if (okButton != null) {
                okButton.setEnabled(false);
            }
        } else {
            this.m_message.setForeground(this.getShell().getDisplay().getSystemColor(28));
            this.m_message.setBackground(this.getShell().getDisplay().getSystemColor(29));
            if (okButton != null) {
                okButton.setEnabled(true);
            }
        }
        this.m_message.setText(message);
        switch (messageType) {
            case 3: {
                this.m_image.setImage(Dialog.getImage((String)"dialog_message_error_image"));
                break;
            }
            case 2: {
                this.m_image.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
                break;
            }
            case 1: {
                this.m_image.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
            }
        }
    }

    private void clearMessageArea() {
        this.m_image.setText("");
        this.m_message.setText("");
        this.m_message.setForeground(this.getShell().getDisplay().getSystemColor(28));
        this.m_message.setBackground(this.getShell().getDisplay().getSystemColor(22));
        this.getButton(0).setEnabled(true);
    }

    public IACE getModifiedAce() {
        return this.m_ace;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PrivilegesLabelProvider
    implements ITableLabelProvider {
        private PrivilegesLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Integer) {
                if (columnIndex == 0) {
                    Vector names = PrivilegeTypes.getPrivilegeNamesByInt((int)((Integer)element));
                    Iterator iter = ((AbstractList)names).iterator();
                    if (iter.hasNext()) {
                        return (String)iter.next();
                    }
                } else if (columnIndex == 1) {
                    int privilege = (Integer)element;
                    switch (privilege) {
                        case 1: {
                            return "Provides access to meta-data like OPTIONS method, but no access to the contents of a folder or file";
                        }
                        case 2: {
                            return "Allows read access to specific resources";
                        }
                        case 4: {
                            return "No read access (ACL specification); can add/modify/delete files/folders";
                        }
                        case 8: {
                            return "Allows to check-in activities - applicable to the target workspace";
                        }
                        case 16: {
                            return "Allows to import activities into the database - applicable to the root folder and ignored everywhere else";
                        }
                        case 32: {
                            return "Allows to export activities from the database - applicable to activities and propagation lists";
                        }
                        case 64: {
                            return "Allows to integrate activities to a workspace - applicable to the target workspace where the activity is to be integrated";
                        }
                        case 128: {
                            return "Administrative category A - allows for minimal administrative tasks like creation of workspaces, etc.";
                        }
                        case 256: {
                            return "Administrative category X - allows to perform critical administrative tasks like deletion of version-history, etc.";
                        }
                    }
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof Integer) {
                return EditAceDialog.this.getPrivilegeImage((Integer)element);
            }
            return null;
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class PrivilegesContentProvider
    implements IStructuredContentProvider {
        private PrivilegesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IACE || inputElement instanceof IACL) {
                return PRIVILEGES;
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

