/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.xml;

import com.sap.tc.logging.Location;
import com.tssap.util.xml.DOMCreatorI;
import com.tssap.util.xml.DOMParserI;
import com.tssap.util.xml.DOMSerializerI;
import com.tssap.util.xml.DOMTransformerI;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

final class DOMAccessApache
implements DOMCreatorI,
DOMParserI,
DOMTransformerI,
DOMSerializerI {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$tssap$util$xml$DOMAccessApache == null ? (class$com$tssap$util$xml$DOMAccessApache = DOMAccessApache.class$("com.tssap.util.xml.DOMAccessApache")) : class$com$tssap$util$xml$DOMAccessApache).getName());
    private static final String APACHE_XERCES_DOMCREATOR = "org.apache.xerces.dom.DOMImplementationImpl";
    private static final String APACHE_XERCES_DOMPARSER = "org.apache.xerces.parsers.DOMParser";
    private static final String APACHE_DOMSERIALIZER = "org.apache.xml.serialize.XMLSerializer";
    private static final String APACHE_XALAN_DOMTRANSFORMER = "org.apache.xalan.processor.TransformerFactoryImpl";
    private Transformer mTransformer = null;
    static /* synthetic */ Class class$com$tssap$util$xml$DOMAccessApache;

    DOMAccessApache() {
    }

    public int getImplementation() {
        TRACE_LOCATION.entering("getImplementation()");
        return 1;
    }

    public Document create(String namespaceURI, String rootName) throws Throwable {
        TRACE_LOCATION.entering("create(java.lang.String, java.lang.String)");
        Document lDocument = null;
        Class<?> lDOMImplementationImplClass = Class.forName(APACHE_XERCES_DOMCREATOR);
        Object lDOMImplementationImplObject = null;
        Class[] lParameterTypes = new Class[]{};
        Constructor<?> lConstructor = lDOMImplementationImplClass.getConstructor(lParameterTypes);
        Object[] lParameters = new Object[]{};
        lDOMImplementationImplObject = lConstructor.newInstance(lParameters);
        lParameterTypes = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("org.w3c.dom.DocumentType")};
        Method lMethod = lDOMImplementationImplClass.getMethod("createDocument", lParameterTypes);
        lParameters = new Object[]{namespaceURI, rootName, null};
        lDocument = (Document)lMethod.invoke(lDOMImplementationImplObject, lParameters);
        return lDocument;
    }

    public Document parse(String filePath, boolean normalize) throws Throwable {
        TRACE_LOCATION.entering("parse(java.lang.String, boolean)");
        Document lDocument = null;
        Class<?> lParserClass = Class.forName(APACHE_XERCES_DOMPARSER);
        Object lParserObject = null;
        lParserObject = lParserClass.newInstance();
        Class[] lParameterTypes = new Class[]{Class.forName("java.lang.String")};
        Method lMethod = lParserClass.getMethod("parse", lParameterTypes);
        Object[] lParameters = new Object[]{filePath};
        lMethod.invoke(lParserObject, lParameters);
        lParameterTypes = new Class[]{};
        lMethod = lParserClass.getMethod("getDocument", lParameterTypes);
        lParameters = new Object[]{};
        lDocument = (Document)lMethod.invoke(lParserObject, lParameters);
        if (normalize) {
            lDocument.normalize();
        }
        return lDocument;
    }

    public Document parse(InputStream inputStream, boolean normalize) throws Throwable {
        TRACE_LOCATION.entering("parse(java.io.InputStream, boolean)");
        return this.parse(new InputSource(inputStream), normalize);
    }

    public Document parse(Reader characterStream, boolean normalize) throws Throwable {
        TRACE_LOCATION.entering("parse(java.io.Reader, boolean)");
        return this.parse(new InputSource(characterStream), normalize);
    }

    public Document parse(InputSource inputSource, boolean normalize) throws Throwable {
        TRACE_LOCATION.entering("parse(org.xml.sax.InputSource, boolean)");
        Class<?> lParserClass = Class.forName(APACHE_XERCES_DOMPARSER);
        Document lDocument = null;
        Object lParserObject = null;
        lParserObject = lParserClass.newInstance();
        Class[] lParameterTypes = new Class[]{Class.forName("org.xml.sax.InputSource")};
        Method lMethod = lParserClass.getMethod("parse", lParameterTypes);
        Object[] lParameters = new Object[]{inputSource};
        lMethod.invoke(lParserObject, lParameters);
        lParameterTypes = new Class[]{};
        lMethod = lParserClass.getMethod("getDocument", lParameterTypes);
        lParameters = new Object[]{};
        lDocument = (Document)lMethod.invoke(lParserObject, lParameters);
        if (normalize) {
            lDocument.normalize();
        }
        return lDocument;
    }

    public void transform(String xmlFilePath, String resultFilePath) throws Throwable {
        TRACE_LOCATION.entering("transform(java.lang.String, java.lang.String)");
        if (this.mTransformer != null) {
            this.mTransformer.transform(new StreamSource(xmlFilePath), new StreamResult(resultFilePath));
        }
    }

    public void transform(String xmlFilePath, OutputStream resultOutputStream) throws Throwable {
        TRACE_LOCATION.entering("transform(java.lang.String, java.io.OutputStream)");
        if (this.mTransformer != null) {
            this.mTransformer.transform(new StreamSource(xmlFilePath), new StreamResult(resultOutputStream));
        }
    }

    public void transform(String xmlFilePath, Writer resultCharacterStream) throws Throwable {
        TRACE_LOCATION.entering("transform(java.lang.String, java.io.Writer)");
        if (this.mTransformer != null) {
            this.mTransformer.transform(new StreamSource(xmlFilePath), new StreamResult(resultCharacterStream));
        }
    }

    public void transform(String xmlFilePath, Result result) throws Throwable {
        TRACE_LOCATION.entering("transform(java.lang.String, javax.xml.transform.Result)");
        if (this.mTransformer != null) {
            this.mTransformer.transform(new StreamSource(xmlFilePath), result);
        }
    }

    public void transform(Source xmlSource, String resultFilePath) throws Throwable {
        TRACE_LOCATION.entering("transform(javax.xml.transform.Source, java.lang.String)");
        if (this.mTransformer != null) {
            this.mTransformer.transform(xmlSource, new StreamResult(resultFilePath));
        }
    }

    public void transform(Source xmlSource, OutputStream resultOutputStream) throws Throwable {
        TRACE_LOCATION.entering("transform(javax.xml.transform.Source, java.io.OutputStream)");
        if (this.mTransformer != null) {
            this.mTransformer.transform(xmlSource, new StreamResult(resultOutputStream));
        }
    }

    public void transform(Source xmlSource, Writer resultCharacterStream) throws Throwable {
        TRACE_LOCATION.entering("transform(javax.xml.transform.Source, java.io.Writer)");
        if (this.mTransformer != null) {
            this.mTransformer.transform(xmlSource, new StreamResult(resultCharacterStream));
        }
    }

    public void transform(Source xmlSource, Result result) throws Throwable {
        TRACE_LOCATION.entering("transform(javax.xml.transform.Source, javax.xml.transform.Result)");
        if (this.mTransformer != null) {
            this.mTransformer.transform(xmlSource, result);
        }
    }

    public void transform(InputStream xmlInputStream, String resultFilePath) throws Throwable {
        TRACE_LOCATION.entering("transform(java.io.InputStream, java.lang.String)");
        if (this.mTransformer != null) {
            this.mTransformer.transform(new StreamSource(xmlInputStream), new StreamResult(resultFilePath));
        }
    }

    public void transform(InputStream xmlInputStream, OutputStream resultOutputStream) throws Throwable {
        TRACE_LOCATION.entering("transform(java.io.InputStream, java.io.OutputStream)");
        if (this.mTransformer != null) {
            this.mTransformer.transform(new StreamSource(xmlInputStream), new StreamResult(resultOutputStream));
        }
    }

    public void transform(InputStream xmlInputStream, Writer resultCharacterStream) throws Throwable {
        TRACE_LOCATION.entering("transform(java.io.InputStream, java.io.Writer)");
        if (this.mTransformer != null) {
            this.mTransformer.transform(new StreamSource(xmlInputStream), new StreamResult(resultCharacterStream));
        }
    }

    public void transform(InputStream xmlInputStream, Result result) throws Throwable {
        TRACE_LOCATION.entering("transform(java.io.InputStream, javax.xml.transform.Result)");
        if (this.mTransformer != null) {
            this.mTransformer.transform(new StreamSource(xmlInputStream), result);
        }
    }

    public void transform(Reader xmlCharacterStream, String resultFilePath) throws Throwable {
        TRACE_LOCATION.entering("transform(java.io.Reader, java.lang.String)");
        if (this.mTransformer != null) {
            this.mTransformer.transform(new StreamSource(xmlCharacterStream), new StreamResult(resultFilePath));
        }
    }

    public void transform(Reader xmlCharacterStream, OutputStream resultOutputStream) throws Throwable {
        TRACE_LOCATION.entering("transform(java.io.Reader, java.io.OutputStream)");
        if (this.mTransformer != null) {
            this.mTransformer.transform(new StreamSource(xmlCharacterStream), new StreamResult(resultOutputStream));
        }
    }

    public void transform(Reader xmlCharacterStream, Writer resultCharacterStream) throws Throwable {
        TRACE_LOCATION.entering("transform(java.io.Reader, java.io.Writer)");
        if (this.mTransformer != null) {
            this.mTransformer.transform(new StreamSource(xmlCharacterStream), new StreamResult(resultCharacterStream));
        }
    }

    public void transform(Reader xmlCharacterStream, Result result) throws Throwable {
        TRACE_LOCATION.entering("transform(java.io.Reader, javax.xml.transform.Result)");
        if (this.mTransformer != null) {
            this.mTransformer.transform(new StreamSource(xmlCharacterStream), result);
        }
    }

    Transformer getTransformer(StreamSource xslStreamSource) throws Throwable {
        TRACE_LOCATION.entering("getTransformer(javax.xml.transform.stream.StreamSource)");
        TransformerFactory lTransformerFactory = this.getTransformerFactory();
        this.mTransformer = lTransformerFactory.newTransformer(xslStreamSource);
        return this.mTransformer;
    }

    Transformer getTransformer(InputStream xslInputStream) throws Throwable {
        TRACE_LOCATION.entering("getTransformer(java.io.InputStream)");
        TransformerFactory lTransformerFactory = this.getTransformerFactory();
        StreamSource lStreamSource = new StreamSource(xslInputStream);
        this.mTransformer = lTransformerFactory.newTransformer(lStreamSource);
        return this.mTransformer;
    }

    Transformer getTransformer(Reader xslCharacterStream) throws Throwable {
        TRACE_LOCATION.entering("getTransformer(java.io.Reader)");
        TransformerFactory lTransformerFactory = this.getTransformerFactory();
        StreamSource lStreamSource = new StreamSource(xslCharacterStream);
        this.mTransformer = lTransformerFactory.newTransformer(lStreamSource);
        return this.mTransformer;
    }

    Transformer getTransformer(String xslFilePath) throws Throwable {
        TRACE_LOCATION.entering("getTransformer(java.lang.String)");
        TransformerFactory lTransformerFactory = this.getTransformerFactory();
        this.mTransformer = lTransformerFactory.newTransformer(new StreamSource(xslFilePath));
        return this.mTransformer;
    }

    private TransformerFactory getTransformerFactory() throws Throwable {
        TRACE_LOCATION.entering("getTransformerFactory()");
        Class<?> lTransformerFactoryImplClass = Class.forName(APACHE_XALAN_DOMTRANSFORMER);
        return (TransformerFactory)lTransformerFactoryImplClass.newInstance();
    }

    public void setParameter(String parameterName, Object valueObject) {
        TRACE_LOCATION.entering("setParameter(java.lang.String, java.lang.Object)");
        this.mTransformer.setParameter(parameterName, valueObject);
    }

    public Object getParameter(String parameterName) {
        TRACE_LOCATION.entering("getParameter(java.lang.String)");
        return this.mTransformer.getParameter(parameterName);
    }

    public void clearParameters() {
        TRACE_LOCATION.entering("clearParameters()");
        this.mTransformer.clearParameters();
    }

    public void serialize(Document document, String filePath) throws Throwable {
        TRACE_LOCATION.entering("serialize(org.w3c.dom.Document, java.lang.String)");
        FileOutputStream lFileOutputStream = new FileOutputStream(filePath);
        this.serialize(document, lFileOutputStream);
        lFileOutputStream.close();
    }

    public void serialize(Document document, OutputStream outputStream) throws Throwable {
        TRACE_LOCATION.entering("serialize(org.w3c.dom.Document, java.io.OutputStream)");
        Class<?> lSerializerClass = Class.forName(APACHE_DOMSERIALIZER);
        Object lSerializerObject = null;
        lSerializerObject = lSerializerClass.newInstance();
        Class[] lParameterTypes = new Class[]{Class.forName("java.io.OutputStream")};
        Method lMethod = lSerializerClass.getMethod("setOutputByteStream", lParameterTypes);
        Object[] lParameters = new Object[]{outputStream};
        lMethod.invoke(lSerializerObject, lParameters);
        lParameterTypes = new Class[]{Class.forName("org.w3c.dom.Document")};
        lMethod = lSerializerClass.getMethod("serialize", lParameterTypes);
        lParameters = new Object[]{document};
        lMethod.invoke(lSerializerObject, lParameters);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

